/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.tsaip.audit.persistence.dao;

import cn.com.starit.common.persistence.GenericHibernateDao;
import cn.com.starit.common.persistence.Page;
import cn.com.starit.common.util.StringUtil;
import cn.com.starit.tsaip.audit.dto.AipMessageDto;
import cn.com.starit.tsaip.audit.persistence.entity.AipMessage;
import cn.com.starit.tsaip.register.dto.StaticDataDto;
import cn.com.starit.tsaip.register.util.ConfigControl;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.SQLQuery;

public class AipMessageDao
extends GenericHibernateDao<AipMessage, Long> {
    public Query querySQL(AipMessageDto dto, int flag) {
        String hqlPrev = "select bean.msg_Id,bean.region_Id,bean.send_System,bean.receive_System,bean.service_State,bean.resend_Count,bean.request_Time,bean.response_Time,config0.serv_man_name sendSystemName,config1.serv_man_name receiveSystemName,bean.receive_Time,c.businname,reg.serv_Name,bean.send_Time,bean.csb_Id,bean.msg_size,bean.response_size,bean.id,bean.resend_flag ";
        String hql = " from Aip_Message bean left join serv_afford_man_reg reg on bean.SERV_code = reg.serv_code left join serv_afford_man_config config0 on bean.send_System = config0.serv_man_code left join serv_afford_man_config config1 on bean.receive_System = config1.serv_man_code,Bndict_T_Dictionary c where bean.service_State = c.businid and c.busintypeid = 'SERVICE_STATE'";
        HashMap<String, Date> map = new HashMap<String, Date>();
        if (dto != null) {
            if (dto.getBeginTime() != null) {
                map.put("BeginTime", dto.getBeginTime());
            }
            if (dto.getEndTime() != null) {
                map.put("EndTime", dto.getEndTime());
            }
        } else {
            Date endTime = new Date();
            long minis = endTime.getTime();
            Date beginTime = new Date(minis -= 86400000L);
            map.put("BeginTime", beginTime);
            map.put("EndTime", endTime);
        }
        if (dto != null && !"".equals(dto.getReceiveSystem()) && !"\u8bf7\u9009\u62e9\u2026".equals(dto.getReceiveSystem())) {
            String sql = "select serv_Man_Code from Serv_Afford_Man_Config where SERV_MAN_ID = ";
            List list = this.findBySQL(sql = sql + dto.getReceiveSystem(), new Object[0]);
            if (list.size() != 0) {
                hql = hql + " and bean.receive_System ='" + list.get(0) + "'";
            }
        }
        hql = hql + (dto == null || dto.getRegionId() == 0L ? "" : " and bean.region_Id = " + dto.getRegionId());
        hql = hql + (dto == null || "".equals(dto.getSendSystem().trim()) || "\u8bf7\u9009\u62e9\u2026".equals(dto.getSendSystem()) ? "" : " and bean.send_System =  '" + dto.getSendSystem() + "'");
        hql = hql + (dto == null || dto.getServId() == 0L ? "" : " and reg.serv_Id = " + dto.getServId());
        hql = hql + (dto == null || "".equals(dto.getMsgId().trim()) ? "" : " and bean.msg_Id = '" + dto.getMsgId() + "'");
        hql = hql + (map.get("BeginTime") == null ? " " : " and bean.receive_Time >= cast(:BeginTime as datetime year to fraction(5)) ");
        hql = hql + (map.get("EndTime") == null ? " " : " and bean.receive_Time < cast(:EndTime as datetime year to fraction(5)) ");
        hql = hql + (dto == null || dto.getServiceState() == 0L ? "" : " and bean.service_State = " + dto.getServiceState());
        hql = hql + (dto == null || "".equals(dto.getBusinid()) ? "" : "  and c.businid = '" + dto.getBusinid() + "'");
        if (dto != null && dto.getResendFlag() != 0 && dto.getResendFlag() != 1) {
            int resendFlag = dto.getResendFlag();
            if (resendFlag == 2) {
                hql = hql + " and bean.resend_Count > 0 ";
            } else if (resendFlag == 3) {
                hql = hql + " and bean.resend_Count = 0 ";
            }
        }
        hql = hql + " and bean.conn_Flag != 2  ";
        String hqlOrder = " order by bean.receive_Time desc";
        String hqlCount = "select count(*) from (" + hqlPrev + hql + ")";
        Query query = this.createSQLQuery(hqlPrev + hql + hqlOrder, map);
        Query queryCount = this.createSQLQuery(hqlCount, map);
        return flag == 1 ? query : queryCount;
    }

    public SQLQuery querySQL4oracle(AipMessageDto dto, int flag) {
        List list;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String hql = "SELECT  /*+ FIRST_ROWS*/ aipmessage0_.MSG_ID        AS col_0_0_, aipmessage0_.REGION_ID     AS col_1_0_, servafford1_.SERV_MAN_CODE AS col_2_0_, servafford2_.SERV_MAN_CODE AS col_3_0_, aipmessage0_.SERVICE_STATE AS col_4_0_, aipmessage0_.RESEND_COUNT  AS col_5_0_, aipmessage0_.REQUEST_TIME  AS col_6_0_, aipmessage0_.RESPONSE_TIME AS col_7_0_, servafford1_.SERV_MAN_NAME AS col_8_0_, servafford2_.SERV_MAN_NAME AS col_9_0_, aipmessage0_.RECEIVE_TIME  AS col_10_0_, bndicttdic4_.BUSINNAME     AS col_11_0_, servafford3_.SERV_NAME     AS col_12_0_, aipmessage0_.SEND_TIME     AS col_13_0_, aipmessage0_.CSB_ID        AS col_14_0_, aipmessage0_.request_size AS col_15_0_,aipmessage0_.response_size        AS col_16_0_, aipmessage0_.id AS col_17_0,aipmessage0_.RESEND_FLAG as col_18_0 ";
        String param = " FROM aip_message aipmessage0_, SERV_AFFORD_MAN_CONFIG      servafford1_, SERV_AFFORD_MAN_CONFIG      servafford2_, SERV_AFFORD_MAN_REG         servafford3_, BNDICT_T_DICTIONARY         bndicttdic4_ WHERE aipmessage0_.SEND_SYSTEM = servafford1_.SERV_MAN_CODE(+) AND aipmessage0_.RECEIVE_SYSTEM = servafford2_.SERV_MAN_CODE(+) AND aipmessage0_.SERV_ID = servafford3_.SERV_ID(+) AND aipmessage0_.SERVICE_STATE = bndicttdic4_.BUSINID AND bndicttdic4_.BUSINTYPEID = 'SERVICE_STATE' AND aipmessage0_.CONN_FLAG <> 2 ";
        String orderBySql = " order by aipmessage0_.RECEIVE_TIME  desc";
        String sql = "select serv_Man_Code from Serv_Afford_Man_Config where SERV_MAN_ID = ";
        HashMap<String, Date> map = new HashMap<String, Date>();
        if (dto != null) {
            if (dto.getBeginTime() != null) {
                map.put("BeginTime", dto.getBeginTime());
            }
            if (dto.getEndTime() != null) {
                map.put("EndTime", dto.getEndTime());
            }
        } else {
            Date endTime = new Date();
            long minis = endTime.getTime();
            Date beginTime = new Date(minis -= 86400000L);
            map.put("BeginTime", beginTime);
            map.put("EndTime", endTime);
        }
        if (dto != null && !"".equals(dto.getReceiveSystem()) && !"\u8bf7\u9009\u62e9\u2026".equals(dto.getReceiveSystem()) && (list = this.findBySQL(sql = sql + dto.getReceiveSystem(), new Object[0])).size() != 0) {
            param = param + " and aipmessage0_.receive_system ='" + list.get(0) + "'";
        }
        param = param + (dto == null || dto.getRegionId() == 0L ? "" : " and aipmessage0_.region_id = " + dto.getRegionId());
        param = param + (dto == null || "".equals(dto.getSendSystem().trim()) || "\u8bf7\u9009\u62e9\u2026".equals(dto.getSendSystem()) ? "" : " and aipmessage0_.send_system =  '" + dto.getSendSystem() + "'");
        param = param + (dto == null || dto.getServId() == 0L ? "" : " and servafford3_.serv_id = " + dto.getServId());
        param = param + (dto == null || "".equals(dto.getMsgId().trim()) ? "" : " and aipmessage0_.msg_id = '" + dto.getMsgId() + "'");
        param = param + (map.get("BeginTime") == null ? " " : " and aipmessage0_.receive_time >= to_date('" + sdf.format(map.get("BeginTime")) + "','yyyy-mm-dd hh24:mi:ss') ");
        param = param + (map.get("EndTime") == null ? " " : " and aipmessage0_.receive_time < to_date('" + sdf.format(map.get("EndTime")) + "','yyyy-mm-dd hh24:mi:ss') ");
        if (dto != null && dto.getServiceState() != 0L) {
            param = param + " and aipmessage0_.service_state = " + dto.getServiceState();
        }
        if (dto != null && !"".equals(dto.getBusinid())) {
            param = param + "  and bndicttdic4_.BUSINID = '" + dto.getBusinid() + "'";
            orderBySql = " order by bndicttdic4_.BUSINID desc";
        }
        if (dto != null && dto.getResendFlag() != 0 && dto.getResendFlag() != 1) {
            int resendFlag = dto.getResendFlag();
            if (resendFlag == 2) {
                param = param + " and aipmessage0_.resend_count > 0 ";
                orderBySql = " order by aipmessage0_.resend_count desc";
            } else if (resendFlag == 3) {
                param = param + " and aipmessage0_.resend_count = 0 ";
            }
        }
        Integer maxCount = ConfigControl.getStConfigCache().getConfigValue((Object)"MAX_MSG_SEARCH_NUM") == null ? Integer.valueOf(10000) : (String)ConfigControl.getStConfigCache().getConfigValue((Object)"MAX_MSG_SEARCH_NUM");
        String hqlCount = "select count(*) from (" + hql + param + ")" + " where rownum<=" + StringUtil.getLongFrom((Object)maxCount);
        hql = hql + param + orderBySql;
        SQLQuery query = (SQLQuery)this.createSQLQuery(hql, null);
        SQLQuery queryCount = (SQLQuery)this.createSQLQuery(hqlCount, null);
        return flag == 1 ? query : queryCount;
    }

    public Query connQuerySQL(AipMessageDto dto, int flag) {
        String hqlPrev = "select bean.msg_Id,bean.region_Id,bean.send_System,bean.receive_System,bean.service_State,bean.resend_Count,bean.request_Time,bean.response_Time,bean.receive_Time,c.businname,reg.conn_serv_Name,bean.send_Time,bean.csb_Id ,bean.host,reg.conn_route_plat_code,bean.id,bean.resend_flag ";
        String hql = " from Aip_Message_Conn bean left join conn_serv_reg reg on bean.SERV_code = reg.conn_serv_code ,Bndict_T_Dictionary c where bean.service_State = c.businid and c.busintypeid = 'SERVICE_STATE'";
        HashMap<String, Date> map = new HashMap<String, Date>();
        if (dto != null) {
            if (dto.getBeginTime() != null) {
                map.put("BeginTime", dto.getBeginTime());
            }
            if (dto.getEndTime() != null) {
                map.put("EndTime", dto.getEndTime());
            }
        } else {
            Date endTime = new Date();
            long minis = endTime.getTime();
            Date beginTime = new Date(minis -= 86400000L);
            map.put("BeginTime", beginTime);
            map.put("EndTime", endTime);
        }
        hql = hql + (dto == null || "".equals(dto.getConnRoutePlatCode().trim()) ? "" : " and reg.conn_route_plat_code='" + dto.getConnRoutePlatCode() + "'");
        hql = hql + (dto == null || dto.getRegionId() == 0L ? "" : " and bean.region_Id = " + dto.getRegionId());
        hql = hql + (dto == null || "".equals(dto.getSendSystem().trim()) || "\u8bf7\u9009\u62e9\u2026".equals(dto.getSendSystem()) ? "" : " and bean.send_System =  '" + dto.getSendSystem() + "'");
        hql = hql + (dto == null || dto.getServId() == 0L ? "" : " and reg.servId = " + dto.getServId());
        hql = hql + (dto == null || dto.getServCode().trim().equals("") || dto.getServCode().equals("0") ? "" : " and bean.serv_Code = '" + dto.getServCode() + "'");
        hql = hql + (dto == null || "".equals(dto.getMsgId().trim()) ? "" : " and bean.msg_Id = '" + dto.getMsgId() + "'");
        if (this.isOracle()) {
            hql = hql + (map.get("BeginTime") == null ? " " : " and bean.receive_Time >= cast(:BeginTime as timestamp) ");
            hql = hql + (map.get("EndTime") == null ? " " : " and bean.receive_Time < cast(:EndTime as timestamp) ");
        } else {
            hql = hql + (map.get("BeginTime") == null ? " " : " and bean.receive_Time >= cast(:BeginTime as datetime year to fraction(5)) ");
            hql = hql + (map.get("EndTime") == null ? " " : " and bean.receive_Time < cast(:EndTime as datetime year to fraction(5)) ");
        }
        hql = hql + (dto == null || dto.getServiceState() == 0L ? "" : " and bean.service_State = " + dto.getServiceState());
        hql = hql + (dto == null || "".equals(dto.getBusinid()) ? "" : "  and c.businid = '" + dto.getBusinid() + "'");
        if (dto != null && dto.getResendFlag() != 0 && dto.getResendFlag() != 1) {
            int resendFlag = dto.getResendFlag();
            if (resendFlag == 2) {
                hql = hql + " and bean.resend_Count > 0 ";
            } else if (resendFlag == 3) {
                hql = hql + " and bean.resend_Count = 0 ";
            }
        }
        hql = hql + " and bean.conn_Flag = 2  ";
        String hqlOrder = " order by bean.receive_Time desc";
        String hqlCount = "select count(*) from (" + hqlPrev + hql + ")";
        Query query = this.createSQLQuery(hqlPrev + hql + hqlOrder, map);
        Query queryCount = this.createSQLQuery(hqlCount, map);
        return flag == 1 ? query : queryCount;
    }

    public Page<AipMessageDto> findPage(Page<AipMessageDto> page, AipMessageDto dto) {
        if (this.isOracle()) {
            return this.findPage4Oracle(page, dto);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Query query = this.querySQL(dto, 1);
        query.setFirstResult(page.getStart());
        query.setMaxResults(page.getPageSize());
        List list = query.list();
        ArrayList<AipMessageDto> aipList = new ArrayList<AipMessageDto>();
        for (int i = 0; i < list.size(); ++i) {
            AipMessageDto aipDto = new AipMessageDto();
            Object[] obj = (Object[])list.get(i);
            aipDto.setMsgId(StringUtil.getStringFrom((Object)obj[0]));
            aipDto.setRegionId(StringUtil.getLongFrom((Object)obj[1]).longValue());
            aipDto.setSendSystem(StringUtil.getStringFrom((Object)obj[2]));
            aipDto.setReceiveSystem(StringUtil.getStringFrom((Object)obj[3]));
            aipDto.setServiceState(StringUtil.getLongFrom((Object)obj[4]).longValue());
            aipDto.setResendCount(StringUtil.getLongFrom((Object)obj[5]).longValue());
            try {
                aipDto.setRequestTime(StringUtil.getDateFrom((Object)obj[6]));
                aipDto.setResponseTime(StringUtil.getDateFrom((Object)obj[7]));
                aipDto.setReceiveTime(StringUtil.getDateFrom((Object)obj[10]));
                aipDto.setSendTime(StringUtil.getDateFrom((Object)obj[13]));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            aipDto.setSendSystemName(StringUtil.getStringFrom((Object)obj[8]));
            aipDto.setReceiveSystemName(StringUtil.getStringFrom((Object)obj[9]));
            aipDto.setServiceStateName(StringUtil.getStringFrom((Object)obj[11]));
            aipDto.setServName(StringUtil.getStringFrom((Object)obj[12]));
            aipDto.setCsbId(StringUtil.getStringFrom((Object)obj[14]));
            aipDto.setMsgSize(StringUtil.getLongFrom((Object)obj[15]).longValue());
            aipDto.setResponseSize(StringUtil.getLongFrom((Object)obj[16]));
            aipDto.setId(StringUtil.getLongFrom((Object)obj[17]).longValue());
            aipDto.setResendFlag(StringUtil.getIntegerFrom((Object)obj[18]).intValue());
            aipDto.setRequestReceiveTime(aipDto.getRequestTime(), aipDto.getReceiveTime());
            aipDto.setResponseRequestTime(aipDto.getResponseTime(), aipDto.getRequestTime());
            aipDto.setSendResponseTime(aipDto.getSendTime(), aipDto.getResponseTime());
            aipDto.setRequestReceive(aipDto.getRequestTime(), aipDto.getReceiveTime());
            aipDto.setResponseRequest(aipDto.getResponseTime(), aipDto.getRequestTime());
            aipDto.setSendResponse(aipDto.getSendTime(), aipDto.getResponseTime());
            aipList.add(i, aipDto);
        }
        page.setResult(aipList);
        List countRes = this.querySQL(dto, 2).list();
        page.setTotalCount(StringUtil.getLongFrom(countRes.get(0)).longValue());
        return page;
    }

    public Page<AipMessageDto> findPage4Oracle(Page<AipMessageDto> page, AipMessageDto dto) {
        SQLQuery query = this.querySQL4oracle(dto, 1);
        query.setFirstResult(page.getStart());
        query.setMaxResults(page.getPageSize());
        List list = query.list();
        ArrayList<AipMessageDto> res = new ArrayList<AipMessageDto>();
        for (Object[] objs : list) {
            try {
                AipMessageDto aipMessageDto = new AipMessageDto(StringUtil.getStringFrom((Object)objs[0]), StringUtil.getLongFrom((Object)objs[1]).longValue(), StringUtil.getStringFrom((Object)objs[2]), StringUtil.getStringFrom((Object)objs[3]), StringUtil.getLongFrom((Object)objs[4]).longValue(), StringUtil.getLongFrom((Object)objs[5]).longValue(), StringUtil.getDateFrom((Object)objs[6]), StringUtil.getDateFrom((Object)objs[7]), StringUtil.getStringFrom((Object)objs[8]), StringUtil.getStringFrom((Object)objs[9]), StringUtil.getDateFrom((Object)objs[10]), StringUtil.getStringFrom((Object)objs[11]), StringUtil.getStringFrom((Object)objs[12]), StringUtil.getDateFrom((Object)objs[13]), StringUtil.getStringFrom((Object)objs[14]));
                aipMessageDto.setMsgSize(StringUtil.getLongFrom((Object)objs[15]).longValue());
                aipMessageDto.setResponseSize(StringUtil.getLongFrom((Object)objs[16]));
                aipMessageDto.setId(StringUtil.getLongFrom((Object)objs[17]).longValue());
                aipMessageDto.setResendFlag(StringUtil.getIntegerFrom((Object)objs[18]).intValue());
                aipMessageDto.setRequestReceiveTime(aipMessageDto.getRequestTime(), aipMessageDto.getReceiveTime());
                aipMessageDto.setResponseRequestTime(aipMessageDto.getResponseTime(), aipMessageDto.getRequestTime());
                aipMessageDto.setSendResponseTime(aipMessageDto.getSendTime(), aipMessageDto.getResponseTime());
                aipMessageDto.setRequestReceive(aipMessageDto.getRequestTime(), aipMessageDto.getReceiveTime());
                aipMessageDto.setResponseRequest(aipMessageDto.getResponseTime(), aipMessageDto.getRequestTime());
                aipMessageDto.setSendResponse(aipMessageDto.getSendTime(), aipMessageDto.getResponseTime());
                res.add(aipMessageDto);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        page.setResult(res);
        List countRes = this.querySQL4oracle(dto, 2).list();
        page.setTotalCount(StringUtil.getLongFrom(countRes.get(0)).longValue());
        return page;
    }

    public List<AipMessageDto> excelList(AipMessageDto dto) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
        if (this.isOracle()) {
            return this.excelList4Oracle(dto);
        }
        Query query = this.querySQL(dto, 1);
        List list = query.list();
        ArrayList<AipMessageDto> aipList = new ArrayList<AipMessageDto>();
        for (int i = 0; i < list.size(); ++i) {
            AipMessageDto aipDto = new AipMessageDto();
            Object[] obj = (Object[])list.get(i);
            aipDto.setMsgId(StringUtil.getStringFrom((Object)obj[0]));
            aipDto.setRegionId(StringUtil.getLongFrom((Object)obj[1]).longValue());
            aipDto.setSendSystem(StringUtil.getStringFrom((Object)obj[2]));
            aipDto.setReceiveSystem(StringUtil.getStringFrom((Object)obj[3]));
            aipDto.setServiceState(StringUtil.getLongFrom((Object)obj[4]).longValue());
            aipDto.setResendCount(StringUtil.getLongFrom((Object)obj[5]).longValue());
            try {
                aipDto.setRequestTime(StringUtil.getDateFrom((Object)obj[6]));
                aipDto.setResponseTime(StringUtil.getDateFrom((Object)obj[7]));
                aipDto.setReceiveTime(StringUtil.getDateFrom((Object)obj[10]));
                aipDto.setSendTime(StringUtil.getDateFrom((Object)obj[13]));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            aipDto.setSendSystemName(StringUtil.getStringFrom((Object)obj[8]));
            aipDto.setReceiveSystemName(StringUtil.getStringFrom((Object)obj[9]));
            aipDto.setServiceStateName(StringUtil.getStringFrom((Object)obj[11]));
            aipDto.setServName(StringUtil.getStringFrom((Object)obj[12]));
            aipDto.setCsbId(StringUtil.getStringFrom((Object)obj[14]));
            aipDto.setMsgSize(StringUtil.getLongFrom((Object)obj[15]).longValue());
            aipDto.setResponseSize(StringUtil.getLongFrom((Object)obj[16]));
            aipDto.setRequestReceiveTime(aipDto.getRequestTime(), aipDto.getReceiveTime());
            aipDto.setResponseRequestTime(aipDto.getResponseTime(), aipDto.getRequestTime());
            aipDto.setSendResponseTime(aipDto.getSendTime(), aipDto.getResponseTime());
            aipDto.setReceiveTime4excel(aipDto.getReceiveTime() == null ? "" : sdf.format(aipDto.getReceiveTime()));
            aipDto.setRequestTime4excel(aipDto.getRequestTime() == null ? "" : sdf.format(aipDto.getRequestTime()));
            aipDto.setResponseTime4excel(aipDto.getResponseTime() == null ? "" : sdf.format(aipDto.getResponseTime()));
            aipDto.setSendTime4excel(aipDto.getSendTime() == null ? "" : sdf.format(aipDto.getSendTime()));
            aipList.add(i, aipDto);
        }
        return aipList;
    }

    public List<AipMessageDto> excelList4Oracle(AipMessageDto dto) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SQLQuery query = this.querySQL4oracle(dto, 1);
        List list = query.list();
        ArrayList<AipMessageDto> res = new ArrayList<AipMessageDto>();
        for (Object[] objs : list) {
            try {
                AipMessageDto aipMessageDto = new AipMessageDto(StringUtil.getStringFrom((Object)objs[0]), StringUtil.getLongFrom((Object)objs[1]).longValue(), StringUtil.getStringFrom((Object)objs[2]), StringUtil.getStringFrom((Object)objs[3]), StringUtil.getLongFrom((Object)objs[4]).longValue(), StringUtil.getLongFrom((Object)objs[5]).longValue(), StringUtil.getDateFrom((Object)objs[6]), StringUtil.getDateFrom((Object)objs[7]), StringUtil.getStringFrom((Object)objs[8]), StringUtil.getStringFrom((Object)objs[9]), StringUtil.getDateFrom((Object)objs[10]), StringUtil.getStringFrom((Object)objs[11]), StringUtil.getStringFrom((Object)objs[12]), StringUtil.getDateFrom((Object)objs[13]), StringUtil.getStringFrom((Object)objs[14]));
                aipMessageDto.setMsgSize(StringUtil.getLongFrom((Object)objs[15]).longValue());
                aipMessageDto.setResponseSize(StringUtil.getLongFrom((Object)objs[16]));
                aipMessageDto.setRequestReceiveTime(aipMessageDto.getRequestTime(), aipMessageDto.getReceiveTime());
                aipMessageDto.setResponseRequestTime(aipMessageDto.getResponseTime(), aipMessageDto.getRequestTime());
                aipMessageDto.setSendResponseTime(aipMessageDto.getSendTime(), aipMessageDto.getResponseTime());
                aipMessageDto.setRequestReceive(aipMessageDto.getRequestTime(), aipMessageDto.getReceiveTime());
                aipMessageDto.setResponseRequest(aipMessageDto.getResponseTime(), aipMessageDto.getRequestTime());
                aipMessageDto.setSendResponse(aipMessageDto.getSendTime(), aipMessageDto.getResponseTime());
                aipMessageDto.setReceiveTime4excel(aipMessageDto.getReceiveTime() == null ? "" : sdf.format(aipMessageDto.getReceiveTime()));
                aipMessageDto.setRequestTime4excel(aipMessageDto.getRequestTime() == null ? "" : sdf.format(aipMessageDto.getRequestTime()));
                aipMessageDto.setResponseTime4excel(aipMessageDto.getResponseTime() == null ? "" : sdf.format(aipMessageDto.getResponseTime()));
                aipMessageDto.setSendTime4excel(aipMessageDto.getSendTime() == null ? "" : sdf.format(aipMessageDto.getSendTime()));
                res.add(aipMessageDto);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    public Page<AipMessageDto> findConnPage(Page<AipMessageDto> page, AipMessageDto dto) {
        Query query = this.connQuerySQL(dto, 1);
        query.setFirstResult(page.getStart());
        query.setMaxResults(page.getPageSize());
        List list = query.list();
        ArrayList<AipMessageDto> aipList = new ArrayList<AipMessageDto>();
        for (int i = 0; i < list.size(); ++i) {
            AipMessageDto aipDto = new AipMessageDto();
            Object[] obj = (Object[])list.get(i);
            aipDto.setMsgId(StringUtil.getStringFrom((Object)obj[0]));
            aipDto.setRegionId(StringUtil.getLongFrom((Object)obj[1]).longValue());
            aipDto.setSendSystem(StringUtil.getStringFrom((Object)obj[2]));
            aipDto.setReceiveSystem(StringUtil.getStringFrom((Object)obj[3]));
            aipDto.setServiceState(StringUtil.getLongFrom((Object)obj[4]).longValue());
            aipDto.setResendCount(StringUtil.getLongFrom((Object)obj[5]).longValue());
            try {
                aipDto.setRequestTime(StringUtil.getDateFrom((Object)obj[6]));
                aipDto.setResponseTime(StringUtil.getDateFrom((Object)obj[7]));
                aipDto.setReceiveTime(StringUtil.getDateFrom((Object)obj[8]));
                aipDto.setSendTime(StringUtil.getDateFrom((Object)obj[11]));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            aipDto.setServiceStateName(StringUtil.getStringFrom((Object)obj[9]));
            aipDto.setServName(StringUtil.getStringFrom((Object)obj[10]));
            aipDto.setCsbId(StringUtil.getStringFrom((Object)obj[12]));
            aipDto.setHost(StringUtil.getStringFrom((Object)obj[13]));
            aipDto.setConnRoutePlatCode(StringUtil.getStringFrom((Object)obj[14]));
            aipDto.setId(StringUtil.getLongFrom((Object)obj[15]).longValue());
            aipDto.setResendFlag(StringUtil.getIntegerFrom((Object)obj[16]).intValue());
            aipDto.setRequestReceiveTime(aipDto.getRequestTime(), aipDto.getReceiveTime());
            aipDto.setResponseRequestTime(aipDto.getResponseTime(), aipDto.getRequestTime());
            aipDto.setSendResponseTime(aipDto.getSendTime(), aipDto.getResponseTime());
            aipDto.setRequestReceive(aipDto.getRequestTime(), aipDto.getReceiveTime());
            aipDto.setResponseRequest(aipDto.getResponseTime(), aipDto.getRequestTime());
            aipDto.setSendResponse(aipDto.getSendTime(), aipDto.getResponseTime());
            aipList.add(i, aipDto);
        }
        page.setResult(aipList);
        List countRes = this.connQuerySQL(dto, 2).list();
        page.setTotalCount((long)StringUtil.getIntegerFrom((Object)(countRes == null || countRes.size() == 0 ? Integer.valueOf(0) : countRes.get(0))).intValue());
        return page;
    }

    public List<AipMessageDto> findConnList(AipMessageDto dto, String DbType) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Query query = this.connQuerySQL(dto, 1);
        List list = query.list();
        ArrayList<AipMessageDto> aipList = new ArrayList<AipMessageDto>();
        for (int i = 0; i < list.size(); ++i) {
            AipMessageDto aipDto = new AipMessageDto();
            Object[] obj = (Object[])list.get(i);
            aipDto.setMsgId(StringUtil.getStringFrom((Object)obj[0]));
            aipDto.setRegionId(StringUtil.getLongFrom((Object)obj[1]).longValue());
            aipDto.setSendSystem(StringUtil.getStringFrom((Object)obj[2]));
            aipDto.setReceiveSystem(StringUtil.getStringFrom((Object)obj[3]));
            aipDto.setServiceState(StringUtil.getLongFrom((Object)obj[4]).longValue());
            aipDto.setResendCount(StringUtil.getLongFrom((Object)obj[5]).longValue());
            try {
                aipDto.setRequestTime(StringUtil.getDateFrom((Object)obj[6]));
                aipDto.setResponseTime(StringUtil.getDateFrom((Object)obj[7]));
                aipDto.setReceiveTime(StringUtil.getDateFrom((Object)obj[8]));
                aipDto.setSendTime(StringUtil.getDateFrom((Object)obj[11]));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            aipDto.setServiceStateName(StringUtil.getStringFrom((Object)obj[9]));
            aipDto.setServName(StringUtil.getStringFrom((Object)obj[10]));
            aipDto.setCsbId(StringUtil.getStringFrom((Object)obj[12]));
            aipDto.setHost(StringUtil.getStringFrom((Object)obj[13]));
            aipDto.setConnRoutePlatCode(StringUtil.getStringFrom((Object)obj[14]));
            aipDto.setId(StringUtil.getLongFrom((Object)obj[15]).longValue());
            aipDto.setRequestReceiveTime(aipDto.getRequestTime(), aipDto.getReceiveTime());
            aipDto.setResponseRequestTime(aipDto.getResponseTime(), aipDto.getRequestTime());
            aipDto.setSendResponseTime(aipDto.getSendTime(), aipDto.getResponseTime());
            aipDto.setRequestReceive(aipDto.getRequestTime(), aipDto.getReceiveTime());
            aipDto.setResponseRequest(aipDto.getResponseTime(), aipDto.getRequestTime());
            aipDto.setSendResponse(aipDto.getSendTime(), aipDto.getResponseTime());
            aipDto.setReceiveTime4excel(aipDto.getReceiveTime() == null ? "" : sdf.format(aipDto.getReceiveTime()));
            aipDto.setRequestTime4excel(aipDto.getRequestTime() == null ? "" : sdf.format(aipDto.getRequestTime()));
            aipDto.setResponseTime4excel(aipDto.getResponseTime() == null ? "" : sdf.format(aipDto.getResponseTime()));
            aipDto.setSendTime4excel(aipDto.getSendTime() == null ? "" : sdf.format(aipDto.getSendTime()));
            aipList.add(i, aipDto);
        }
        return aipList;
    }

    public Page<AipMessageDto> findConnResendPage(Page<AipMessageDto> page, AipMessageDto dto, String DbType) {
        String hqlPrev = "select bean.msg_Id,bean.region_Id,bean.send_System,bean.receive_System,bean.service_State,bean.resend_Count,bean.request_Time,bean.response_Time,bean.receive_Time,c.businname,reg.conn_serv_Name,bean.send_Time,bean.csb_Id ,bean.host,reg.conn_route_plat_code,bean.id ";
        String hql = " from Aip_Message_Conn bean left join conn_serv_reg reg on bean.SERV_code = reg.conn_serv_code ,Bndict_T_Dictionary c where (bean.resend_flag!='1' or bean.resend_flag is null) and bean.service_State = c.businid and c.busintypeid = 'SERVICE_STATE'";
        HashMap<String, Date> map = new HashMap<String, Date>();
        if (dto != null) {
            if (dto.getBeginTime() != null) {
                map.put("BeginTime", dto.getBeginTime());
            }
            if (dto.getEndTime() != null) {
                map.put("EndTime", dto.getEndTime());
            }
        } else {
            Date endTime = new Date();
            long minis = endTime.getTime();
            Date beginTime = new Date(minis -= 86400000L);
            map.put("BeginTime", beginTime);
            map.put("EndTime", endTime);
        }
        hql = hql + (dto == null || "".equals(dto.getConnRoutePlatCode().trim()) ? "" : " and reg.conn_route_plat_code='" + dto.getConnRoutePlatCode() + "'");
        hql = hql + (dto == null || dto.getRegionId() == 0L ? "" : " and bean.region_Id = " + dto.getRegionId());
        hql = hql + (dto == null || "".equals(dto.getSendSystem().trim()) || "\u8bf7\u9009\u62e9\u2026".equals(dto.getSendSystem()) ? "" : " and bean.send_System =  '" + dto.getSendSystem() + "'");
        hql = hql + (dto == null || dto.getServId() == 0L ? "" : " and reg.servId = " + dto.getServId());
        hql = hql + (dto == null || dto.getServCode().trim().equals("") || dto.getServCode().equals("0") ? "" : " and bean.serv_Code = '" + dto.getServCode() + "'");
        hql = hql + (dto == null || "".equals(dto.getMsgId().trim()) ? "" : " and bean.msg_Id = '" + dto.getMsgId() + "'");
        if (this.isOracle()) {
            hql = hql + (map.get("BeginTime") == null ? " " : " and bean.receive_Time >= cast(:BeginTime as timestamp) ");
            hql = hql + (map.get("EndTime") == null ? " " : " and bean.receive_Time < cast(:EndTime as timestamp) ");
        } else {
            hql = hql + (map.get("BeginTime") == null ? " " : " and bean.receive_Time >= cast(:BeginTime as datetime year to fraction(5)) ");
            hql = hql + (map.get("EndTime") == null ? " " : " and bean.receive_Time < cast(:EndTime as datetime year to fraction(5)) ");
        }
        hql = hql + (dto == null || dto.getServiceState() == 0L ? "" : " and bean.service_State = " + dto.getServiceState());
        hql = hql + (dto == null || "".equals(dto.getBusinid()) ? "" : "  and c.businid = '" + dto.getBusinid() + "'");
        if (dto != null && dto.getResendFlag() != 0 && dto.getResendFlag() != 1) {
            int resendFlag = dto.getResendFlag();
            if (resendFlag == 2) {
                hql = hql + " and bean.resend_Count > 0 ";
            } else if (resendFlag == 3) {
                hql = hql + " and bean.resend_Count = 0 ";
            }
        }
        hql = hql + " and bean.conn_Flag = 2 and bean.service_state in (1, 7, 8,296,297,298,299) ";
        String hqlOrder = " order by bean.msg_Id desc";
        Query query = this.createSQLQuery(hqlPrev + hql + hqlOrder, map);
        query.setFirstResult(page.getStart());
        query.setMaxResults(page.getPageSize());
        List list = query.list();
        ArrayList<AipMessageDto> aipList = new ArrayList<AipMessageDto>();
        for (int i = 0; i < list.size(); ++i) {
            AipMessageDto aipDto = new AipMessageDto();
            Object[] obj = (Object[])list.get(i);
            aipDto.setMsgId(StringUtil.getStringFrom((Object)obj[0]));
            aipDto.setRegionId(StringUtil.getLongFrom((Object)obj[1]).longValue());
            aipDto.setSendSystem(StringUtil.getStringFrom((Object)obj[2]));
            aipDto.setReceiveSystem(StringUtil.getStringFrom((Object)obj[3]));
            aipDto.setServiceState(StringUtil.getLongFrom((Object)obj[4]).longValue());
            aipDto.setResendCount(StringUtil.getLongFrom((Object)obj[5]).longValue());
            try {
                aipDto.setRequestTime(StringUtil.getDateFrom((Object)obj[6]));
                aipDto.setResponseTime(StringUtil.getDateFrom((Object)obj[7]));
                aipDto.setReceiveTime(StringUtil.getDateFrom((Object)obj[8]));
                aipDto.setSendTime(StringUtil.getDateFrom((Object)obj[11]));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            aipDto.setServiceStateName(StringUtil.getStringFrom((Object)obj[9]));
            aipDto.setServName(StringUtil.getStringFrom((Object)obj[10]));
            aipDto.setCsbId(StringUtil.getStringFrom((Object)obj[12]));
            aipDto.setHost(StringUtil.getStringFrom((Object)obj[13]));
            aipDto.setConnRoutePlatCode(StringUtil.getStringFrom((Object)obj[14]));
            aipDto.setId(StringUtil.getLongFrom((Object)obj[15]).longValue());
            aipDto.setRequestReceiveTime(aipDto.getRequestTime(), aipDto.getReceiveTime());
            aipDto.setResponseRequestTime(aipDto.getResponseTime(), aipDto.getRequestTime());
            aipDto.setSendResponseTime(aipDto.getSendTime(), aipDto.getResponseTime());
            aipList.add(i, aipDto);
        }
        page.setResult(aipList);
        String countHql = "select count(*) " + hql;
        query = this.createSQLQuery(countHql, map);
        List countRes = query.list();
        page.setTotalCount((long)StringUtil.getIntegerFrom((Object)(countRes == null || countRes.size() == 0 ? Integer.valueOf(0) : countRes.get(0))).intValue());
        return page;
    }

    public List<StaticDataDto> queryServiceState() {
        String hql = "SELECT new cn.com.starit.tsaip.register.dto.StaticDataDto(dic.id.businid,dic.businname) From BndictTDictionary dic WHERE dic.id.busintypeid = 'SERVICE_STATE'";
        return this.find(hql, new Object[0]);
    }

    public Page<AipMessageDto> msgResendFindPage(Page<AipMessageDto> page, AipMessageDto dto) {
        List list;
        String hql = "select new cn.com.starit.tsaip.audit.dto.AipMessageDto(bean.id,bean.msgId,bean.csbId,bean.sendSystem.servManCode,bean.sendSystem.servManName,bean.receiveSystem.servManCode,bean.receiveSystem.servManName,bean.servAffordManReg.servName,bean.serviceState,c.businname,bean.resendCount,bean.receiveTime,bean.requestTime) from AipMessage bean left join bean.sendSystem  left join bean.receiveSystem left join bean.servAffordManReg,BndictTDictionary c where (bean.resendFlag!='1' or bean.resendFlag is null) and bean.serviceState = c.id.businid and c.id.busintypeid = 'SERVICE_STATE' and bean.servAffordManReg.servInvokeMode = 1 ";
        String sql = "select serv_Man_Code from Serv_Afford_Man_Config where SERV_MAN_ID = ";
        HashMap<String, Date> map = new HashMap<String, Date>();
        if (dto != null) {
            if (dto.getBeginTime() != null) {
                map.put("BeginTime", dto.getBeginTime());
            }
            if (dto.getEndTime() != null) {
                map.put("EndTime", dto.getEndTime());
            }
        } else {
            Date endTime = new Date();
            long minis = endTime.getTime();
            Date beginTime = new Date(minis -= 86400000L);
            map.put("BeginTime", beginTime);
            map.put("EndTime", endTime);
        }
        if (dto != null && !"".equals(dto.getReceiveSystem()) && !"\u8bf7\u9009\u62e9\u2026".equals(dto.getReceiveSystem()) && (list = this.findBySQL(sql = sql + dto.getReceiveSystem(), new Object[0])).size() != 0) {
            hql = hql + " and bean.receiveSystem ='" + list.get(0) + "'";
        }
        hql = hql + (dto == null || dto.getRegionId() == 0L ? "" : " and bean.regionId = " + dto.getRegionId());
        hql = hql + (dto == null || "".equals(dto.getSendSystem().trim()) || "\u8bf7\u9009\u62e9\u2026".equals(dto.getSendSystem()) ? "" : " and bean.sendSystem =  '" + dto.getSendSystem() + "'");
        hql = hql + (dto == null || dto.getServId() == 0L ? "" : " and bean.servAffordManReg.servId = " + dto.getServId());
        hql = hql + (dto == null || "".equals(dto.getMsgId().trim()) ? "" : " and bean.msgId = '" + dto.getMsgId() + "'");
        hql = hql + (map.get("BeginTime") == null ? " " : " and bean.receiveTime >= cast(:BeginTime as timestamp) ");
        hql = hql + (map.get("EndTime") == null ? " " : " and bean.receiveTime < cast(:EndTime as timestamp) ");
        hql = hql + (dto == null || dto.getServiceState() == 0L ? " and bean.serviceState in(1, 7, 8,296,297,298,299) " : " and bean.serviceState = " + dto.getServiceState());
        hql = hql + (dto == null || "".equals(dto.getBusinid()) ? "" : "  and c.id.businid = '" + dto.getBusinid() + "'");
        if (dto != null && dto.getResendFlag() != 0 && dto.getResendFlag() != 1) {
            int resendFlag = dto.getResendFlag();
            if (resendFlag == 2) {
                hql = hql + " and bean.resendCount > 0 ";
            } else if (resendFlag == 3) {
                hql = hql + " and bean.resendCount = 0 ";
            }
        }
        hql = hql + " and bean.connFlag != 2";
        hql = hql + " order by bean.receiveTime desc";
        try {
            Page resultPage = this.findPage(page, hql, map);
            System.out.println(page.getResult());
            return resultPage;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<AipMessageDto> excelList4msgResend(AipMessageDto aipMessageDto) {
        String hql = "select new cn.com.starit.tsaip.audit.dto.AipMessageDto(am.id,am.msgId,am.csbId,am.sendSystem.servManCode,am.sendSystem.servManName,am.receiveSystem.servManCode,am.receiveSystem.servManName,am.servAffordManReg.servName,sd.versionNo,a.businname,sd.servType,am.serviceState,b.businname,am.resendCount,am.receiveTime,am.requestTime,am.servAffordManReg.servInvokeMode) from AipMessage am,ServDefine sd,BndictTDictionary a,BndictTDictionary b where a.id.busintypeid='SERV_TYPE' and a.id.businid = sd.servType and sd.servAffordManReg.servId = am.servAffordManReg.servId and am.serviceState = b.id.businid and b.id.busintypeid='SERVICE_STATE'";
        if (aipMessageDto != null) {
            List list;
            String sql = "select serv_Man_Code from Serv_Afford_Man_Config where SERV_MAN_ID = ";
            if (!"".equals(aipMessageDto.getReceiveSystem()) && !"\u8bf7\u9009\u62e9\u2026".equals(aipMessageDto.getReceiveSystem()) && (list = this.findBySQL(sql = sql + aipMessageDto.getReceiveSystem(), new Object[0])).size() != 0) {
                hql = hql + " and am.receiveSystem ='" + list.get(0) + "'";
            }
            hql = hql + ("".equals(aipMessageDto.getSendSystem()) || "\u8bf7\u9009\u62e9\u2026".equals(aipMessageDto.getSendSystem()) ? "" : " and am.sendSystem = '" + aipMessageDto.getSendSystem() + "'");
            hql = hql + (aipMessageDto.getServId() == 0L ? "" : " and am.servAffordManReg.servId = " + aipMessageDto.getServId());
            hql = hql + ("".equals(aipMessageDto.getMsgId().trim()) ? "" : " and am.msgId = '" + aipMessageDto.getMsgId() + "'");
            if (aipMessageDto.getResendFlag() != 0 && aipMessageDto.getResendFlag() != 1) {
                int resendFlag = aipMessageDto.getResendFlag();
                if (resendFlag == 2) {
                    hql = hql + " and am.resendCount > 0";
                } else if (resendFlag == 3) {
                    hql = hql + " and am.resendCount = 0";
                }
            }
            hql = hql + ("".equals(aipMessageDto.getServiceStateName()) ? "" : " and b.id.businid = '" + aipMessageDto.getServiceStateName() + "'");
            if (aipMessageDto.getServInvokeMode() != 0 && aipMessageDto.getServInvokeMode() != 1) {
                if (aipMessageDto.getServInvokeMode() == 2) {
                    hql = hql + " and am.servAffordManReg.servInvokeMode = 0";
                } else if (aipMessageDto.getServInvokeMode() == 3) {
                    hql = hql + " and am.servAffordManReg.servInvokeMode = 1";
                }
            }
            hql = hql + ("".equals(aipMessageDto.getServTypeName()) ? "" : " and a.id.businid = '" + aipMessageDto.getServTypeName() + "'");
        }
        Date beginTime = new Date();
        Date endTime = new Date();
        if (aipMessageDto != null) {
            beginTime = aipMessageDto.getBeginTime();
            endTime = aipMessageDto.getEndTime();
        } else {
            long minis = endTime.getTime();
            beginTime = new Date(minis -= 86400000L);
        }
        hql = hql + " and am.receiveTime >= ?";
        hql = hql + " and am.receiveTime < ?";
        hql = hql + " order by am.receiveTime desc";
        List resultList = this.find(hql, new Object[]{beginTime, endTime});
        return resultList;
    }

    public void resend(List<String> idList) {
        Date date = new Date();
        for (String id : idList) {
            String sql = "update aip_message_persistence am set am.resend_count = resend_count+1 , am.resend_time = ? where am.csb_id = ?";
            this.getJdbcTemplate().update(sql, new Object[]{date, id});
        }
    }

    public Date parseDate(String dateStr) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS");
        Date date = null;
        if (dateStr != null && !dateStr.trim().equals("")) {
            try {
                date = format.parse(dateStr);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return date;
    }
}

