/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.oip.dcn.persistence.dao;

import cn.com.starit.common.persistence.GenericHibernateDao;
import cn.com.starit.common.persistence.Page;
import cn.com.starit.common.util.StringUtil;
import cn.com.starit.oip.dcn.dto.HostNetMonResultDto;
import cn.com.starit.oip.dcn.dto.HostNetMonSearchDto;
import cn.com.starit.oip.dcn.persistence.entity.HostNetMonResult;
import cn.com.starit.tsaip.register.util.ConfigControl;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class HostNetMonResultDao
extends GenericHibernateDao<HostNetMonResult, Long> {
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public Page<HostNetMonResultDto> getHostNetMonResult(Page<HostNetMonResultDto> page, HostNetMonResultDto hostNetMonResultDto) throws ParseException {
        String hql = "select t.areaCode,t1.businname as areaCodeName,t.servManCode,t6.businname as servManCodeName,t.hostDesc,t.hostAddress, t.testEndTime, t.ttl,t.packetTotal,t.packetLoss,t.avgRtt,t.maxRtt,t.minRtt  from (select c.area_code as areaCode, c.serv_man_code as servManCode,c.host_desc as hostDesc, c.host_address as hostAddress, h.test_end_time as testEndTime,h.ttl as ttl,h.packet_total as packetTotal,h.packet_loss as packetLoss, h.avg_rtt as avgRtt, h.max_rtt as maxRtt,h.min_rtt as minRtt  from HOST_NETMON_RESULT h,HOST_NETMON_CONF c  where h.host_netmon_conf_id=c.host_netmon_conf_id and c.del_flag=0 ";
        if (hostNetMonResultDto != null) {
            hql = hql + (hostNetMonResultDto.getAreaCode() == null || "".equals(hostNetMonResultDto.getAreaCode()) ? "" : " and c.area_code='" + hostNetMonResultDto.getAreaCode() + "' ");
            hql = hql + (hostNetMonResultDto.getHostAddress() == null || "".equals(hostNetMonResultDto.getHostAddress()) ? "" : " and c.host_address='" + hostNetMonResultDto.getHostAddress() + "' ");
            hql = hql + (hostNetMonResultDto.getHostDesc() == null || "".equals(hostNetMonResultDto.getHostDesc()) ? "" : " and c.host_desc like '%" + hostNetMonResultDto.getHostDesc() + "%' ");
            hql = hql + (hostNetMonResultDto.getConnServManCode() == null || "".equals(hostNetMonResultDto.getConnServManCode()) ? "" : " and c.serv_man_code='" + hostNetMonResultDto.getConnServManCode() + "' ");
        }
        hql = hql + " and h.test_end_time>=to_date('" + this.sdf.format(hostNetMonResultDto.getTestStartTime()) + "','" + this.getDateFromStconfig("SYS_DATA_YMD_HMS") + "') " + " and h.test_end_time<=to_date('" + this.sdf.format(hostNetMonResultDto.getTestEndTime()) + "','" + this.getDateFromStconfig("SYS_DATA_YMD_HMS") + "')" + " ) t left join bndict_t_dictionary t1 on t1.busintypeid = 'AREA_CODE' and t1.businid = t.areaCode" + " left join bndict_t_dictionary t6 on t6.busintypeid = 'CONN_SERV_MAN_CODE' and t6.businid = t.servManCode order by t.testEndTime desc";
        List resultPage = this.pagingFindBySQL1(hql, null, page);
        ArrayList<HostNetMonResultDto> res = new ArrayList<HostNetMonResultDto>();
        for (int i = 0; i < resultPage.size(); ++i) {
            HostNetMonResultDto dto = new HostNetMonResultDto();
            Object[] obj = (Object[])resultPage.get(i);
            dto.setAreaCode(StringUtil.getStringFrom((Object)obj[0]));
            dto.setAreaCodeName(StringUtil.getStringFrom((Object)obj[1]));
            dto.setConnServManCode(StringUtil.getStringFrom((Object)obj[2]));
            dto.setConnServManCodeName(StringUtil.getStringFrom((Object)obj[3]));
            dto.setHostDesc(StringUtil.getStringFrom((Object)obj[4]));
            dto.setHostAddress(StringUtil.getStringFrom((Object)obj[5]));
            dto.setTestEndTime(StringUtil.getDateFrom((Object)obj[6]));
            dto.setTtl(StringUtil.getIntegerFrom((Object)obj[7]));
            dto.setPacketTotal(StringUtil.getIntegerFrom((Object)obj[8]));
            dto.setPacketLoss(StringUtil.getIntegerFrom((Object)obj[9]));
            double tot = dto.getPacketTotal().doubleValue();
            dto.setPacketLossRate(Double.valueOf((double)dto.getPacketLoss().intValue() / tot));
            dto.setAvgRtt(StringUtil.getDoubleFrom((Object)obj[10]));
            dto.setMaxRtt(StringUtil.getDoubleFrom((Object)obj[11]));
            dto.setMinRtt(StringUtil.getDoubleFrom((Object)obj[12]));
            res.add(dto);
        }
        page.setResult(res);
        return page;
    }

    public List<HostNetMonSearchDto> getHostNetMonResult(HostNetMonResultDto hostNetMonResultDto) throws ParseException {
        String hql = "select t.areaCode,t1.businname as areaCodeName,t.servManCode,t6.businname as servManCodeName,t.hostDesc,t.hostAddress, t.testEndTime, t.ttl,t.packetTotal,t.packetLoss,t.avgRtt,t.maxRtt,t.minRtt  from (select c.area_code as areaCode, c.serv_man_code as servManCode,c.host_desc as hostDesc, c.host_address as hostAddress, h.test_end_time as testEndTime,h.ttl as ttl,h.packet_total as packetTotal,h.packet_loss as packetLoss, h.avg_rtt as avgRtt, h.max_rtt as maxRtt,h.min_rtt as minRtt  from HOST_NETMON_RESULT h,HOST_NETMON_CONF c  where h.host_netmon_conf_id=c.host_netmon_conf_id and c.del_flag=0 ";
        if (hostNetMonResultDto != null) {
            hql = hql + (hostNetMonResultDto.getAreaCode() == null || "".equals(hostNetMonResultDto.getAreaCode()) ? "" : " and c.area_code='" + hostNetMonResultDto.getAreaCode() + "' ");
            hql = hql + (hostNetMonResultDto.getHostAddress() == null || "".equals(hostNetMonResultDto.getHostAddress()) ? "" : " and c.host_address='" + hostNetMonResultDto.getHostAddress() + "' ");
            hql = hql + (hostNetMonResultDto.getHostDesc() == null || "".equals(hostNetMonResultDto.getHostDesc()) ? "" : " and c.host_desc like '%" + hostNetMonResultDto.getHostDesc() + "%' ");
            hql = hql + (hostNetMonResultDto.getConnServManCode() == null || "".equals(hostNetMonResultDto.getConnServManCode()) ? "" : " and c.serv_man_code='" + hostNetMonResultDto.getConnServManCode() + "' ");
        }
        hql = hql + " and h.test_end_time>=to_date('" + this.sdf.format(hostNetMonResultDto.getTestStartTime()) + "','" + this.getDateFromStconfig("SYS_DATA_YMD_HMS") + "') " + " and h.test_end_time<=to_date('" + this.sdf.format(hostNetMonResultDto.getTestEndTime()) + "','" + this.getDateFromStconfig("SYS_DATA_YMD_HMS") + "')" + " ) t left join bndict_t_dictionary t1 on t1.busintypeid = 'AREA_CODE' and t1.businid = t.areaCode" + " left join bndict_t_dictionary t6 on t6.busintypeid = 'CONN_SERV_MAN_CODE' and t6.businid = t.servManCode order by t.testEndTime desc";
        List resultPage = this.findBySQL(hql, new Object[0]);
        ArrayList<HostNetMonSearchDto> res = new ArrayList<HostNetMonSearchDto>();
        for (int i = 0; i < resultPage.size(); ++i) {
            HostNetMonSearchDto dto = new HostNetMonSearchDto();
            Object[] obj = (Object[])resultPage.get(i);
            dto.setAreaCodeName(StringUtil.getStringFrom((Object)obj[1]));
            dto.setConnServManCodeName(StringUtil.getStringFrom((Object)obj[3]));
            dto.setHostDesc(StringUtil.getStringFrom((Object)obj[4]));
            dto.setHostAddress(StringUtil.getStringFrom((Object)obj[5]));
            dto.setTestEndTime(StringUtil.getDateFrom((Object)obj[6]));
            dto.setTtl(StringUtil.getIntegerFrom((Object)obj[7]));
            dto.setPacketTotal(StringUtil.getIntegerFrom((Object)obj[8]));
            dto.setPacketLoss(StringUtil.getIntegerFrom((Object)obj[9]));
            double tot = dto.getPacketTotal().doubleValue();
            dto.setPacketLossRate(Double.valueOf((double)dto.getPacketLoss().intValue() / tot));
            dto.setAvgRtt(StringUtil.getDoubleFrom((Object)obj[10]));
            dto.setMaxRtt(StringUtil.getDoubleFrom((Object)obj[11]));
            dto.setMinRtt(StringUtil.getDoubleFrom((Object)obj[12]));
            res.add(dto);
        }
        return res;
    }

    private String getDateFromStconfig(String key) {
        return ConfigControl.getStConfigCache().getConfigValue((Object)key) == null ? "" : (String)ConfigControl.getStConfigCache().getConfigValue((Object)key);
    }

    public List<HostNetMonResultDto> statHostNetMonResult(HostNetMonResultDto hostNetMonResultDto) {
        String hql = "select tt.areaCode,t1.businname as areaCodeName,tt.servManCode,t6.businname as servManCodeName,tt.hostDesc,tt.hostAddress, tt.ttl,tt.packetTotal,tt.packetLoss,tt.avgRtt,tt.maxRtt,tt.minRtt from  (select c1.area_code as areaCode,c1.serv_man_code as servManCode,c1.host_desc as hostDesc,c1.host_address as hostAddress,t.ttl as ttl,t.packetTotal as packetTotal,t.packetLoss as packetLoss,t.avgRtt as avgRtt,t.maxRtt as maxRtt,t.minRtt as minRtt  from ( select h.host_netmon_conf_id as hostNetmonConfId,sum(h.ttl) as ttl,sum(h.packet_total) as packetTotal,sum(packet_loss) as packetLoss  ,avg(h.avg_rtt) as avgRtt,max(h.max_rtt) as maxRtt,min(h.min_rtt) as minRtt  from HOST_NETMON_RESULT h,HOST_NETMON_CONF c where c.host_netmon_conf_id=h.host_netmon_conf_id and  c.del_flag=0 and  h.test_end_time>=to_date('" + this.sdf.format(hostNetMonResultDto.getTestStartTime()) + "','" + this.getDateFromStconfig("SYS_DATA_YMD_HMS") + "') " + " and h.test_end_time<=to_date('" + this.sdf.format(hostNetMonResultDto.getTestEndTime()) + "','" + this.getDateFromStconfig("SYS_DATA_YMD_HMS") + "')" + " group by h.host_netmon_conf_id) t," + "HOST_NETMON_CONF c1 where c1.host_netmon_conf_id=t.hostNetmonConfId) tt" + " left join bndict_t_dictionary t1 on t1.busintypeid = 'AREA_CODE' and t1.businid = tt.areaCode" + " left join bndict_t_dictionary t6 on t6.busintypeid = 'CONN_SERV_MAN_CODE' and t6.businid = tt.servManCode";
        List resultPage = this.findBySQL(hql, new Object[0]);
        ArrayList<HostNetMonResultDto> res = new ArrayList<HostNetMonResultDto>();
        for (int i = 0; i < resultPage.size(); ++i) {
            HostNetMonResultDto dto = new HostNetMonResultDto();
            Object[] obj = (Object[])resultPage.get(i);
            dto.setAreaCodeName(StringUtil.getStringFrom((Object)obj[1]));
            dto.setConnServManCodeName(StringUtil.getStringFrom((Object)obj[3]));
            dto.setHostDesc(StringUtil.getStringFrom((Object)obj[4]));
            dto.setHostAddress(StringUtil.getStringFrom((Object)obj[5]));
            dto.setTtl(StringUtil.getIntegerFrom((Object)obj[6]));
            dto.setPacketTotal(StringUtil.getIntegerFrom((Object)obj[7]));
            dto.setPacketLoss(StringUtil.getIntegerFrom((Object)obj[8]));
            double tot = dto.getPacketTotal().doubleValue();
            dto.setPacketLossRate(Double.valueOf((double)dto.getPacketLoss().intValue() / tot));
            dto.setAvgRtt(StringUtil.getDoubleFrom((Object)obj[9]));
            dto.setMaxRtt(StringUtil.getDoubleFrom((Object)obj[10]));
            dto.setMinRtt(StringUtil.getDoubleFrom((Object)obj[11]));
            res.add(dto);
        }
        return res;
    }
}

