/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.oip.common;

import cn.com.starit.oip.Srp.dto.SrpServMonDto;
import cn.com.starit.oip.Srp.pesistence.entity.ConnServReg;
import cn.com.starit.oip.Srp.pesistence.entity.ConnSrpReg;
import cn.com.starit.oip.Srp.pesistence.entity.ConnVisitLimitSr;
import cn.com.starit.tsaip.monitor.dto.ServFluxCtrlDto;
import cn.com.starit.tsaip.register.util.ConfigControl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SrpCommonUtil {
    private static Logger log = LoggerFactory.getLogger(SrpCommonUtil.class);
    private static String XML_TOP = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
    private static String srServInfoXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\t<ServInfo> \t    <Serv> \t        <ServReg>\t        \t<ConnServId/>\t        \t<ConnServCode/>\t        \t<ConnServName/>\t        \t<ConnServType/>\t        \t<AreaCode/>\t        \t<ConnRoutePlatCode/>\t        \t<ProvideCode/>\t        \t<ConnServInvokeMode/>\t        \t<ConnServStatus/>\t        \t<ConnServProcStatus/>\t        \t<WsdlId/>\t        \t<ProtocolId/>\t        \t<DelFlag/>\t        \t<Description/>\t        </ServReg>\t        <ServControl>\t        \t<FrequencyLimit/>\t        \t<PkgSizeLimit/>\t        \t<FlowLimit/>\t        </ServControl>\t    </Serv> \t</ServInfo>";

    public static List<ConnSrpReg> encapSrInfos4Dom4j(String srInfoXml) throws DocumentException {
        ArrayList<ConnSrpReg> srList = new ArrayList<ConnSrpReg>();
        Document document = DocumentHelper.parseText((String)srInfoXml);
        Element root = document.getRootElement();
        List nodes = root.elements("SR");
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            ConnSrpReg connSrpReg = new ConnSrpReg();
            Element element = (Element)it.next();
            connSrpReg.setConnRoutePlatId(SrpCommonUtil.getLongFromTxt((String)element.elementText("ConnRoutePlatId")).longValue());
            connSrpReg.setConnRoutePlatArea(element.elementText("ConnRoutePlatArea"));
            connSrpReg.setConnRoutePlatCode(element.elementText("ConnRoutePlatCode"));
            connSrpReg.setConnRoutePlatName(element.elementText("ConnRoutePlatName"));
            connSrpReg.setConnRoutePlatUrl(element.elementText("ConnRoutePlatUrl"));
            connSrpReg.setSrpDynamicStatus(SrpCommonUtil.getLongFromTxt((String)element.elementText("ConnPlatStatus")).longValue());
            srList.add(connSrpReg);
        }
        return srList;
    }

    public static Object[] encapServInfos4Dom4j(String servInfoXml) throws DocumentException {
        ArrayList<ConnServReg> srList = new ArrayList<ConnServReg>();
        ArrayList<ConnVisitLimitSr> cvlList = new ArrayList<ConnVisitLimitSr>();
        Document document = DocumentHelper.parseText((String)servInfoXml);
        Element rootServ = document.getRootElement();
        List servNodes = rootServ.elements("Serv");
        for (Element servElement : servNodes) {
            String servManCodes;
            Element servRegElement = servElement.element("ServReg");
            ConnServReg connServReg = new ConnServReg();
            connServReg.setConnServId(SrpCommonUtil.getLongFromTxt((String)servRegElement.elementText("ConnServId")).longValue());
            connServReg.setAreaCode(servRegElement.elementText("AreaCode"));
            connServReg.setConnRoutePlatCode(servRegElement.elementText("ConnRoutePlatCode"));
            connServReg.setConnServCode(servRegElement.elementText("ConnServCode"));
            connServReg.setConnServInvokeMode(SrpCommonUtil.getLongFromTxt((String)servRegElement.elementText("ConnServInvokeMode")) - 1L);
            connServReg.setConnServName(servRegElement.elementText("ConnServName"));
            connServReg.setConnServProcStatus(SrpCommonUtil.getLongFromTxt((String)servRegElement.elementText("ConnServType")).longValue());
            connServReg.setConnServType(SrpCommonUtil.getLongFromTxt((String)servRegElement.elementText("ConnServType")).longValue());
            connServReg.setDelFlag(SrpCommonUtil.getLongFromTxt((String)servRegElement.elementText("DelFlag")).longValue());
            connServReg.setDescription(servRegElement.elementText("Description"));
            connServReg.setProvideCode(servRegElement.elementText("ProvideCode"));
            connServReg.setConnServStatus(SrpCommonUtil.getLongFromTxt((String)servRegElement.elementText("ConnServStatus")).longValue());
            srList.add(connServReg);
            Element servVisitLimtElement = servElement.element("ServVisitLimt");
            if (servVisitLimtElement == null || (servManCodes = servVisitLimtElement.elementText("ConnServManCode")) == null || "".equals(servManCodes)) continue;
            String[] codes = servManCodes.split(";");
            for (int i = 0; i < codes.length; ++i) {
                ConnVisitLimitSr cvl = new ConnVisitLimitSr();
                cvl.setConnServCode(connServReg.getConnServCode());
                cvl.setConnServManCode(codes[i]);
                cvlList.add(cvl);
            }
        }
        if (srList.size() > 0 || cvlList.size() > 0) {
            return new Object[]{srList, cvlList};
        }
        return null;
    }

    public static String encapSrInfo2Xml(ConnSrpReg connSrpReg) {
        if (connSrpReg == null) {
            log.error("SRP\u4fe1\u606f\u4e3a\u7a7a");
            return null;
        }
        StringBuffer sb = new StringBuffer(XML_TOP);
        sb.append("<SRInfo>").append("<SR>");
        sb.append("<ConnRoutePlatId>").append(connSrpReg.getConnRoutePlatId()).append("</ConnRoutePlatId>");
        sb.append("<ConnRoutePlatCode>").append(connSrpReg.getConnRoutePlatCode()).append("</ConnRoutePlatCode>");
        sb.append("<ConnRoutePlatUrl>").append(connSrpReg.getConnRoutePlatUrl()).append("</ConnRoutePlatUrl>");
        sb.append("<ConnRoutePlatName>").append(connSrpReg.getConnRoutePlatName()).append("</ConnRoutePlatName>");
        sb.append("<ConnRoutePlatArea>").append(connSrpReg.getConnRoutePlatArea()).append("</ConnRoutePlatArea>");
        sb.append("<ConnPlatStatus>").append(connSrpReg.getSrpDynamicStatus()).append("</ConnPlatStatus>");
        sb.append("<DelFlag>").append(connSrpReg.getDelFlag()).append("</DelFlag>");
        sb.append("</SR>").append("</SRInfo>");
        return sb.toString();
    }

    private static Long getLongFromTxt(String txt) {
        if (txt == null || "".equals(txt)) {
            return 0L;
        }
        return Long.parseLong(txt);
    }

    public static String encapSrpServInfo2Xml(ConnServReg connServReg, List<ServFluxCtrlDto> fluxCtls) {
        Element servEl = SrpCommonUtil.getXpathElement();
        Element servRegEl = servEl.element("ServReg");
        SrpCommonUtil.setElementValue((Element)servRegEl, (String)"ConnServId", (String)SrpCommonUtil.transformLongFromString((long)connServReg.getConnServId()));
        SrpCommonUtil.setElementValue((Element)servRegEl, (String)"ConnServCode", (String)connServReg.getConnServCode());
        SrpCommonUtil.setElementValue((Element)servRegEl, (String)"ConnServName", (String)connServReg.getConnServName());
        SrpCommonUtil.setElementValue((Element)servRegEl, (String)"ConnServType", (String)SrpCommonUtil.transformLongFromString((long)connServReg.getConnServType()));
        SrpCommonUtil.setElementValue((Element)servRegEl, (String)"AreaCode", (String)connServReg.getAreaCode());
        SrpCommonUtil.setElementValue((Element)servRegEl, (String)"ConnRoutePlatCode", (String)connServReg.getConnRoutePlatCode());
        SrpCommonUtil.setElementValue((Element)servRegEl, (String)"ProvideCode", (String)connServReg.getProvideCode());
        SrpCommonUtil.setElementValue((Element)servRegEl, (String)"ConnServInvokeMode", (String)SrpCommonUtil.transformLongFromString((long)(connServReg.getConnServInvokeMode() + 1L)));
        SrpCommonUtil.setElementValue((Element)servRegEl, (String)"ConnServStatus", (String)SrpCommonUtil.transformLongFromString((long)connServReg.getConnServStatus()));
        SrpCommonUtil.setElementValue((Element)servRegEl, (String)"ConnServProcStatus", (String)SrpCommonUtil.transformLongFromString((long)connServReg.getConnServProcStatus()));
        SrpCommonUtil.setElementValue((Element)servRegEl, (String)"WsdlId", (String)SrpCommonUtil.transformLongFromString((long)connServReg.getWsdlId()));
        SrpCommonUtil.setElementValue((Element)servRegEl, (String)"ProtocolId", (String)SrpCommonUtil.transformLongFromString((long)connServReg.getProtocolId()));
        SrpCommonUtil.setElementValue((Element)servRegEl, (String)"DelFlag", (String)SrpCommonUtil.transformLongFromString((long)connServReg.getDelFlag()));
        SrpCommonUtil.setElementValue((Element)servRegEl, (String)"Description", (String)connServReg.getDescription());
        for (ServFluxCtrlDto servFluxCtrlDto : fluxCtls) {
            Element servVisitLimtEl = servEl.element("ServControl");
            SrpCommonUtil.setElementValue((Element)servVisitLimtEl, (String)"FrequencyLimit", (String)(servFluxCtrlDto.getBusiRateUp() == null ? "" : SrpCommonUtil.transformLongFromString((long)servFluxCtrlDto.getBusiRateUp().longValue())));
            SrpCommonUtil.setElementValue((Element)servVisitLimtEl, (String)"PkgSizeLimit", (String)(servFluxCtrlDto.getOneBusiBagUp() == null ? "" : SrpCommonUtil.transformLongFromString((long)servFluxCtrlDto.getOneBusiBagUp().longValue())));
            SrpCommonUtil.setElementValue((Element)servVisitLimtEl, (String)"FlowLimit", (String)SrpCommonUtil.transformLongFromString((long)servFluxCtrlDto.getCountUp()));
        }
        return servEl.getDocument().asXML();
    }

    public static String encapSrpServMon2Xml(List<SrpServMonDto> list) {
        if (list == null || list.size() == 0) {
            log.error("\u65e0\u670d\u52a1\u72b6\u6001\u4fe1\u606f");
            return null;
        }
        StringBuffer sb = new StringBuffer(XML_TOP);
        sb.append("<ServMonInfo>");
        for (SrpServMonDto dto : list) {
            sb.append("<ServMon>");
            sb.append("<ConnServCode>").append(dto.getConnServCode()).append("</ConnServCode>");
            sb.append("<ConnServStat>").append(dto.getConnServStatus()).append("</ConnServStat>");
            sb.append("<UpdateTime>").append(dto.getUpdateTime()).append("</UpdateTime>");
            sb.append("<RequestTimes>").append(dto.getRequestTimes()).append("</RequestTimes>");
            sb.append("<ExceptionRate>").append(dto.getFailureRate()).append("</ExceptionRate>");
            sb.append("<BusiTimeConsuming>").append(dto.getBusiMoSum()).append("</BusiTimeConsuming>");
            sb.append("<AipTimeConsuming>").append(dto.getCsbAchieveAvgTime()).append("</AipTimeConsuming>");
            sb.append("<TotalFlow>").append(dto.getBusiMoSum()).append("</TotalFlow>");
            sb.append("<AverageFlow>").append(dto.getBusiMoAvg()).append("</AverageFlow>");
            sb.append("<StatisticsEndTime>").append(dto.getAnalysisEndTime()).append("</StatisticsEndTime>");
            sb.append("<ConnRoutePlatCode>").append(ConfigControl.getStConfigCache().getConfigValue((Object)"SRP_CODE")).append("</ConnRoutePlatCode>");
            sb.append("</ServMon>");
        }
        sb.append("</ServMonInfo>");
        return sb.toString();
    }

    public static Element getXpathElement() {
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)srServInfoXml);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        Element servEl = (Element)document.selectSingleNode("//ServInfo/Serv");
        return servEl;
    }

    public static String encapHearBeatXml(String plainCode) {
        String hearBeatXml = "<HearBeat><ConnRoutePlatCode>" + plainCode + "</ConnRoutePlatCode></HearBeat>";
        return XML_TOP + hearBeatXml;
    }

    public static void setElementValue(Element el, String name, String value) {
        Element sel = el.element(name);
        sel.setText(value == null ? "" : value);
    }

    public static String transformLongFromString(long table) {
        return String.valueOf(table);
    }
}

