/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.oip.Srp.webservcie;

import cn.com.starit.oip.Srp.biz.IServRegService;
import cn.com.starit.oip.Srp.dto.SrpServMonDto;
import cn.com.starit.oip.common.OipCommonUtil;
import cn.com.starit.tsaip.register.util.ConfigControl;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SrpServMonReportService {
    private Logger log = LoggerFactory.getLogger(SrpServMonReportService.class);
    private IServRegService servRegService;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void run() throws ParseException {
        List list;
        this.log.info("[\u670d\u52a1\u72b6\u6001\u4e0a\u62a5]\u51c6\u5907\u53d1\u9001\u6570\u636e");
        Date startDate = this.servRegService.getLastReportTime();
        if (startDate == null) {
            startDate = new Date();
        }
        if ((list = this.servRegService.getServMonSrp(startDate)).size() == 0) {
            return;
        }
        String xml = OipCommonUtil.encapSrpServMon2Xml((List)list);
        JaxWsDynamicClientFactory fb = JaxWsDynamicClientFactory.newInstance();
        Client client = null;
        String responseXML = "";
        client = fb.createClient(ConfigControl.getStConfigCache().getConfigValue((Object)"SERV_MON_REPORT_WS_URL") == null ? "" : (String)ConfigControl.getStConfigCache().getConfigValue((Object)"SERV_MON_REPORT_WS_URL"));
        Object[] o = null;
        try {
            o = client.invoke("receiveResportServMon", new Object[]{xml});
            for (int i = 0; i < o.length; ++i) {
                responseXML = o[0].toString();
            }
            String response = OipCommonUtil.getXpathElement((String)responseXML);
            this.log.info("[\u670d\u52a1\u72b6\u6001\u4e0a\u62a5]\u53d1\u9001\u6570\u636e\u8fd4\u56de\u7ed3\u679c" + response);
            if (response.toUpperCase().equals("SUCCESS")) {
                Date lastDate = null;
                for (SrpServMonDto dto : list) {
                    if (lastDate == null) {
                        lastDate = dto.getAnalysisEndTime();
                        continue;
                    }
                    lastDate = dto.getAnalysisEndTime().after(lastDate) ? dto.getAnalysisEndTime() : lastDate;
                }
                if (lastDate != null) {
                    this.servRegService.updateLastReportTime(lastDate);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getPreTime(String sj1, int jj) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String mydate1 = "";
        try {
            Date date1 = format.parse(sj1);
            long Time2 = date1.getTime() / 1000L + (long)(jj * 60);
            date1.setTime(Time2 * 1000L);
            mydate1 = format.format(date1);
        }
        catch (Exception e) {
            // empty catch block
        }
        return mydate1;
    }

    public IServRegService getServRegService() {
        return this.servRegService;
    }

    public void setServRegService(IServRegService servRegService) {
        this.servRegService = servRegService;
    }
}

