/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.oip.Srp.pesistence.dao;

import cn.com.starit.common.persistence.GenericHibernateDao;
import cn.com.starit.common.persistence.Page;
import cn.com.starit.common.util.StringUtil;
import cn.com.starit.oip.Srp.dto.ConnServRegDto;
import cn.com.starit.oip.Srp.dto.ConnSrpRegDto;
import cn.com.starit.oip.Srp.dto.SrpServMonDto;
import cn.com.starit.oip.Srp.dto.StConfigDto;
import cn.com.starit.oip.Srp.pesistence.entity.ConnServReg;
import cn.com.starit.oip.Srp.pesistence.entity.ConnVisitLimitSr;
import cn.com.starit.tsaip.monitor.dto.ServFluxCtrlDto;
import cn.com.starit.tsaip.register.dto.StaticDataDto;
import cn.com.starit.tsaip.register.util.ConfigControl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateCallback;

public class SrpServDao
extends GenericHibernateDao<ConnServReg, Long> {
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public ConnServReg getConnSrpRegByPlainCode(String servCode) {
        DetachedCriteria dc = DetachedCriteria.forClass(ConnServReg.class);
        dc.add((Criterion)Restrictions.eq((String)"connServCode", (Object)servCode));
        Object obj = this.getHibernateTemplate().execute((HibernateCallback)new /* Unavailable Anonymous Inner Class!! */);
        return obj == null ? null : (ConnServReg)obj;
    }

    public List<ConnServReg> getAllConnSrpReg() {
        DetachedCriteria dc = DetachedCriteria.forClass(ConnServReg.class);
        return this.findByCriteria(dc);
    }

    public Page<ConnServRegDto> findConnServ(Page<ConnServRegDto> page, ConnServRegDto dto) {
        String hql = "select new cn.com.starit.oip.Srp.dto.ConnServRegDto(Conn.connServId,Conn.connServCode,Conn.connServName,Conn.connServType,Conn.areaCode,dic.businname,Conn.connRoutePlatCode,Conn.provideCode,Conn.connServInvokeMode,Conn.connServStatus,Conn.connServProcStatus,Conn.wsdlId,Conn.protocolId,Conn.delFlag,Conn.description,Conn.servDefineId,Conn.addServTime,Conn.updateServTime,Conn.firstUploadTime,Conn.lastUploadTime,Conn.downloadTime)  from ConnServReg Conn,BndictTDictionary dic  where  Conn.delFlag = 0 and Conn.areaCode= dic.id.businid  and dic.id.busintypeid = 'AREA_CODE' ";
        if (dto != null) {
            hql = hql + (dto.getConnServCode() == null || dto.getConnServCode().trim().equals("") ? " " : " and (Conn.connServCode LIKE '%" + dto.getConnServCode() + "%' or Conn.connServName LIKE '%" + dto.getConnServCode() + "%')");
            hql = hql + (dto.getConnRoutePlatCode() == null || dto.getConnRoutePlatCode().trim().equals("") ? " " : " and Conn.connRoutePlatCode ='" + dto.getConnRoutePlatCode() + "'");
        }
        hql = hql + " order by Conn.connServId";
        Page resultPage = this.findPage(page, hql, new Object[0]);
        return resultPage;
    }

    public List<ConnSrpRegDto> findconnPlat() {
        String hql = "select new cn.com.starit.oip.Srp.dto.ConnSrpRegDto(srp.connRoutePlatCode,srp.connRoutePlatName) from ConnSrpReg srp";
        return this.find(hql, new Object[0]);
    }

    public List<ConnServRegDto> findConnServ(String connRoutePlatCode) {
        String hql = "select new cn.com.starit.oip.Srp.dto.ConnServRegDto(Conn.connServCode,Conn.connServName) from ConnServReg Conn where Conn.delFlag=0";
        hql = hql + (connRoutePlatCode != null && !"".trim().equals(connRoutePlatCode) ? " and Conn.connRoutePlatCode='" + connRoutePlatCode + "'" : "");
        return this.find(hql, new Object[0]);
    }

    public List<ConnServRegDto> findConnManServ(String provideCode) {
        String hql = "select new cn.com.starit.oip.Srp.dto.ConnServRegDto(Conn.connServId,Conn.connServCode,Conn.connServName,Conn.connServType,Conn.areaCode,Conn.connRoutePlatCode,Conn.provideCode,Conn.connServInvokeMode,Conn.connServStatus,Conn.connServProcStatus,Conn.wsdlId,Conn.protocolId,Conn.delFlag,Conn.description,Conn.servDefineId) from ConnServReg Conn where 1=1 and Conn.delFlag = 0";
        if (provideCode != null && !provideCode.trim().equals("")) {
            hql = hql + " and Conn.provideCode = '" + provideCode + "'";
        }
        List list = this.find(hql, new Object[0]);
        return list;
    }

    public List<StConfigDto> queryLocalAreaCode() {
        String hql = "select new cn.com.starit.oip.Srp.dto.StConfigDto(st.configId,st.configKey,st.configValue) from StConfig st where 1 = 1 and st.configKey = 'SRP_CODE'";
        return this.find(hql, new Object[0]);
    }

    public List<StaticDataDto> queryConnServManCode(String servManCode) {
        String hql = "SELECT new cn.com.starit.tsaip.register.dto.StaticDataDto(dic.id.businid,dic.businname) From BndictTDictionary dic WHERE dic.id.busintypeid = 'SERV_MAN_CONVERT' and dic.businname = '" + servManCode + "'";
        return this.find(hql, new Object[0]);
    }

    public List<ServFluxCtrlDto> getServFluxCtrlDtoByServDefineId(Long servDefineId) {
        String hql = "select bean.countUp,bean.oneBusiBagUp,bean.busiRateUp from ServFluxCtl bean, ServDefine s where bean.servAffordManReg.servId = s.servAffordManReg.servId and s.servDefineId=" + servDefineId;
        List list = this.find(hql, new Object[0]);
        ArrayList<ServFluxCtrlDto> res = new ArrayList<ServFluxCtrlDto>();
        for (int i = 0; i < list.size(); ++i) {
            Object[] objs = (Object[])list.get(i);
            ServFluxCtrlDto servFluxCtrlDto = new ServFluxCtrlDto();
            servFluxCtrlDto.setBusiRateUp(StringUtil.getFloatFrom((Object)objs[1]));
            servFluxCtrlDto.setCountUp(StringUtil.getLongFrom((Object)objs[0]));
            servFluxCtrlDto.setOneBusiBagUp(StringUtil.getFloatFrom((Object)objs[2]));
            res.add(servFluxCtrlDto);
        }
        return res;
    }

    public Object[] getWsdl(Long wsdlId) {
        String hql = "select s.wsdlName,s.proxyWsdlText from WsdlConf s where s.wsdlId=?";
        List list = this.find(hql, new Object[]{wsdlId});
        if (list.size() > 0) {
            return (Object[])list.get(0);
        }
        return null;
    }

    public Object[] getProtocolFilePath(Long pfId) {
        Object obj = this.getHibernateTemplate().execute((HibernateCallback)new /* Unavailable Anonymous Inner Class!! */);
        return obj == null ? null : ((String)obj).split(";");
    }

    private String getDateFromStconfig(String key) {
        return ConfigControl.getStConfigCache().getConfigValue((Object)key) == null ? "" : (String)ConfigControl.getStConfigCache().getConfigValue((Object)key);
    }

    public List<SrpServMonDto> getServMon(Date startDate) {
        String sql = "select c.conn_serv_code,m.request_times,m.failure_rate,m.busi_serv_avg_time,m.csb_achieve_avg_time,m.busi_mo_sum,m.busi_mo_avg,m.analysis_end_time from serv_mon m , conn_serv_reg c where m.analysis_end_time> to_date(?,'" + this.getDateFromStconfig("SYS_DATA_YMD_HMS") + "') and m.serv_id=c.conn_serv_id and m.conn_flag=2";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List res = this.findBySQL(sql, new Object[]{sdf.format(startDate)});
        ArrayList<SrpServMonDto> list = new ArrayList<SrpServMonDto>();
        for (Object[] obj : res) {
            SrpServMonDto dto = new SrpServMonDto((String)obj[0], StringUtil.getLongFrom((Object)obj[1]), StringUtil.getDoubleFrom((Object)obj[2]), StringUtil.getLongFrom((Object)obj[3]), StringUtil.getLongFrom((Object)obj[4]), StringUtil.getLongFrom((Object)obj[5]), StringUtil.getLongFrom((Object)obj[6]), (Date)obj[7]);
            list.add(dto);
        }
        return list;
    }

    public Date getLastReportTime() {
        String hql = "select t.end_time from aip_analysis_end_time t where t.flag='serv_mon_sc' ";
        List list = this.findBySQL(hql, new Object[0]);
        if (list != null && list.size() > 0) {
            return (Date)list.get(0);
        }
        return null;
    }

    public void updateLastReportTime(Date startDate) {
        if (this.getLastReportTime() != null) {
            String sql = "update aip_analysis_end_time t set t.end_time=to_date(?,'" + this.getDateFromStconfig("SYS_DATA_YMD_HMS") + "') where t.flag='serv_mon_sc'";
            this.getHibernateTemplate().execute((HibernateCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            String sql = "insert into aip_analysis_end_time values(AIP_ANALYSIS_TIME_ID.Nextval,to_date(?,'" + this.getDateFromStconfig("SYS_DATA_YMD_HMS") + "'),'serv_mon_sc')";
            this.getHibernateTemplate().execute((HibernateCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public List<ConnVisitLimitSr> getConnVisitLimitSrByConnServCode(String connServCode) {
        String hql = "from ConnVisitLimitSr t where t.connServCode=?";
        return this.find(hql, new Object[]{connServCode});
    }

    public ConnServReg getConnSrpRegByPlainId(Long id) {
        DetachedCriteria dc = DetachedCriteria.forClass(ConnServReg.class);
        dc.add((Criterion)Restrictions.eq((String)"connServId", (Object)id));
        Object obj = this.getHibernateTemplate().execute((HibernateCallback)new /* Unavailable Anonymous Inner Class!! */);
        return obj == null ? null : (ConnServReg)obj;
    }

    public List<ConnServReg> getAllConnSrpReg(String connPlatCode) {
        DetachedCriteria dc = DetachedCriteria.forClass(ConnServReg.class);
        dc.add((Criterion)Restrictions.eq((String)"connRoutePlatCode", (Object)connPlatCode));
        return this.findByCriteria(dc);
    }

    public List<ConnServReg> queryConnServByCode(Long connServId, String connServCode) {
        String hql = "From ConnServReg  where connServCode='" + connServCode + "'";
        hql = hql + (connServId != null && connServId > 0L ? " and connServId!=" + connServId : " ");
        return this.find(hql, new Object[0]);
    }

    static /* synthetic */ SimpleDateFormat access$000(SrpServDao x0) {
        return x0.sdf;
    }
}

