/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.oip.Srp.biz.impl;

import cn.com.starit.common.persistence.Page;
import cn.com.starit.oip.Srp.biz.IServRegService;
import cn.com.starit.oip.Srp.dto.ConnServRegDto;
import cn.com.starit.oip.Srp.dto.ConnSrpRegDto;
import cn.com.starit.oip.Srp.dto.SrpServMonDto;
import cn.com.starit.oip.Srp.dto.StConfigDto;
import cn.com.starit.oip.Srp.pesistence.dao.SrpServDao;
import cn.com.starit.oip.Srp.pesistence.entity.ConnServReg;
import cn.com.starit.oip.Srp.pesistence.entity.ConnVisitLimitSr;
import cn.com.starit.tsaip.esb.plugin.cache.facade.CacheController;
import cn.com.starit.tsaip.monitor.dto.ServFluxCtrlDto;
import cn.com.starit.tsaip.register.dto.StaticDataDto;
import java.util.Date;
import java.util.List;

public class ServRegServiceImpl
implements IServRegService {
    private SrpServDao srpServDao;

    public long addConnServReg(ConnServReg connSrpReg) {
        long id = (Long)this.srpServDao.save((Object)connSrpReg);
        return id;
    }

    public List<ConnServReg> getAllConnServReg() {
        return this.srpServDao.getAllConnSrpReg();
    }

    public List<ConnSrpRegDto> findconnPlat() {
        return this.srpServDao.findconnPlat();
    }

    public List<ConnServRegDto> findConnServ(String connRoutePlatCode) {
        return this.srpServDao.findConnServ(connRoutePlatCode);
    }

    public List<ConnServRegDto> findConnManServ(String provideCode) {
        return this.srpServDao.findConnManServ(provideCode);
    }

    public void updateConnServReg(ConnServReg connSrpReg) {
        this.srpServDao.update((Object)connSrpReg);
    }

    public boolean updateServInfos(List<ConnServReg> list) {
        try {
            for (ConnServReg entity : list) {
                boolean flag = false;
                ConnServReg connServReg = this.srpServDao.getConnSrpRegByPlainCode(entity.getConnServCode());
                if (connServReg != null) {
                    if (entity.getAreaCode() != null && !entity.getAreaCode().equals(connServReg.getAreaCode())) {
                        flag = true;
                        connServReg.setAreaCode(entity.getAreaCode());
                    }
                    if (entity.getConnRoutePlatCode() != null && !entity.getConnRoutePlatCode().equals(connServReg.getConnRoutePlatCode())) {
                        flag = true;
                        connServReg.setConnRoutePlatCode(entity.getConnRoutePlatCode());
                    }
                    if (entity.getConnServCode() != null && !entity.getConnServCode().equals(connServReg.getConnServCode())) {
                        flag = true;
                        connServReg.setConnServCode(entity.getConnServCode());
                    }
                    if (connServReg.getConnServInvokeMode() != entity.getConnServInvokeMode()) {
                        flag = true;
                        connServReg.setConnServInvokeMode(entity.getConnServInvokeMode());
                    }
                    if (entity.getConnServName() != null && !entity.getConnServName().equals(connServReg.getConnServName())) {
                        flag = true;
                        connServReg.setConnServName(entity.getConnServName());
                    }
                    if (connServReg.getConnServProcStatus() != entity.getConnServProcStatus()) {
                        flag = true;
                        connServReg.setConnServProcStatus(entity.getConnServProcStatus());
                    }
                    if (connServReg.getConnServStatus() != entity.getConnServStatus()) {
                        flag = true;
                        connServReg.setConnServStatus(entity.getConnServStatus());
                    }
                    if (connServReg.getConnServType() != entity.getConnServType()) {
                        flag = true;
                        connServReg.setConnServType(entity.getConnServType());
                    }
                    if (entity.getDescription() != null && !entity.getDescription().equals(connServReg.getDescription())) {
                        flag = true;
                        connServReg.setDescription(entity.getDescription());
                    }
                    if (connServReg.getProtocolId() != entity.getConnServType()) {
                        flag = true;
                        connServReg.setProtocolId(entity.getProtocolId());
                    }
                    if (entity.getProvideCode() != null && !entity.getProvideCode().equals(connServReg.getProvideCode())) {
                        flag = true;
                        connServReg.setProvideCode(entity.getProvideCode());
                    }
                    if (connServReg.getWsdlId() != entity.getWsdlId()) {
                        flag = true;
                        connServReg.setWsdlId(entity.getWsdlId());
                    }
                    if (connServReg.getDelFlag() != entity.getDelFlag()) {
                        flag = true;
                        connServReg.setDelFlag(entity.getDelFlag());
                    }
                    connServReg.setConnServProcStatus(3L);
                    connServReg.setDownloadTime(new Date());
                    this.srpServDao.update((Object)connServReg);
                    continue;
                }
                entity.setConnServProcStatus(3L);
                entity.setDownloadTime(new Date());
                this.srpServDao.save((Object)entity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public List<StConfigDto> queryLocalAreaCode() {
        return this.srpServDao.queryLocalAreaCode();
    }

    public List<StaticDataDto> queryConnServManCode(String servManCode) {
        return this.srpServDao.queryConnServManCode(servManCode);
    }

    public void delete(ConnServReg entity) {
        String connServCode = entity.getConnServCode();
        this.srpServDao.delete((Object)entity);
        this.deleteSingleCache(connServCode);
    }

    public Page<ConnServRegDto> findConnServReg(Page<ConnServRegDto> page, ConnServRegDto dto) {
        return this.srpServDao.findConnServ(page, dto);
    }

    public List<ServFluxCtrlDto> getServFluxCtrlDtoByServDefineId(Long servDefineId) {
        return this.srpServDao.getServFluxCtrlDtoByServDefineId(servDefineId);
    }

    public Object[] getProtocolFilePath(Long pfId) {
        return this.srpServDao.getProtocolFilePath(pfId);
    }

    public Object[] getWsdl(Long wsdlId) {
        return this.srpServDao.getWsdl(wsdlId);
    }

    public List<SrpServMonDto> getServMonSrp(Date startDate) {
        return this.srpServDao.getServMon(startDate);
    }

    public Date getLastReportTime() {
        return this.srpServDao.getLastReportTime();
    }

    public void updateLastReportTime(Date startDate) {
        this.srpServDao.updateLastReportTime(startDate);
    }

    public boolean deleteCache(List<ConnServReg> list) {
        String connServCode = "";
        for (ConnServReg serv : list) {
            if (connServCode.equals(serv.getConnServCode())) continue;
            connServCode = serv.getConnServCode();
            this.deleteSingleCache(connServCode);
        }
        return true;
    }

    private void deleteSingleCache(String connServCode) {
        List cvls = this.srpServDao.getConnVisitLimitSrByConnServCode(connServCode);
        long cvlId = 0L;
        for (ConnVisitLimitSr cvl : cvls) {
            cvlId = cvl.getConnServLimitId();
            this.srpServDao.getHibernateTemplate().delete((Object)cvl);
            CacheController.updateCache((int)16, (long)cvlId);
        }
    }

    public ConnServReg getConnServRegDto(Long id) {
        return this.srpServDao.getConnSrpRegByPlainId(id);
    }

    public List<ConnServReg> getAllConnServReg(String connPlatCode) {
        return this.srpServDao.getAllConnSrpReg(connPlatCode);
    }

    public ConnServReg getConnServRegDto(String connServCode) {
        return this.srpServDao.getConnSrpRegByPlainCode(connServCode);
    }

    public List<ConnServReg> queryConnServByCode(Long connServId, String connServCode) {
        return this.srpServDao.queryConnServByCode(connServId, connServCode);
    }

    public SrpServDao getSrpServDao() {
        return this.srpServDao;
    }

    public void setSrpServDao(SrpServDao srpServDao) {
        this.srpServDao = srpServDao;
    }
}

