/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.oip.Scp.wsClient;

import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;

public class ServiceLocator {
    private static ServiceLocator srvLocator = new ServiceLocator();
    private static Map<String, Class<?>> seiMap = null;
    private Map<String, Object> map = new HashMap();
    private Map<String, Client> clientMap = new HashMap();

    private ServiceLocator() {
    }

    public static ServiceLocator getInstance() {
        return srvLocator;
    }

    public <T> T getEndpoint(String sysName, String address, Class<T> endpoint, long timeout) {
        Object t = this.map.get(sysName);
        if (t != null) {
            return (T)t;
        }
        t = this.createEndpoint(sysName, address, endpoint, timeout);
        this.map.put(sysName, t);
        return (T)t;
    }

    public <T> T getEndpoint(String sysName, String address, Class<T> endpoint) {
        return (T)this.getEndpoint(sysName, address, endpoint, 10L);
    }

    private synchronized <T> T createEndpoint(String sysName, String address, Class<T> endpoint, long timeout) {
        Object t = this.map.get(sysName);
        if (t != null) {
            return (T)t;
        }
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.getInInterceptors().add(new LoggingInInterceptor());
        factory.getOutInterceptors().add(new LoggingOutInterceptor());
        factory.setServiceClass(endpoint);
        factory.setAddress(address);
        t = factory.create();
        this.setTimeout(t, timeout);
        return (T)t;
    }

    private void setTimeout(Object stub, long timeout) {
        Client client = ClientProxy.getClient((Object)stub);
        this.setTimeout(client, timeout);
    }

    private void setTimeout(Client client, long timeout) {
        HTTPConduit http = (HTTPConduit)client.getConduit();
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setConnectionTimeout(timeout * 1000L * 60L);
        httpClientPolicy.setReceiveTimeout(timeout * 1000L * 60L);
        http.setClient(httpClientPolicy);
    }

    public Client getClient(String sysName, String address, long timeout) {
        Client client = (Client)this.clientMap.get(sysName);
        if (client != null) {
            return client;
        }
        client = this.createClient(sysName, address, timeout);
        this.clientMap.put(sysName, client);
        return client;
    }

    private synchronized Client createClient(String sysName, String adress, long timeout) {
        Client client = (Client)this.clientMap.get(sysName);
        if (client != null) {
            return client;
        }
        JaxWsDynamicClientFactory fb = JaxWsDynamicClientFactory.newInstance();
        client = fb.createClient(adress);
        client.getOutInterceptors().add(new LoggingOutInterceptor());
        client.getInInterceptors().add(new LoggingInInterceptor());
        this.setTimeout(client, timeout);
        return client;
    }

    public Client getClient(String sysName, String address) {
        return this.getClient(sysName, address, 10L);
    }
}

