/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.oip.Scp.dto;

import cn.com.starit.oip.Scp.dto.GatherTaskScDto;
import cn.com.starit.tsaip.esb.plugin.db.AbstractDBDao;
import cn.com.starit.tsaip.register.util.ConfigControl;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.sql.rowset.CachedRowSet;

public class GatherDao
extends AbstractDBDao {
    private static String dateFormatSql = "select config_value from st_config where config_key='SYS_DATA_YMD_HMS'";
    private static String taskSql = "select task_id,oip_code,serv_oip_code,serv_set,address,to_char(end_time,?) end_time from serv_instance_gather_task_sc";
    private static String getBatchId = "select check_batch_id.nextval batch_id from dual";
    private static String getBatchId1 = "select check_batch_id.nextval batch_id from sysmaster:informix.sysdual";
    private static String saveBatch = "insert into check_batch (check_batch_id,sys_code,serv_oip_code,aim_address) values (?,?,?,?)";
    private static String updateEndTime = "update serv_instance_gather_task_sc set end_time =? ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GatherTaskScDto> queryTasks() {
        Connection conn = null;
        ArrayList<GatherTaskScDto> list = null;
        CachedRowSet crs = null;
        GatherTaskScDto gtsd = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            conn = this.getConnection();
            String dateFormat = this.getDateFormat();
            crs = this.executeQuery(conn, taskSql, new Object[]{dateFormat});
            list = new ArrayList<GatherTaskScDto>();
            while (crs.next()) {
                gtsd = new GatherTaskScDto();
                gtsd.setId(crs.getLong("TASK_ID"));
                gtsd.setOipCode(crs.getString("OIP_CODE"));
                gtsd.setServOipCode(crs.getString("SERV_OIP_CODE"));
                gtsd.setAddress(crs.getString("ADDRESS"));
                gtsd.setEndTime(sdf.parse(crs.getString("END_TIME")));
                gtsd.setServSet(crs.getString("SERV_SET"));
                list.add(gtsd);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        finally {
            this.close(conn);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDateFormat() {
        Connection conn = null;
        CachedRowSet crs = null;
        String dateFormat = "yyyy-mm-dd hh24:mi:ss";
        try {
            conn = this.getConnection();
            crs = this.executeQuery(conn, dateFormatSql, new Object[0]);
            while (crs.next()) {
                dateFormat = crs.getString("CONFIG_VALUE");
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        finally {
            this.close(conn);
        }
        return dateFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBatchid() {
        Connection conn = null;
        long batchid = 0L;
        CachedRowSet crs = null;
        try {
            conn = this.getConnection();
            crs = this.executeQuery(conn, this.getgetBatchIdSql(), new Object[0]);
            while (crs.next()) {
                batchid = crs.getLong("BATCH_ID");
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        finally {
            this.close(conn);
        }
        return batchid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBatch(long batchId, String sys_code, String serv_oip_code, String aim_address) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            this.executeUpdate(conn, saveBatch, new Object[]{batchId, sys_code, serv_oip_code, aim_address});
            conn.commit();
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        finally {
            this.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEndTime(Date date) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            this.executeUpdate(conn, updateEndTime, new Object[]{new Timestamp(date.getTime())});
            conn.commit();
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        finally {
            this.close(conn);
        }
    }

    private String getgetBatchIdSql() {
        if (this.isOracle()) {
            return getBatchId;
        }
        return getBatchId1;
    }

    private boolean isOracle() {
        Object obj = ConfigControl.getStConfigCache().getConfigValue((Object)"DB_TYPE");
        if (obj == null) {
            return true;
        }
        String dbType = (String)obj;
        return dbType.toUpperCase().equals("ORACLE");
    }
}

