/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.oip.Scp.biz.impl;

import cn.com.starit.oip.Scp.biz.IConnHeartBeatService;
import cn.com.starit.oip.Scp.persistence.dao.ScpConnHeartBeatDao;
import cn.com.starit.oip.Scp.persistence.dao.ScpDao;
import cn.com.starit.oip.Scp.persistence.entity.ConnHeartBeat;
import cn.com.starit.oip.Scp.persistence.entity.ConnSrpRegSc;
import cn.com.starit.tsaip.register.util.ConfigControl;
import java.util.Date;
import java.util.List;

public class ConnHeartBeatServiceImpl
implements IConnHeartBeatService {
    private final int SRP_NORMAL = 1;
    private final int SRP_ABNORMAL = 2;
    private ScpConnHeartBeatDao scpConnHeartBeatDao;
    private ScpDao scpDao;

    public void save(ConnHeartBeat entity) {
        this.scpConnHeartBeatDao.save((Object)entity);
    }

    public List findByPlatCode(String platCodeStr) {
        return this.scpConnHeartBeatDao.findByPlatCode(platCodeStr);
    }

    public List findByPlatCodeList(String platCodeStr) {
        return this.scpDao.findConnSrpRegScByCodeList(platCodeStr);
    }

    public void update(ConnHeartBeat entity) {
        this.scpConnHeartBeatDao.update((Object)entity);
    }

    public void updateSrpEntity(ConnSrpRegSc entity) {
        this.scpDao.update((Object)entity);
    }

    public void runHeart() {
        int heartTimeOut = ConfigControl.getStConfigCache().getConfigValue((Object)"HEART_TIME_OUT") == null ? 40 : Integer.parseInt((String)ConfigControl.getStConfigCache().getConfigValue((Object)"HEART_TIME_OUT"));
        long nowTime = System.currentTimeMillis();
        List srpList = this.scpDao.findConnSrpRegScList();
        List heartList = this.scpConnHeartBeatDao.findConnHeartBeat();
        if (srpList.size() < 1) {
            return;
        }
        ConnHeartBeat heartBean = null;
        for (ConnSrpRegSc entity : srpList) {
            System.out.println("---------------------------------\u68c0\u6d4b\u5f00\u59cb----------------------------");
            List entityList = this.scpConnHeartBeatDao.findByPlatCode(entity.getConnRoutePlatCode());
            if (entityList == null || entityList.size() == 0) {
                entity.setSrpDynamicStatus(2L);
                this.scpDao.update((Object)entity);
                continue;
            }
            heartBean = (ConnHeartBeat)entityList.get(0);
            Date endDate = heartBean.getEndReportTime();
            long endTime = endDate.getTime();
            long minuters = (nowTime - endTime) / 1000L / 60L;
            System.out.println(minuters);
            if (minuters > (long)heartTimeOut) {
                entity.setSrpDynamicStatus(2L);
                this.scpDao.update((Object)entity);
                System.out.println("----------------------------" + entity.getConnRoutePlatName() + "\u6ca1\u6709\u66f4\u65b0----------------------------");
            } else {
                System.out.println("----------------------------" + entity.getConnRoutePlatName() + "\u5df2\u7ecf\u66f4\u65b0----------------------------");
                entity.setSrpDynamicStatus(1L);
                this.scpDao.saveOrUpdate((Object)entity);
            }
            System.out.println("---------------------------------\u68c0\u6d4b\u7ed3\u675f----------------------------");
        }
    }

    public void setScpDao(ScpDao scpDao) {
        this.scpDao = scpDao;
    }

    public void setScpConnHeartBeatDao(ScpConnHeartBeatDao scpConnHeartBeatDao) {
        this.scpConnHeartBeatDao = scpConnHeartBeatDao;
    }
}

