/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.web.security.dwr;

import cn.com.starit.inas.biz.log.LogServiceProvider;
import cn.com.starit.inas.biz.log.SysLogManager.util.OperationResult;
import cn.com.starit.inas.biz.log.SysLogManager.util.OperationType;
import cn.com.starit.inas.biz.security.IEncrypter;
import cn.com.starit.inas.biz.security.SecurityServiceProvider;
import cn.com.starit.inas.biz.tree.TreeServiceProvider;
import cn.com.starit.inas.biz.tree.node.Node;
import cn.com.starit.inas.biz.tree.node.impl.MenuCompositeNode;
import cn.com.starit.inas.biz.tree.node.impl.MenuFunctionNode;
import cn.com.starit.inas.persistence.dao.security.UserInfoDao;
import cn.com.starit.inas.persistence.po.security.UserInfo;
import cn.com.starit.inas.persistence.po.security.UserRoleInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserInfoManager {
    public static final Long DEFAULT_DEL_FLAG = 0L;
    private Log log = LogFactory.getLog(UserInfoManager.class);

    public String save(String userCode, String userName, Long sex, String phone, String modile, String email, Long organId, Date limitTime, Long limitTimeType, String remark, HttpSession session) {
        UserInfo userInfo = (UserInfo)session.getAttribute("USER_INFO");
        IEncrypter encripter = SecurityServiceProvider.getEncrypter();
        String content = "\u673a\u6784ID:<" + organId + ">\u4e0b\u65b0\u589e\u52a0\u7528\u6237\u540d\u79f0:<" + userName + ">";
        try {
            UserInfo newUserInfo = this.createUserInfo(userCode, userName, sex, phone, modile, email, organId, limitTime, limitTimeType, remark);
            newUserInfo.setDelFlag(DEFAULT_DEL_FLAG);
            newUserInfo.setPassword(encripter.encrypt("000000"));
            String strResult = (String)((Object)SecurityServiceProvider.getUserInfoDao().save(newUserInfo));
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Add, OperationResult.SUCC, content);
            return strResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Add, OperationResult.FAIL, content);
            return null;
        }
    }

    public boolean resumePassword(String userId, HttpSession session) {
        UserInfo userInfo = (UserInfo)session.getAttribute("USER_INFO");
        String content = "\u6062\u590d\u539f\u59cb\u5bc6\u7801";
        IEncrypter encripter = SecurityServiceProvider.getEncrypter();
        String encripterPassword = encripter.encrypt("000000");
        try {
            UserInfo uInfo = SecurityServiceProvider.getUserInfoDao().getUserInfoByUserId(userId);
            uInfo.setPassword(encripterPassword);
            SecurityServiceProvider.getUserInfoDao().update(uInfo);
            SecurityServiceProvider.getOnlineUserManager().updatePassword(uInfo.getUserId(), encripterPassword);
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Other, OperationResult.SUCC, content);
            this.log.info((Object)(uInfo.getUserId() + ",\u6062\u590d\u539f\u59cb\u5bc6\u7801\u6210\u529f\uff01"));
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)"\u6062\u590d\u65f6\u539f\u59cb\u5bc6\u7801->\u9519\u8bef!");
            this.log.error((Object)e.getMessage());
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Other, OperationResult.FAIL, content);
            return false;
        }
    }

    public boolean update(String userCode, String userName, Long sex, String phone, String modile, String email, Long organId, Date limitTime, Long limitTimeType, String remark, HttpSession session) {
        UserInfo userInfo = (UserInfo)session.getAttribute("USER_INFO");
        String content = "\u673a\u6784ID:<" + organId + ">\u4e0b\u7528\u6237ID:[" + userCode + "],\u4fee\u6539\u7528\u6237\u4fe1\u606f";
        try {
            UserInfoDao dao = SecurityServiceProvider.getUserInfoDao();
            UserInfo info = this.createUserInfo(userCode, userName, sex, phone, modile, email, organId, limitTime, limitTimeType, remark);
            UserInfo sInfo = dao.getUserInfoByUserId(userCode);
            if (info.getDelFlag() == null) {
                info.setDelFlag(Long.valueOf(Long.parseLong("0")));
            }
            info.setPassword(sInfo.getPassword());
            info.setLastLoginTime(sInfo.getLastLoginTime());
            SecurityServiceProvider.getUserInfoDao().update(info);
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Update, OperationResult.SUCC, content);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Update, OperationResult.FAIL, content);
            return false;
        }
        return true;
    }

    public boolean updateSelf(String userCode, String userName, Long sex, String phone, String modile, String email, HttpSession session) {
        UserInfo userInfo = (UserInfo)session.getAttribute("USER_INFO");
        String content = "\u7528\u6237ID:<" + userCode + ">\u4fee\u6539\u7528\u6237\u4fe1\u606f";
        try {
            SecurityServiceProvider.getUserInfoDao().updateSelf(userCode, userName, sex, phone, modile, email);
            userInfo.setUserId(userCode);
            userInfo.setName(userName);
            userInfo.setSex(sex);
            userInfo.setPhone(phone);
            userInfo.setModile(modile);
            userInfo.setEmail(email);
            session.setAttribute("USER_INFO", (Object)userInfo);
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Update, OperationResult.SUCC, content);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Update, OperationResult.FAIL, content);
            return false;
        }
    }

    public int updatePassword(String originalPswd, String newPswd, HttpSession session) {
        UserInfo uInfo = (UserInfo)session.getAttribute("USER_INFO");
        String content = "\u4fee\u6539\u4e2a\u4eba\u5bc6\u7801";
        IEncrypter encripter = SecurityServiceProvider.getEncrypter();
        String originalTempPswd = encripter.encrypt(originalPswd);
        if (originalTempPswd.equals(uInfo.getPassword())) {
            uInfo.setPassword(encripter.encrypt(newPswd));
            try {
                SecurityServiceProvider.getUserInfoDao().update(uInfo);
                if (1L == uInfo.getLimitTimeType()) {
                    SecurityServiceProvider.getUserInfoDao().updateLimitTime(uInfo.getUserId());
                }
                LogServiceProvider.getSysLogHandler().handle(uInfo, OperationType.Update, OperationResult.SUCC, content);
                return 1;
            }
            catch (Exception ex) {
                uInfo.setPassword(originalTempPswd);
                LogServiceProvider.getSysLogHandler().handle(uInfo, OperationType.Update, OperationResult.FAIL, content);
                return 2;
            }
        }
        return 3;
    }

    public boolean deleteUser(String userCode, Long delFlag, HttpSession session) {
        UserInfo userInfo = (UserInfo)session.getAttribute("USER_INFO");
        String content = "\u5220\u9664\u7528\u6237" + userCode;
        try {
            SecurityServiceProvider.getUserInfoDao().delete(userCode, delFlag);
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Remove, OperationResult.SUCC, content);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Remove, OperationResult.FAIL, content);
            return false;
        }
        return true;
    }

    public boolean saveUserRoleInfo(String userCode, int roleId, HttpSession session) {
        UserInfo userInfo = (UserInfo)session.getAttribute("USER_INFO");
        String content = "\u7528\u6237ID:" + userCode + "\u4e0b, \u65b0\u589e\u89d2\u8272ID:" + roleId;
        try {
            SecurityServiceProvider.getUserInfoDao().saveUserRoleInfo(userCode, (long)roleId);
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Add, OperationResult.SUCC, content);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Add, OperationResult.FAIL, content);
            return false;
        }
        return true;
    }

    public boolean delUserRoleInfo(String userCode, int roleId, HttpSession session) {
        UserInfo userInfo = (UserInfo)session.getAttribute("USER_INFO");
        String content = "\u5220\u9664\u89d2\u8272ID:" + roleId;
        try {
            SecurityServiceProvider.getUserInfoDao().delUserRoleInfo(userCode, (long)roleId);
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Remove, OperationResult.SUCC, content);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Remove, OperationResult.FAIL, content);
            return false;
        }
        return true;
    }

    public List<String> findUserRoleInfo(String userCode) {
        List list = SecurityServiceProvider.getUserInfoDao().findUserRoleInfo(userCode);
        ArrayList<String> temp = new ArrayList<String>();
        for (UserRoleInfo info : list) {
            temp.add(info.getId().getRoleId().toString());
        }
        return temp;
    }

    private UserInfo createUserInfo(String userCode, String userName, Long sex, String phone, String modile, String email, Long organId, Date limitTime, Long limitTimeType, String remark) {
        UserInfo info = new UserInfo();
        info.setUserId(userCode);
        info.setName(userName);
        info.setSex(sex);
        info.setPhone(phone);
        info.setModile(modile);
        info.setEmail(email);
        info.setOrganId(organId);
        info.setLimitTime(limitTime);
        info.setLimitTimeType(limitTimeType);
        info.setRemark(remark);
        return info;
    }

    public boolean findByUserId(String userId) {
        try {
            List list = SecurityServiceProvider.getUserInfoDao().findByUserID(userId);
            if (list.size() == 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public Integer findCapaByMenuId(String menuId, HttpSession session) {
        try {
            UserInfo userInfo = (UserInfo)session.getAttribute("USER_INFO");
            if (userInfo == null) {
                return 2;
            }
            Node node = TreeServiceProvider.getTreeHiberarchyManager().getNode(menuId);
            if (node != null) {
                MenuCompositeNode menuCNode = (MenuCompositeNode)node;
                if (menuCNode.getUrl() != null) {
                    boolean canUse = SecurityServiceProvider.getPowerChecker().checkMenu(userInfo.getUserId(), menuCNode.getDbId());
                    if (canUse) {
                        return 0;
                    }
                    this.log.error((Object)("\u3010\u5224\u65ad\u83dc\u5355\u6743\u9650\u3011,\u65e0\u83dc\u5355\u6743\u9650!\tmenuId=" + menuId + " ;menuCNode.getDbId()" + menuCNode.getDbId()));
                    return 1;
                }
            } else {
                this.log.error((Object)("\u3010\u5224\u65ad\u83dc\u5355\u6743\u9650\u3011,\u672a\u53d6\u5230\u83dc\u5355\u8282\u70b9,\u6539\u83dc\u5355\u8282\u70b9\u662f:" + menuId));
                return 1;
            }
            this.log.error((Object)"\u3010\u5224\u65ad\u83dc\u5355\u6743\u9650\u3011,\u53d6\u5230\u7684\u83dc\u5355\u8282\u70b9Url\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    public Integer findCapaByMenuFuncId(String menuFuncId, HttpSession session) {
        try {
            Node node;
            UserInfo userInfo = (UserInfo)session.getAttribute("USER_INFO");
            if (userInfo == null) {
                return 2;
            }
            if (menuFuncId.indexOf("menuFunc_") < 0) {
                menuFuncId = "menuFunc_" + menuFuncId;
            }
            if ((node = TreeServiceProvider.getTreeHiberarchyManager().getNode(menuFuncId)) != null) {
                MenuFunctionNode menuFuncNode = (MenuFunctionNode)node;
                return SecurityServiceProvider.getPowerChecker().checkMenuFunction(userInfo.getUserId(), menuFuncNode.getFunctionId()) ? 0 : 1;
            }
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public List<Integer> findCapaByMenuFuncIdArr(List<String> mfList, HttpSession session) {
        ArrayList<Integer> resList = new ArrayList<Integer>();
        for (String mfId : mfList) {
            resList.add(this.findCapaByMenuFuncId(mfId, session));
        }
        return resList;
    }
}

