/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.web.security.dwr;

import cn.com.starit.inas.biz.log.LogServiceProvider;
import cn.com.starit.inas.biz.log.SysLogManager.util.OperationResult;
import cn.com.starit.inas.biz.log.SysLogManager.util.OperationType;
import cn.com.starit.inas.biz.security.SecurityServiceProvider;
import cn.com.starit.inas.biz.tree.TreeServiceProvider;
import cn.com.starit.inas.biz.tree.node.Node;
import cn.com.starit.inas.biz.tree.node.impl.MenuCompositeNode;
import cn.com.starit.inas.biz.tree.node.impl.MenuFunctionNode;
import cn.com.starit.inas.biz.tree.util.NodeId;
import cn.com.starit.inas.biz.tree.util.TreeNodeName;
import cn.com.starit.inas.biz.tree.util.TreeNodePath;
import cn.com.starit.inas.persistence.po.security.RoleInfo;
import cn.com.starit.inas.persistence.po.security.RoleMenuFuncInfo;
import cn.com.starit.inas.persistence.po.security.RoleMenuFuncInfoId;
import cn.com.starit.inas.persistence.po.security.RoleMenuInfo;
import cn.com.starit.inas.persistence.po.security.RoleMenuInfoId;
import cn.com.starit.inas.persistence.po.security.UserInfo;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONArray;

public class RoleInfoManager {
    public Long save(String roleName, String strOrganId, String remark, HttpSession session) {
        UserInfo userInfo = (UserInfo)session.getAttribute("USER_INFO");
        String content = "\u65b0\u589e\u4e00\u89d2\u8272:" + roleName;
        try {
            strOrganId = strOrganId.substring(strOrganId.indexOf("_") + 1, strOrganId.length());
            Long organId = Long.parseLong(strOrganId);
            RoleInfo info = new RoleInfo();
            info.setName(roleName);
            info.setOrganId(organId);
            info.setRemark(remark);
            Long iCount = SecurityServiceProvider.getRoleInfoDao().save(info);
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Add, OperationResult.SUCC, content);
            return iCount;
        }
        catch (Exception e) {
            e.printStackTrace();
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Add, OperationResult.FAIL, content);
            return null;
        }
    }

    public boolean update(Long roleId, String roleName, String remark, HttpSession session) {
        UserInfo userInfo = (UserInfo)session.getAttribute("USER_INFO");
        String content = "\u4fee\u6539\u89d2\u8272:" + roleName;
        try {
            SecurityServiceProvider.getRoleInfoDao().bulkUpdateOrDelete(roleId, roleName, remark);
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Add, OperationResult.SUCC, content);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Add, OperationResult.FAIL, content);
            return false;
        }
        return true;
    }

    public boolean deleteRole(Long roleId, HttpSession session) {
        UserInfo userInfo = (UserInfo)session.getAttribute("USER_INFO");
        String content = "\u5220\u9664\u89d2\u8272:" + roleId;
        try {
            SecurityServiceProvider.getRoleInfoDao().delete(roleId);
            SecurityServiceProvider.getRoleInfoDao().deleteAllMenuFuncInfoByRoleId(roleId);
            SecurityServiceProvider.getRoleInfoDao().deleteAllMenuInfoByRoleId(roleId);
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Add, OperationResult.SUCC, content);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Add, OperationResult.FAIL, content);
            return false;
        }
        return true;
    }

    public boolean findByRoleName(String roleName) {
        try {
            List list = SecurityServiceProvider.getRoleInfoDao().findByRoleName(roleName);
            if (list.size() == 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean saveRoleMenuAndFunction(Integer roleId, String nodeId, HttpSession session) {
        UserInfo userInfo = (UserInfo)session.getAttribute("USER_INFO");
        String content = "\u89d2\u8272:" + roleId + "\u6dfb\u52a0\u83dc\u5355\u6743\u9650:" + nodeId;
        try {
            Node node = TreeServiceProvider.getTreeHiberarchyManager().getNode(nodeId);
            if (node == null) {
                return false;
            }
            if (node instanceof MenuCompositeNode) {
                MenuCompositeNode cNode = (MenuCompositeNode)node;
                if (cNode.getUrl() != null) {
                    RoleMenuInfo rMenuInfo = this.createRoleMenuInfo((long)roleId.intValue(), cNode.getDbId().longValue());
                    SecurityServiceProvider.getRoleInfoDao().saveRoleMenuInfo(rMenuInfo);
                }
            } else if (node instanceof MenuFunctionNode) {
                MenuFunctionNode cNode = (MenuFunctionNode)node;
                RoleMenuFuncInfo rFuncInfo = this.createRoleMenuFuncInfo((long)roleId.intValue(), cNode.getFunctionId().longValue());
                SecurityServiceProvider.getRoleInfoDao().saveRoleMenuFuncInfo(rFuncInfo);
            }
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Add, OperationResult.SUCC, content);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Add, OperationResult.FAIL, content);
            return false;
        }
    }

    public boolean deleteRoleMenuAndFunction(Integer roleId, String nodeId, HttpSession session) {
        UserInfo userInfo = (UserInfo)session.getAttribute("USER_INFO");
        String content = "\u89d2\u8272:" + roleId + "\u5220\u9664\u83dc\u5355\u6743\u9650:" + nodeId;
        try {
            Node node = TreeServiceProvider.getTreeHiberarchyManager().getNode(nodeId);
            if (node == null) {
                return false;
            }
            if (node instanceof MenuCompositeNode) {
                MenuCompositeNode cNode = (MenuCompositeNode)node;
                if (cNode.getUrl() != null) {
                    RoleMenuInfo rMenuInfo = this.createRoleMenuInfo((long)roleId.intValue(), cNode.getDbId().longValue());
                    SecurityServiceProvider.getRoleInfoDao().deleteRoleMenuInfo(rMenuInfo);
                }
            } else if (node instanceof MenuFunctionNode) {
                MenuFunctionNode cNode = (MenuFunctionNode)node;
                RoleMenuFuncInfo rFuncInfo = this.createRoleMenuFuncInfo((long)roleId.intValue(), cNode.getFunctionId().longValue());
                SecurityServiceProvider.getRoleInfoDao().deleteRoleMenuFunction(rFuncInfo);
            }
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Remove, OperationResult.SUCC, content);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Remove, OperationResult.FAIL, content);
            return false;
        }
    }

    public String getRoleMenuAndFunction(Long roleId) {
        ArrayList<TreeNodePath> pathlist = new ArrayList<TreeNodePath>();
        JSONArray arr = null;
        try {
            String compPath;
            NodeId compNodeIdObj;
            String compNodeId;
            int j;
            String path;
            NodeId nodeIdObj;
            String nodeId;
            int i;
            List list = SecurityServiceProvider.getRoleInfoDao().findRoleMenuInfoByRoleId(roleId);
            List rMenuFunclist = SecurityServiceProvider.getRoleInfoDao().findMenuFuncInfoByRoleId(roleId);
            String tempPath = "";
            TreeNodePath treeNodePath = null;
            ArrayList<NodeId> childs = null;
            for (i = 0; i < list.size(); ++i) {
                nodeId = TreeNodeName.nameMenuId((long)((RoleMenuInfo)list.get(i)).getId().getMenuId());
                nodeIdObj = new NodeId(nodeId);
                path = this.getPathByNode(nodeId);
                if (path == null || tempPath.equals(path)) continue;
                treeNodePath = new TreeNodePath();
                pathlist.add(treeNodePath);
                childs = new ArrayList<NodeId>();
                tempPath = path;
                treeNodePath.setPath(path);
                childs.add(nodeIdObj);
                treeNodePath.setChilds(childs);
                for (j = 1; j < list.size(); ++j) {
                    compNodeId = TreeNodeName.nameMenuId((long)((RoleMenuInfo)list.get(j)).getId().getMenuId());
                    compNodeIdObj = new NodeId(compNodeId);
                    compPath = this.getPathByNode(compNodeId);
                    if (!path.equals(compPath)) continue;
                    treeNodePath.setPath(compPath);
                    childs.add(compNodeIdObj);
                }
            }
            for (i = 0; i < rMenuFunclist.size(); ++i) {
                nodeId = TreeNodeName.nameMFuncId((long)((RoleMenuFuncInfo)rMenuFunclist.get(i)).getId().getFuncid());
                nodeIdObj = new NodeId(nodeId);
                path = this.getPathByNode(nodeId);
                if (path == null || tempPath.equals(path)) continue;
                treeNodePath = new TreeNodePath();
                pathlist.add(treeNodePath);
                childs = new ArrayList();
                tempPath = path;
                treeNodePath.setPath(path);
                childs.add(nodeIdObj);
                treeNodePath.setChilds(childs);
                for (j = 1; j < rMenuFunclist.size(); ++j) {
                    compNodeId = TreeNodeName.nameMFuncId((long)((RoleMenuFuncInfo)rMenuFunclist.get(j)).getId().getFuncid());
                    compNodeIdObj = new NodeId(compNodeId);
                    compPath = this.getPathByNode(compNodeId);
                    if (!path.equals(compPath)) continue;
                    treeNodePath.setPath(compPath);
                    childs.add(compNodeIdObj);
                }
            }
            arr = JSONArray.fromObject(pathlist);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (arr != null) {
            return arr.toString();
        }
        return null;
    }

    private String getPathByNode(String nodeId) {
        Node node = TreeServiceProvider.getNodeStorage().getNode(nodeId);
        if (node == null) {
            return null;
        }
        if (node.getParentNodeCount() == 0) {
            return "/" + node.getNodeId();
        }
        Node pNode = (Node)node.getParentNodes().get(0);
        String temp = this.getPathByNode(pNode.getNodeId());
        return temp + "/" + node.getNodeId();
    }

    private RoleMenuFuncInfo createRoleMenuFuncInfo(long roleId, long funcId) throws Exception {
        RoleMenuFuncInfoId rFId = new RoleMenuFuncInfoId();
        RoleMenuFuncInfo rf = new RoleMenuFuncInfo();
        rFId.setRoleId(Long.valueOf(roleId));
        rFId.setFuncid(Long.valueOf(funcId));
        rf.setId(rFId);
        return rf;
    }

    private RoleMenuInfo createRoleMenuInfo(long roleId, long menuId) throws Exception {
        RoleMenuInfoId rFId = new RoleMenuInfoId();
        RoleMenuInfo rf = new RoleMenuInfo();
        rFId.setRoleId(Long.valueOf(roleId));
        rFId.setMenuId(Long.valueOf(menuId));
        rf.setId(rFId);
        return rf;
    }
}

