/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.web.security.dwr;

import cn.com.starit.inas.biz.log.LogServiceProvider;
import cn.com.starit.inas.biz.log.SysLogManager.util.OperationResult;
import cn.com.starit.inas.biz.log.SysLogManager.util.OperationType;
import cn.com.starit.inas.biz.security.SecurityServiceProvider;
import cn.com.starit.inas.biz.tree.TreeServiceProvider;
import cn.com.starit.inas.biz.tree.node.Node;
import cn.com.starit.inas.biz.tree.node.impl.OrganCompositeNode;
import cn.com.starit.inas.biz.tree.util.TreeNodeName;
import cn.com.starit.inas.persistence.dto.security.OrganInfoDto;
import cn.com.starit.inas.persistence.po.security.OrganInfo;
import cn.com.starit.inas.persistence.po.security.UserInfo;
import java.util.List;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrganInfoManager {
    private Log log = LogFactory.getLog(OrganInfoManager.class);

    public Long save(Long tmlId, String organName, String principal, String phone, String fax, String email, long levelId, String pNodeId, Long delFlag, String remark, HttpSession session) {
        UserInfo uInfo = (UserInfo)session.getAttribute("USER_INFO");
        String content = "\u7236\u673a\u6784ID: <" + pNodeId + ">\u4e0b\u65b0\u589e\u673a\u6784Name\uff1a<" + organName + ">";
        try {
            Long pOrganId = null;
            pOrganId = pNodeId.equals("organ_root") ? null : Long.valueOf(pNodeId.substring(6));
            OrganInfo info = this.createOrganInfo(null, tmlId, organName, principal, phone, fax, email, pOrganId, Long.valueOf(levelId), delFlag, remark);
            Long organId = SecurityServiceProvider.getOrganInfoDao().save(info);
            Node pNode = TreeServiceProvider.getNodeStorage().getNode(pNodeId);
            Node node = TreeServiceProvider.getNodeFactory().createOrganNode(organId, organName, Long.valueOf(levelId));
            pNode.addChildNode(node);
            this.log.info((Object)(content + ",\u6210\u529f\uff01"));
            LogServiceProvider.getSysLogHandler().handle(uInfo, OperationType.Add, OperationResult.SUCC, content);
            return organId;
        }
        catch (Exception ex) {
            this.log.error((Object)(content + ",\u51fa\u9519\uff01"));
            this.log.error((Object)ex.getMessage());
            LogServiceProvider.getSysLogHandler().handle(uInfo, OperationType.Add, OperationResult.FAIL, content);
            return null;
        }
    }

    public boolean update(Long organId, Long tmlId, String organName, String principal, String phone, String fax, String email, String pOrganIdStr, Long levelId, Long delFlag, String remark, HttpSession session) {
        UserInfo uInfo = (UserInfo)session.getAttribute("USER_INFO");
        String content = "\u4fee\u6539\u673a\u6784ID\uff1a" + organId;
        try {
            Long pOrganId = null;
            pOrganId = pOrganIdStr == null ? null : (pOrganIdStr.equals("root") ? null : Long.valueOf(Long.parseLong(pOrganIdStr)));
            OrganInfo info = this.createOrganInfo(organId, tmlId, organName, principal, phone, fax, email, pOrganId, levelId, delFlag, remark);
            SecurityServiceProvider.getOrganInfoDao().update(info);
            OrganCompositeNode node = (OrganCompositeNode)TreeServiceProvider.getNodeStorage().getNode(TreeNodeName.nameOrganId((long)organId));
            node.setNodeName(organName);
            node.setLevel(levelId);
            this.log.info((Object)(uInfo.getName() + content + ",\u6210\u529f\uff01"));
            LogServiceProvider.getSysLogHandler().handle(uInfo, OperationType.Update, OperationResult.FAIL, content);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log.error((Object)(content + ",\u51fa\u9519\uff01"));
            this.log.error((Object)ex.getMessage());
            LogServiceProvider.getSysLogHandler().handle(uInfo, OperationType.Update, OperationResult.FAIL, content);
            return false;
        }
    }

    public boolean deleteOrgan(String nodeId, String pNodeId, HttpSession session) {
        UserInfo uInfo = (UserInfo)session.getAttribute("USER_INFO");
        String content = "\u5220\u9664\u673a\u6784ID\uff1a" + nodeId;
        List list = SecurityServiceProvider.getOrganInfoDao().getChildsOrganByPOrganId(Long.valueOf(Long.parseLong(nodeId.substring(6))));
        for (OrganInfoDto cOrgan : list) {
            this.deleteOrgan(TreeNodeName.nameOrganId((long)cOrgan.getOrganId()), TreeNodeName.nameOrganId((long)cOrgan.getPOrganId()), session);
        }
        try {
            SecurityServiceProvider.getOrganInfoDao().delete(Long.valueOf(Long.parseLong(nodeId.substring(6))));
            Node pNode = TreeServiceProvider.getNodeStorage().getNode(pNodeId);
            Node node = TreeServiceProvider.getNodeStorage().getNode(nodeId);
            pNode.removeChildNode(node);
            LogServiceProvider.getSysLogHandler().handle(uInfo, OperationType.Remove, OperationResult.SUCC, content);
            this.log.info((Object)(uInfo.getName() + "\u5220\u9664\u673a\u6784ID:" + nodeId + "\u6210\u529f\uff01"));
            return true;
        }
        catch (Exception ex) {
            LogServiceProvider.getSysLogHandler().handle(uInfo, OperationType.Remove, OperationResult.FAIL, content);
            this.log.info((Object)(uInfo.getName() + "\u5220\u9664\u673a\u6784ID:" + nodeId + "\u51fa\u9519\uff01"));
            this.log.info((Object)ex.getMessage());
            return false;
        }
    }

    private OrganInfo createOrganInfo(Long organId, Long tmlId, String organName, String principal, String phone, String fax, String email, Long pOrganId, Long levelId, Long delFlag, String remark) {
        OrganInfo info = new OrganInfo();
        info.setTmlId(tmlId);
        info.setPrincipal(principal);
        info.setPhone(phone);
        info.setFax(fax);
        info.setEmail(email);
        info.setName(organName);
        info.setPOrganId(pOrganId);
        info.setOrganId(organId);
        info.setLevelId(levelId);
        info.setDelFlag(delFlag);
        info.setRemark(remark);
        return info;
    }

    public boolean findByOrganName(String organName) {
        try {
            List list = SecurityServiceProvider.getOrganInfoDao().findByOrganName(organName);
            if (list.size() == 0) {
                return true;
            }
        }
        catch (Exception e) {
            this.log.error((Object)"\u67e5\u627e\u673a\u6784\u65f6,\u51fa\u9519\uff01");
            this.log.error((Object)e.getMessage());
        }
        return false;
    }

    public String findOrganInfoById(Long organId, HttpSession session) {
        UserInfo uInfo = (UserInfo)session.getAttribute("USER_INFO");
        String content = "\u7528\u6237\uff1a" + uInfo.getName() + ",\u67e5\u627e\u673a\u6784ID\uff1a" + organId;
        String str = "";
        try {
            List list = SecurityServiceProvider.getOrganInfoDao().findOrganInfoById(organId);
            str = list == null || list.size() == 0 ? "" : JSONObject.fromObject(list.get(0)).toString();
            this.log.info((Object)(content + ",\u6210\u529f\uff01"));
        }
        catch (Exception e) {
            this.log.error((Object)(content + ",\u51fa\u9519\uff01"));
            this.log.error((Object)e.getMessage());
        }
        return str;
    }

    public List<String> filterOrganByName(String filterName) {
        List organIdList = null;
        try {
            organIdList = SecurityServiceProvider.getOrganInfoDao().getAllFilterOrgan(filterName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return organIdList;
    }
}

