/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.web.security.dwr;

import cn.com.starit.inas.biz.security.SecurityServiceProvider;
import cn.com.starit.inas.persistence.dto.security.OrderMenuDto;
import cn.com.starit.inas.persistence.po.security.CustomizeMyWorkshop;
import cn.com.starit.inas.persistence.po.security.CustomizeMyWorkshopId;
import cn.com.starit.inas.persistence.po.security.OrderMenu;
import cn.com.starit.inas.persistence.po.security.OrderMenuId;
import cn.com.starit.inas.persistence.po.security.UserInfo;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrderMenuManager {
    private Log log = LogFactory.getLog(OrderMenuManager.class);

    public boolean saves(List<OrderMenuDto> omList, HttpSession session) {
        UserInfo userInfo = (UserInfo)session.getAttribute("USER_INFO");
        String userId = userInfo.getUserId();
        try {
            ArrayList<CustomizeMyWorkshop> cmsList = new ArrayList<CustomizeMyWorkshop>();
            for (OrderMenuDto dto : omList) {
                CustomizeMyWorkshop cms = new CustomizeMyWorkshop();
                CustomizeMyWorkshopId cmsId = new CustomizeMyWorkshopId();
                cmsId.setUserId(userId);
                cmsId.setMenuId(dto.getMenuId().toString());
                cms.setIsHome(dto.getIsHome().toString());
                cms.setId(cmsId);
                cmsList.add(cms);
            }
            SecurityServiceProvider.getOderMenuDao().moveAndSave(userId, cmsList);
            this.log.info((Object)(userId + " \u5b9a\u5236\u4e2a\u6027\u83dc\u5355\u6210\u529f~~~"));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String[] saves2(OrderMenuDto dto, Long oldMenuId, HttpSession session) {
        String[] returnValue = new String[2];
        UserInfo userInfo = (UserInfo)session.getAttribute("USER_INFO");
        String userId = userInfo.getUserId();
        try {
            OrderMenu m = new OrderMenu();
            OrderMenuId mId = new OrderMenuId();
            mId.setMenuId(dto.getMenuId());
            mId.setUserId(userId);
            m.setId(mId);
            m.setPosition(dto.getPosition());
            Integer newPosition = SecurityServiceProvider.getOderMenuDao().removeAndSave(m, userId, dto.getMenuId(), dto.getPosition(), oldMenuId);
            if (newPosition != null) {
                returnValue[0] = newPosition.toString();
            }
            returnValue[1] = "true";
            this.log.info((Object)(userId + " \u5b9a\u5236\u4e2a\u6027\u83dc\u5355\u6210\u529f~~~"));
        }
        catch (Exception e) {
            e.printStackTrace();
            returnValue[1] = "false";
        }
        return returnValue;
    }

    public List<OrderMenuDto> queryUserOrderMenu(HttpSession session) {
        UserInfo userInfo = (UserInfo)session.getAttribute("USER_INFO");
        String userId = userInfo.getUserId();
        List list = SecurityServiceProvider.getOderMenuDao().getUserOrderMenu(userId);
        return list;
    }

    public boolean deselectMenu(Integer position, Long oldMenuId, HttpSession session) {
        UserInfo userInfo = (UserInfo)session.getAttribute("USER_INFO");
        String userId = userInfo.getUserId();
        boolean returnValue = true;
        try {
            OrderMenu menu = new OrderMenu();
            OrderMenuId id = new OrderMenuId();
            id.setMenuId(oldMenuId);
            id.setUserId(userId);
            menu.setId(id);
            menu.setPosition(position);
            SecurityServiceProvider.getOderMenuDao().deselectMenu(menu);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            returnValue = false;
        }
        return returnValue;
    }
}

