/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.web.security.dwr;

import cn.com.starit.inas.biz.menu.MenuServiceProvider;
import cn.com.starit.inas.biz.security.SecurityServiceProvider;
import cn.com.starit.inas.persistence.po.security.MenuFuncInfo;
import cn.com.starit.inas.persistence.po.security.MenuInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MenuFuncInfoManager {
    private Log log = LogFactory.getLog(MenuFuncInfoManager.class);

    public boolean save(Long menuId, Long funcId, String funcName) {
        try {
            MenuFuncInfo mFuncInfo = new MenuFuncInfo();
            mFuncInfo.setMenuId(menuId);
            mFuncInfo.setFuncName(funcName);
            mFuncInfo.setFuncId(funcId);
            SecurityServiceProvider.getMenuInfoDao().saveMenuFuncInfo(mFuncInfo);
            MenuServiceProvider.getMenuTreeManager().addMenuFunction(mFuncInfo);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean update(Long menuId, Long funcId, String funcName) {
        try {
            MenuFuncInfo mFuncInfo = new MenuFuncInfo();
            mFuncInfo.setMenuId(menuId);
            mFuncInfo.setFuncName(funcName);
            mFuncInfo.setFuncId(funcId);
            SecurityServiceProvider.getMenuInfoDao().updateMenuFuncInfo(funcId, funcName);
            MenuServiceProvider.getMenuTreeManager().updateMenuFunction(mFuncInfo);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean deleteMenuFuncInfo(Long funcId) {
        try {
            SecurityServiceProvider.getMenuInfoDao().deleteMenuFuncInfo(funcId);
            MenuServiceProvider.getMenuTreeManager().removeMenuFunction(funcId);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean addSubMenuInfo(String pId, String name, String pageurl, Long isHead, Long isDisplay) {
        try {
            MenuInfo mInfo = new MenuInfo();
            Long pMenuId = null;
            pMenuId = pId.equals("menu_root") ? null : Long.valueOf(pId.substring(5));
            mInfo.setPId(pMenuId);
            mInfo.setPageurl("".equals(pageurl) ? null : pageurl);
            mInfo.setName(name);
            mInfo.setIsdisplay(isDisplay);
            mInfo.setIsHead(isHead);
            Long menuId = SecurityServiceProvider.getMenuInfoDao().addSubMenuInfo(mInfo);
            MenuServiceProvider.getMenuTreeManager().addMenu(mInfo);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean updateMenuInfo(String pId, String menuId, String name, String url, Long isDisplay, Long isHead) {
        try {
            MenuInfo mInfo = new MenuInfo();
            Long pIdx = null;
            pIdx = pId.equals("menu_root") ? null : Long.valueOf(pId.substring(5));
            mInfo.setPId(pIdx);
            mInfo.setMenuId(Long.valueOf(menuId.substring(5)));
            mInfo.setName(name);
            mInfo.setPageurl("".equals(url) ? null : url);
            mInfo.setIsdisplay(isDisplay);
            mInfo.setIsHead(isHead);
            SecurityServiceProvider.getMenuInfoDao().updateMenuInfo(mInfo);
            MenuServiceProvider.getMenuTreeManager().updateMenu(mInfo);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean deleteMenuInfo(String nodeId, String pNodeId) {
        try {
            SecurityServiceProvider.getMenuInfoDao().deleteMenuInfo(Long.valueOf(nodeId.substring(5)));
            MenuServiceProvider.getMenuTreeManager().removeMenu(Long.valueOf(nodeId.substring(5)));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getMenuInfoByMenuId(Long menuId) {
        String s = "";
        try {
            MenuInfo mInfo = SecurityServiceProvider.getMenuInfoDao().getMenuByMenuId(menuId);
            s = "{\"isDisplay\":" + mInfo.getIsdisplay() + ",\"pageUrl\":\"" + mInfo.getPageurl() + "\"}";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    public boolean findMenuFuncInfoByFuncId(Long funcId) {
        try {
            MenuFuncInfo mFuncInfo = SecurityServiceProvider.getMenuInfoDao().findMenuFuncInfoByFuncId(funcId);
            if (mFuncInfo == null) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

