/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.web.maintenance.dwr;

import cn.com.starit.inas.biz.log.LogServiceProvider;
import cn.com.starit.inas.biz.log.SysLogManager.util.Content;
import cn.com.starit.inas.biz.log.SysLogManager.util.OperationResult;
import cn.com.starit.inas.biz.log.SysLogManager.util.OperationType;
import cn.com.starit.inas.biz.notice.NoticeServiceProvider;
import cn.com.starit.inas.persistence.po.security.NoticeType;
import cn.com.starit.inas.persistence.po.security.UserInfo;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NoticeTypeManager {
    private Log log = LogFactory.getLog(NoticeTypeManager.class);

    public boolean findNoticeType(String name) {
        List typeList = NoticeServiceProvider.getNoticeTypeDao().findNoticeType(name);
        return typeList.size() > 0;
    }

    public boolean saveNoticeType(String name, HttpSession session) {
        UserInfo uInfo = (UserInfo)session.getAttribute("USER_INFO");
        String cont = Content.getContent((String)"\u65b0\u589e\u516c\u544a\u7c7b\u522b");
        try {
            NoticeType noticeType = new NoticeType();
            noticeType.setName(name);
            NoticeServiceProvider.getNoticeTypeDao().saveNoticeType(noticeType);
            this.log.info((Object)"\u6dfb\u52a0\u516c\u544a\u7c7b\u522b\u6210\u529f");
            LogServiceProvider.getSysLogHandler().handle(uInfo, OperationType.Add, OperationResult.SUCC, cont);
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)"\u6dfb\u52a0\u516c\u544a\u7c7b\u522b\u5931\u8d25");
            this.log.error((Object)e.getMessage());
            LogServiceProvider.getSysLogHandler().handle(uInfo, OperationType.Add, OperationResult.FAIL, cont);
            return false;
        }
    }

    public boolean deleteNoticeType(String typeId, HttpSession session) {
        UserInfo uInfo = (UserInfo)session.getAttribute("USER_INFO");
        String cont = Content.getContent((String)"\u5220\u9664\u516c\u544a\u7c7b\u522b");
        try {
            NoticeServiceProvider.getNoticeTypeDao().deleteNoticeType(Long.valueOf(Long.parseLong(typeId)));
            NoticeServiceProvider.getNoticeInfoDao().deleteNoticeInfo(Long.valueOf(Long.parseLong(typeId)));
            this.log.info((Object)"\u5220\u9664\u516c\u544a\u7c7b\u522b\u6210\u529f");
            LogServiceProvider.getSysLogHandler().handle(uInfo, OperationType.Remove, OperationResult.SUCC, cont);
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)"\u5220\u9664\u516c\u544a\u7c7b\u522b\u5931\u8d25");
            this.log.error((Object)e.getMessage());
            LogServiceProvider.getSysLogHandler().handle(uInfo, OperationType.Remove, OperationResult.FAIL, cont);
            return false;
        }
    }

    public boolean updateNoticeType(String typeId, String name, HttpSession session) {
        UserInfo uInfo = (UserInfo)session.getAttribute("USER_INFO");
        String cont = Content.getContent((String)"\u4fee\u6539\u516c\u544a\u7c7b\u522b");
        try {
            NoticeType noticeType = NoticeServiceProvider.getNoticeTypeDao().findNoticeTypeById(Long.valueOf(Long.parseLong(typeId)));
            noticeType.setName(name);
            NoticeServiceProvider.getNoticeTypeDao().updateNoticeType(noticeType);
            this.log.info((Object)"\u4fee\u6539\u516c\u544a\u7c7b\u522b\u6210\u529f");
            LogServiceProvider.getSysLogHandler().handle(uInfo, OperationType.Update, OperationResult.SUCC, cont);
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)"\u4fee\u6539\u516c\u544a\u7c7b\u522b\u5931\u8d25");
            this.log.error((Object)e.getMessage());
            LogServiceProvider.getSysLogHandler().handle(uInfo, OperationType.Update, OperationResult.FAIL, cont);
            return false;
        }
    }
}

