/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.web.maintenance.dwr;

import cn.com.starit.inas.biz.log.LogServiceProvider;
import cn.com.starit.inas.biz.log.SysLogManager.util.Content;
import cn.com.starit.inas.biz.log.SysLogManager.util.OperationResult;
import cn.com.starit.inas.biz.log.SysLogManager.util.OperationType;
import cn.com.starit.inas.biz.notice.NoticeServiceProvider;
import cn.com.starit.inas.persistence.dto.notice.NoticeInfoDto;
import cn.com.starit.inas.persistence.po.security.NoticeInfo;
import cn.com.starit.inas.persistence.po.security.UserInfo;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NoticeInfoManager {
    private Log log = LogFactory.getLog(NoticeInfoManager.class);
    private String jsonStr;

    public String getJsonStr() {
        return this.jsonStr;
    }

    public String setJsonStr(String jsonStr) {
        this.jsonStr = jsonStr;
        return this.jsonStr;
    }

    public boolean saveNoticeInfo(String typeId, String title, String content, HttpSession session) {
        UserInfo uInfo = (UserInfo)session.getAttribute("USER_INFO");
        String cont = Content.getContent((String)"\u65b0\u589e\u516c\u544a\u4e00\u6761\u4fe1\u606f");
        try {
            NoticeInfo noticeInfo = new NoticeInfo();
            noticeInfo.setTypeId(Long.valueOf(Long.parseLong(typeId)));
            noticeInfo.setTitle(title);
            noticeInfo.setContent(content);
            noticeInfo.setAuthor(uInfo.getUserId());
            noticeInfo.setIssueTime(new Date());
            NoticeServiceProvider.getNoticeInfoDao().saveNoticeInfo(noticeInfo);
            this.log.info((Object)"\u6dfb\u52a0\u516c\u544a\u4fe1\u606f\u6210\u529f");
            LogServiceProvider.getSysLogHandler().handle(uInfo, OperationType.Add, OperationResult.SUCC, cont);
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)"\u6dfb\u52a0\u516c\u544a\u4fe1\u606f\u5931\u8d25");
            this.log.error((Object)e.getMessage());
            LogServiceProvider.getSysLogHandler().handle(uInfo, OperationType.Add, OperationResult.FAIL, cont);
            return false;
        }
    }

    public String findNoticeInfo(String id) throws NumberFormatException, Exception {
        List NoticeInfo2 = NoticeServiceProvider.getNoticeInfoDao().findNoticeInfoById(Long.valueOf(Long.parseLong(id)));
        String temp = "";
        if (NoticeInfo2 != null && NoticeInfo2.size() > 0) {
            NoticeInfoDto NoticeInfotemp = (NoticeInfoDto)NoticeInfo2.get(0);
            temp = JSONObject.fromObject((Object)NoticeInfotemp).toString();
        }
        return temp;
    }

    public boolean deleteNoticeInfoById(String id, HttpSession session) {
        UserInfo uInfo = (UserInfo)session.getAttribute("USER_INFO");
        String cont = Content.getContent((String)"\u5220\u9664\u4e00\u6761\u516c\u544a\u4fe1\u606f");
        try {
            NoticeServiceProvider.getNoticeInfoDao().deleteNoticeInfoById(Long.valueOf(Long.parseLong(id)));
            this.log.info((Object)"\u5220\u9664\u516c\u544a\u4fe1\u606f\u6210\u529f");
            LogServiceProvider.getSysLogHandler().handle(uInfo, OperationType.Remove, OperationResult.SUCC, cont);
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)"\u5220\u9664\u516c\u544a\u4fe1\u606f\u5931\u8d25");
            this.log.error((Object)e.getMessage());
            LogServiceProvider.getSysLogHandler().handle(uInfo, OperationType.Remove, OperationResult.FAIL, cont);
            return false;
        }
    }

    public boolean updateNoticeInfo(Long id, String title, String content, HttpSession session) {
        UserInfo uInfo = (UserInfo)session.getAttribute("USER_INFO");
        String cont = Content.getContent((String)"\u4fee\u6539\u516c\u544a\u6807\u9898\u53ca\u5185\u5bb9");
        try {
            NoticeServiceProvider.getNoticeInfoDao().updateNoticeInfo(id, title, content);
            this.log.info((Object)"\u4fee\u6539\u516c\u544a\u4fe1\u606f\u6210\u529f");
            LogServiceProvider.getSysLogHandler().handle(uInfo, OperationType.Update, OperationResult.SUCC, cont);
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)"\u4fee\u6539\u516c\u544a\u4fe1\u606f\u5931\u8d25");
            this.log.error((Object)e.getMessage());
            LogServiceProvider.getSysLogHandler().handle(uInfo, OperationType.Update, OperationResult.FAIL, cont);
            return false;
        }
    }
}

