/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.web;

import cn.com.starit.inas.biz.log.LogServiceProvider;
import cn.com.starit.inas.biz.log.SysLogManager.util.OperationResult;
import cn.com.starit.inas.biz.log.SysLogManager.util.OperationType;
import cn.com.starit.inas.biz.security.SecurityServiceProvider;
import cn.com.starit.inas.persistence.dto.common.SessionUserDto;
import cn.com.starit.inas.persistence.po.security.OrganInfo;
import cn.com.starit.inas.persistence.po.security.UserInfo;
import cn.com.starit.inas.web.BaseAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.struts2.ServletActionContext;

public class LoginAction
extends BaseAction {
    private static final long serialVersionUID = -3295886442005127399L;
    private String userCode;
    private String password;

    public String getUserCode() {
        return this.userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String execute() {
        UserInfo info = SecurityServiceProvider.getUserInfoDao().getUserInfoByUserId(this.userCode);
        String content = "\u767b\u9646\uff0c\u6b22\u8fce\u8fdb\u5165\u7cfb\u7edf\uff01";
        if (info == null) {
            this.addActionError("\u7528\u6237\u540d\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u8bd5\uff01");
            return "input";
        }
        if (info.getDelFlag() == 1L) {
            this.addActionError("\u7528\u6237\u5df2\u88ab\u5220\u9664,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            return "input";
        }
        if (SecurityServiceProvider.getOrganInfoDao().checkOrganDelete(info.getOrganId())) {
            this.addActionError("\u7528\u6237\u6240\u5728\u673a\u6784\u5df2\u88ab\u5220\u9664,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            return "input";
        }
        if (info.getLimitTime() != null && info.getLimitTime().before(new Date())) {
            this.addActionError("\u8be5\u7528\u6237\u5df2\u8fc7\u4f7f\u7528\u671f\u9650, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            return "input";
        }
        if (!this.check(info)) {
            this.addActionError("\u5bc6\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u8bd5\uff01");
            return "input";
        }
        this.addInfoToSession("USER_INFO", (Object)info);
        SecurityServiceProvider.getOnlineUserManager().register(info, ServletActionContext.getRequest().getSession());
        LogServiceProvider.getSysLogHandler().handle(info, OperationType.Other, OperationResult.SUCC, content);
        this.setSession(info);
        return "success";
    }

    public void validate() {
        if (this.userCode == null || this.userCode.trim().length() == 0) {
            this.addActionError("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (this.password == null || this.password.trim().length() == 0) {
            this.addActionError("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private boolean check(UserInfo info) {
        String tempPswd = SecurityServiceProvider.getEncrypter().encrypt(this.password);
        return tempPswd.equals(info.getPassword());
    }

    public void setSession(UserInfo info) {
        List tmlLst;
        List listSubTml;
        List listse;
        List organInfoList = SecurityServiceProvider.getOrganInfoDao().findByUserId(this.userCode);
        OrganInfo orgInfo = null;
        if (!organInfoList.isEmpty()) {
            orgInfo = (OrganInfo)organInfoList.get(0);
        }
        this.addInfoToSession("ORGAN_INFO", orgInfo);
        List listobj = SecurityServiceProvider.getSheetQueryInitDao().getTmlByUser(info.getUserId());
        if (!listobj.isEmpty()) {
            this.addInfoToSession("ROLETML_LIST", (Object)listobj);
        }
        if (!(listse = SecurityServiceProvider.getUserInfoDao().findTmlUser(this.userCode)).isEmpty()) {
            SessionUserDto sessDto = (SessionUserDto)listse.get(0);
            if (sessDto.getTmlId() == 0L) {
                sessDto.setCenteral(true);
            }
            this.addInfoToSession("SESSION_USER", (Object)sessDto);
        }
        if (!(listSubTml = SecurityServiceProvider.getSheetQueryInitDao().getsubTmlByUser(this.userCode)).isEmpty()) {
            this.addInfoToSession("ROLESUBTML_LIST", (Object)listSubTml);
        }
        ArrayList listTml = new ArrayList();
        if (!listobj.isEmpty()) {
            listTml.addAll(listobj);
        }
        if (!listSubTml.isEmpty()) {
            listTml.addAll(listSubTml);
        }
        this.addInfoToSession("TML_LIST", listTml);
        List listBigTml = SecurityServiceProvider.getSheetQueryInitDao().getBigTmlByUser(listTml);
        if (listBigTml != null && !listBigTml.isEmpty()) {
            this.addInfoToSession("BIGTML_LIST", (Object)listBigTml);
        }
        if (orgInfo != null && (tmlLst = SecurityServiceProvider.getSheetQueryInitDao().getUserTmlInfo(orgInfo.getTmlId().longValue())) != null && tmlLst.size() > 0) {
            this.addInfoToSession("USER_TML_INFO", tmlLst.get(0));
        }
    }
}

