/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.persistence.service.impl;

import cn.com.starit.inas.persistence.service.GenericPersistenceService;
import cn.com.starit.inas.persistence.service.PagingOption;
import cn.com.starit.inas.persistence.service.ProcdureProperties;
import cn.com.starit.inas.persistence.service.Properties;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.BasicDynaBean;
import org.apache.commons.beanutils.BasicDynaClass;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.ResultSetDynaClass;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class GenericHibernateServiceImpl
extends HibernateDaoSupport
implements GenericPersistenceService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DynaBean> findByJdbcConnection(String sql) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getSessionFactory().openSession().connection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            List list = this.convertToList(rs);
            return list;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            List<DynaBean> list = null;
            return list;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    public List pagingQueryByQueryOption(String hqlQueryStr, PagingOption pagingOption) {
        if (pagingOption.getRecordCount() == -1) {
            pagingOption.setRecordCount(this.queryCount(hqlQueryStr));
        }
        Query query = this.getSession().createQuery(hqlQueryStr);
        query.setFirstResult(pagingOption.getFirstResult());
        query.setMaxResults(pagingOption.getPerPageRecordCount());
        return query.list();
    }

    public List pagingQueryByQueryOption(String hqlQueryStr, Object[] values, PagingOption pagingOption) {
        if (pagingOption.getRecordCount() == -1) {
            pagingOption.setRecordCount(this.queryCount(hqlQueryStr, values));
        }
        Query query = this.getSession().createQuery(hqlQueryStr);
        for (int i = 0; i < values.length; ++i) {
            query.setParameter(i, values[i]);
        }
        query.setFirstResult(pagingOption.getFirstResult());
        query.setMaxResults(pagingOption.getPerPageRecordCount());
        return query.list();
    }

    private int queryCount(String hqlQueryStr, Object[] values) {
        int i = hqlQueryStr.indexOf("order by");
        if (i > 0) {
            hqlQueryStr = hqlQueryStr.substring(0, i - 1);
        }
        String countSql = "select count(*) " + hqlQueryStr.substring(hqlQueryStr.indexOf("from"));
        return ((Long)this.find(countSql, values).get(0)).intValue();
    }

    private int queryCount(String hqlQueryStr) {
        int i = hqlQueryStr.indexOf("order by");
        if (i > 0) {
            hqlQueryStr = hqlQueryStr.substring(0, i - 1);
        }
        String countSql = "select count(*) " + hqlQueryStr.substring(hqlQueryStr.indexOf("from"));
        return ((Long)this.find(countSql).get(0)).intValue();
    }

    public Object get(Class classType, Serializable pkObject) {
        return this.getHibernateTemplate().get(classType, pkObject);
    }

    public Serializable save(Object entity) {
        return this.getHibernateTemplate().save(entity);
    }

    public void update(Object entity) {
        this.getHibernateTemplate().update(entity);
    }

    public void saveOrUpdate(Object entity) {
        this.getHibernateTemplate().saveOrUpdate(entity);
    }

    public List loadAll(Class entityClass) {
        return this.getHibernateTemplate().loadAll(entityClass);
    }

    public void delete(Object entity) {
        this.getHibernateTemplate().delete(entity);
    }

    public void deleteByProperty(Class classType, Properties props) {
        this.getSession().createQuery("Delete " + this.getConditionStrByProperties(classType, props)).executeUpdate();
    }

    public List find(String hqlQueryStr) {
        return this.getHibernateTemplate().find(hqlQueryStr);
    }

    public List find(String hqlQueryStr, Object[] values) {
        return this.getHibernateTemplate().find(hqlQueryStr, values);
    }

    public List find(String hqlQueryStr, Object value) {
        return this.getHibernateTemplate().find(hqlQueryStr, value);
    }

    public int bulkUpdateOrDelete(String queryString) {
        return this.getHibernateTemplate().bulkUpdate(queryString);
    }

    public int bulkUpdateOrDelete(String queryString, Object[] values) {
        return this.getHibernateTemplate().bulkUpdate(queryString, values);
    }

    public int bulkUpdateOrDelete(String queryString, Object value) {
        return this.getHibernateTemplate().bulkUpdate(queryString, value);
    }

    public List findByCriteria(DetachedCriteria criteria) {
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    public List findByProperty(Class classType, Properties props) {
        DetachedCriteria criteria = this.getCriteriaByProperties(classType, props);
        return this.findByCriteria(criteria);
    }

    public Object findOneByProperty(Class classType, Properties props) {
        List list = this.findByProperty(classType, props);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    private DetachedCriteria getCriteriaByProperties(Class classType, Properties props) {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)classType);
        Iterator iter = props.getKeySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            criteria.add((Criterion)Restrictions.eq((String)key, (Object)props.getProperty(key)));
        }
        return criteria;
    }

    private String getConditionStrByProperties(Class classType, Properties props) {
        StringBuilder conditionStrBuilder = new StringBuilder("from " + classType.getName() + " where ");
        Iterator iter = props.getKeySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            conditionStrBuilder.append(key);
            conditionStrBuilder.append(" = ");
            Object value = props.getProperty(key);
            conditionStrBuilder.append(value.toString());
            if (!iter.hasNext()) continue;
            conditionStrBuilder.append(" and ");
        }
        return conditionStrBuilder.toString();
    }

    public List pagingFindByProperty(String hqlQueryStr, PagingOption pagingOption) {
        Query query = this.getSession().createQuery(hqlQueryStr);
        return this.pagingQueryByQueryOpt(query, pagingOption);
    }

    public List pagingFindByProperty(String hqlQueryStr, Properties props, PagingOption pagingOption) {
        Query query = this.getSession().createQuery(hqlQueryStr);
        for (String key : props.getKeySet()) {
            query.setParameter(key, props.getProperty(key));
        }
        return this.pagingQueryByQueryOpt(query, pagingOption);
    }

    public List pagingFindByProperty(String hqlQueryStr, Object[] values, PagingOption pagingOption) {
        Query query = this.getSession().createQuery(hqlQueryStr);
        for (int i = 0; i < values.length; ++i) {
            query.setParameter(i, values[i]);
        }
        return this.pagingQueryByQueryOpt(query, pagingOption);
    }

    private List pagingQueryByQueryOpt(Query query, PagingOption pagingOption) {
        if (pagingOption.getRecordCount() == -1) {
            pagingOption.setRecordCount(query.list().size());
        }
        query.setFirstResult(pagingOption.getFirstResult());
        query.setMaxResults(pagingOption.getPerPageRecordCount());
        return query.list();
    }

    public List pagingFindBySQL(String sqlQueryString, Object[] values, PagingOption pagingOption) {
        SQLQuery query = this.getSession().createSQLQuery(sqlQueryString);
        for (int i = 0; i < values.length; ++i) {
            query.setParameter(i, values[i]);
        }
        return this.pagingQueryByQueryOpt((Query)query, pagingOption);
    }

    public List pagingFindBySQL(String hqlQueryStr, Properties props, PagingOption pagingOption) {
        Query query = this.getSession().createQuery(hqlQueryStr);
        for (String key : props.getKeySet()) {
            query.setParameter(key, props.getProperty(key));
        }
        return this.pagingQueryByQueryOpt(query, pagingOption);
    }

    public List pagingFindBySQL(String sqlQueryString, PagingOption pagingOption) {
        SQLQuery query = this.getSession().createSQLQuery(sqlQueryString);
        return this.pagingQueryByQueryOpt((Query)query, pagingOption);
    }

    public List findBySQL(String sqlQueryString) {
        return this.getSession().createSQLQuery(sqlQueryString).list();
    }

    public List findBySQL(String sqlQueryString, Object[] values) {
        SQLQuery query = this.getSession().createSQLQuery(sqlQueryString);
        for (int i = 0; i < values.length; ++i) {
            query.setParameter(i, values[i]);
        }
        return query.list();
    }

    public void insertSQL(String sqlQueryString) {
        SQLQuery query = this.getSession().createSQLQuery(sqlQueryString);
        query.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DynaBean> runProcedure(String procName, ProcdureProperties[] values) throws Exception {
        Statement cs = null;
        ResultSet rs = null;
        Connection conn = this.getSessionFactory().openSession().connection();
        try {
            conn.setAutoCommit(true);
            cs = conn.prepareCall(this.getProcFullName(procName, values.length));
            int index = 1;
            for (ProcdureProperties prop : values) {
                cs.setObject(index, prop.getValue(), prop.getTargetSqlType());
                ++index;
            }
            rs = cs.executeQuery();
            conn.setAutoCommit(false);
            List list = this.convertToList(rs);
            return list;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            List<DynaBean> list = null;
            return list;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (cs != null) {
                cs.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    private String getProcFullName(String procName, int paraCount) {
        StringBuffer sb = new StringBuffer("{call ");
        sb.append(procName);
        sb.append("(");
        for (int i = 0; i < paraCount; ++i) {
            sb.append('?');
            if (i == paraCount - 1) continue;
            sb.append(',');
        }
        sb.append(")}");
        return sb.toString();
    }

    private List<DynaBean> convertToList(ResultSet rs) throws Exception {
        ArrayList<DynaBean> results = new ArrayList<DynaBean>();
        try {
            ResultSetDynaClass rsdc = new ResultSetDynaClass(rs);
            BasicDynaClass bdc = new BasicDynaClass("DynaBeanTemplate", BasicDynaBean.class, rsdc.getDynaProperties());
            for (DynaBean oldRow : rsdc) {
                DynaBean newRow = bdc.newInstance();
                try {
                    PropertyUtils.copyProperties((Object)newRow, (Object)oldRow);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                results.add(newRow);
            }
            return results;
        }
        catch (Exception e) {
            return null;
        }
    }
}

