/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.persistence.dao.systemMng;

import cn.com.starit.inas.persistence.dao.BaseDao;
import cn.com.starit.inas.persistence.dto.systemMng.BndictTDictionaryDto;
import cn.com.starit.inas.persistence.po.security.BndictTBusintype;
import cn.com.starit.inas.persistence.po.security.BndictTDictionary;
import cn.com.starit.inas.persistence.po.security.BndictTDictionaryId;
import cn.com.starit.inas.persistence.service.GenericPersistenceService;
import cn.com.starit.inas.persistence.service.PagingOption;
import cn.com.starit.tsaip.register.dto.StaticDataDto;
import java.util.List;

public class BusinessDictionaryDao
extends BaseDao {
    public BusinessDictionaryDao(GenericPersistenceService service) {
        super(service);
    }

    protected BusinessDictionaryDao() {
    }

    public List initBndictBusintype(PagingOption pagingOption) {
        String sql = "select b.busintypeid,b.busintypename from BNDICT_T_BUSINTYPE b";
        return this.service.pagingFindBySQL(sql, pagingOption);
    }

    public long getBndictBusintypeCount() {
        String sql = "select count(*) from BNDICT_T_BUSINTYPE";
        List tempLst = this.service.findBySQL(sql);
        return Long.parseLong(tempLst.get(0).toString());
    }

    public void saveOrUpdateBndictBusintype(List<BndictTBusintype> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.service.saveOrUpdate((Object)list.get(i));
        }
    }

    public boolean isExistBndictBusintype(String busintypeid) {
        String sql = "select b.busintypeid,b.busintypename from BNDICT_T_BUSINTYPE b where b.busintypeid = ?";
        Object[] obj = new Object[]{busintypeid};
        List list = this.service.findBySQL(sql, obj);
        return list != null && list.size() > 0;
    }

    public void deleteBndictBusintype(BndictTBusintype bndictTBusintype) {
        this.service.delete((Object)bndictTBusintype);
    }

    public List initBndictDictionary(String busintypeid) {
        String sql = "select b.BUSINTYPEID,b.BUSINID,b.BUSINNAME,b.PRIVILEGE,b.STATUS from BNDICT_T_BUSINTYPE a,BNDICT_T_DICTIONARY b where a.BUSINTYPEID = b.BUSINTYPEID and a.BUSINTYPEID = ?";
        Object[] obj = new Object[]{busintypeid};
        return this.service.findBySQL(sql, obj);
    }

    public void saveOrUpdateBndictTDictionary(List<BndictTDictionaryDto> list) {
        for (int i = 0; i < list.size(); ++i) {
            BndictTDictionary bndictTDictionary = new BndictTDictionary();
            BndictTDictionaryId bndictTDictionaryId = new BndictTDictionaryId();
            bndictTDictionaryId.setBusintypeid(list.get(i).getBusintypeid());
            bndictTDictionaryId.setBusinid(list.get(i).getBusinid());
            bndictTDictionary.setId(bndictTDictionaryId);
            bndictTDictionary.setBusinname(list.get(i).getBusinname());
            if (list.get(i).getPrivilege() != null && !"".equals(list.get(i).getPrivilege())) {
                bndictTDictionary.setPrivilege(Long.valueOf(Long.parseLong(list.get(i).getPrivilege())));
            }
            bndictTDictionary.setStatus(list.get(i).getStatus());
            this.service.saveOrUpdate((Object)bndictTDictionary);
        }
    }

    public boolean isExistBndictDictionary(String busintypeid, String businid) {
        String sql = "select b.businid,b.businname from bndict_t_dictionary b where b.busintypeid = ? and b.businid = ?";
        Object[] obj = new Object[]{busintypeid, businid};
        List list = this.service.findBySQL(sql, obj);
        return list != null && list.size() > 0;
    }

    public void deleteBndictDictionary(BndictTDictionaryDto bndictTDictionaryDto) {
        BndictTDictionary bndictTDictionary = new BndictTDictionary();
        BndictTDictionaryId bndictTDictionaryId = new BndictTDictionaryId();
        bndictTDictionaryId.setBusintypeid(bndictTDictionaryDto.getBusintypeid());
        bndictTDictionaryId.setBusinid(bndictTDictionaryDto.getBusinid());
        bndictTDictionary.setId(bndictTDictionaryId);
        bndictTDictionary.setBusinname(bndictTDictionaryDto.getBusinname());
        if (bndictTDictionaryDto.getPrivilege() != null && "".equals(bndictTDictionaryDto.getPrivilege())) {
            bndictTDictionary.setPrivilege(Long.valueOf(Long.parseLong(bndictTDictionaryDto.getPrivilege())));
        }
        bndictTDictionary.setStatus(bndictTDictionaryDto.getStatus());
        this.service.delete((Object)bndictTDictionary);
    }

    public String getBusiName(String busintypeid, String businid) {
        String sql = "select b.businname from bndict_t_dictionary b where b.busintypeid = ? and b.businid = ?";
        Object[] obj = new Object[]{busintypeid, businid};
        List list = this.service.findBySQL(sql, obj);
        if (list != null && list.size() > 0) {
            return (String)list.get(0);
        }
        return "None Proxy Url Defined in bndict_t_dictionary, Please Check!";
    }

    public List<StaticDataDto> queryDicInfo(String busintypeid) {
        String hql = "SELECT new cn.com.starit.tsaip.register.dto.StaticDataDto(dic.id.busintypeid,dic.id.businid,dic.businname) From BndictTDictionary dic WHERE ";
        String param = "";
        if (busintypeid != null) {
            String[] s;
            for (String str : s = busintypeid.split(",")) {
                if (!"".equals(param)) {
                    param = param + " or ";
                }
                param = param + " dic.id.busintypeid ='" + str + "'";
            }
        }
        return this.service.find(hql + param);
    }
}

