/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.persistence.dao.security;

import cn.com.starit.inas.persistence.dao.BaseDao;
import cn.com.starit.inas.persistence.dto.common.SessionUserDto;
import cn.com.starit.inas.persistence.dto.security.MyWorkShopDto;
import cn.com.starit.inas.persistence.dto.security.UserInfoDto;
import cn.com.starit.inas.persistence.po.security.OrganInfo;
import cn.com.starit.inas.persistence.po.security.RoleMenuFuncInfo;
import cn.com.starit.inas.persistence.po.security.RoleMenuInfo;
import cn.com.starit.inas.persistence.po.security.UserInfo;
import cn.com.starit.inas.persistence.po.security.UserRoleInfo;
import cn.com.starit.inas.persistence.po.security.UserRoleInfoId;
import cn.com.starit.inas.persistence.service.GenericPersistenceService;
import cn.com.starit.inas.persistence.service.PagingOption;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Properties;

public class UserInfoDao
extends BaseDao {
    public UserInfoDao(GenericPersistenceService service) {
        super(service);
    }

    public List<UserInfoDto> queryPagingUserInfo(String organId, String userID, String userName, String tmlId, PagingOption pagingOption) {
        String hqlStr = " SELECT new cn.com.starit.inas.persistence.dto.security.UserInfoDto(uInfo.userId, uInfo.name, uInfo.phone, uInfo.modile, uInfo.sex, oInfo.organId, oInfo.name, uInfo.email, uInfo.delFlag,uInfo.limitTime, uInfo.limitTimeType, uInfo.remark ) FROM UserInfo uInfo , OrganInfo oInfo  WHERE uInfo.organId = oInfo.organId  AND oInfo.delFlag = 0";
        hqlStr = hqlStr + ("-1".equals(organId) || "root".equals(organId) ? " " : " AND uInfo.organId = " + Long.parseLong(organId));
        hqlStr = hqlStr + (userID == null || "".equals(userID) ? " " : " AND uInfo.userId like '%" + userID + "%'");
        hqlStr = hqlStr + (userName == null || "".equals(userName) ? " " : " AND uInfo.name like '%" + userName + "%'");
        hqlStr = hqlStr + ("0".equals(tmlId) || tmlId == null || "".equals(tmlId) ? " " : " AND oInfo.tmlId ='" + tmlId + "'");
        return this.service.pagingFindByProperty(hqlStr, pagingOption);
    }

    public List<UserInfoDto> getUserByOrganId(long organId) {
        String hqlStr = "SELECT new cn.com.starit.inas.persistence.dto.security.UserInfoDto( uInfo.userId, uInfo.name, uInfo.phone, uInfo.modile, uInfo.sex, oInfo.organId,  oInfo.name, uInfo.email, uInfo.delFlag, uInfo.limitTime, uInfo.limitTimeType, uInfo.remark) FROM UserInfo uInfo , OrganInfo oInfo  WHERE uInfo.organId = oInfo.organId AND oInfo.organId = " + organId + " AND oInfo.delFlag = 0";
        return this.service.find(hqlStr);
    }

    public List<UserInfoDto> getUser() {
        String hqlStr = "SELECT new cn.com.starit.inas.persistence.dto.security.UserInfoDto( uInfo.userId, uInfo.name, uInfo.phone, uInfo.modile, uInfo.sex, oInfo.organId,  oInfo.name, uInfo.email, uInfo.delFlag, uInfo.limitTime, uInfo.limitTimeType, uInfo.remark) FROM UserInfo uInfo , OrganInfo oInfo  WHERE uInfo.organId = oInfo.organId AND oInfo.delFlag = 0";
        return this.service.find(hqlStr);
    }

    public Serializable save(UserInfo info) {
        return (String)((Object)this.service.save((Object)info));
    }

    public void update(UserInfo info) {
        this.service.update((Object)info);
    }

    public void updateLimitTime(String infoUserId) {
        String strHql = "update UserInfo userInfo  set userInfo.limitTime = add_months(userInfo.limitTime, 3) where userInfo.userId = '" + infoUserId + "' and userInfo.limitTimeType = 1";
        this.service.bulkUpdateOrDelete(strHql);
    }

    public void updateSelf(String userCode, String userName, Long sex, String phone, String modile, String email) {
        Object[] values = new Object[]{userName, sex, phone, modile, email, userCode};
        this.service.bulkUpdateOrDelete("UPDATE UserInfo info set info.name = ? , info.sex = ? , info.phone = ?, info.modile = ? , info.email = ? WHERE info.userId = ? ", values);
    }

    public void delete(String userId, Long delFlag) {
        Object[] values = new Object[]{delFlag, userId};
        this.service.bulkUpdateOrDelete("update UserInfo uInfo set uInfo.delFlag = ? where uInfo.userId = ?", values);
    }

    public UserInfo getUserInfoByUserId(String userId) {
        return (UserInfo)this.service.get(UserInfo.class, (Serializable)((Object)userId));
    }

    public void saveUserRoleInfo(String userId, long roleId) {
        UserRoleInfo info = this.createUseRoleInfo(userId, roleId);
        this.service.saveOrUpdate((Object)info);
    }

    public void delUserRoleInfo(String userId, long roleId) {
        UserRoleInfo info = this.createUseRoleInfo(userId, roleId);
        this.service.delete((Object)info);
    }

    public List<UserRoleInfo> findUserRoleInfo(String userId) {
        return this.service.find("from UserRoleInfo where id.userId = ?", (Object)userId);
    }

    public List<SessionUserDto> findTmlUser(String userId) {
        return this.service.find(" select new cn.com.starit.inas.persistence.dto.common.SessionUserDto(a.userId,b.organId,c.tmlId) from  UserInfo a,OrganInfo b,Tml c where a.organId=b.organId and b.tmlId=c.tmlId and a.userId = ?", (Object)userId);
    }

    public List<SessionUserDto> getOnlineUserInfo(String userId) {
        String hql = "select new cn.com.starit.inas.persistence.dto.common.SessionUserDto(a.userId,a.name,b.organId,b.name,c.tmlId,c.tmlName) from  UserInfo a,OrganInfo b,Tml c where a.organId=b.organId and b.tmlId=c.tmlId and a.userId in(" + userId + ")";
        return this.service.find(hql);
    }

    public List<RoleMenuInfo> findRoleMenuByUserId(String userId) {
        String hqlStr = "SELECT rMenuInfo FROM UserRoleInfo uRInfo, RoleMenuInfo rMenuInfo WHERE uRInfo.id.userId = ? AND uRInfo.id.roleId = rMenuInfo.id.roleId";
        return this.service.find(hqlStr, (Object)userId);
    }

    public List<RoleMenuFuncInfo> findRoleMenuFuncInfo(String userId) {
        String hqlStr = "SELECT rMenuFuncInfo FROM UserRoleInfo uRInfo, RoleMenuFuncInfo rMenuFuncInfo WHERE uRInfo.id.userId = ? AND uRInfo.id.roleId = rMenuFuncInfo.id.roleId";
        return this.service.find(hqlStr, (Object)userId);
    }

    private UserRoleInfo createUseRoleInfo(String userId, long roleId) {
        UserRoleInfo info = new UserRoleInfo();
        UserRoleInfoId infoId = new UserRoleInfoId();
        infoId.setUserId(userId);
        infoId.setRoleId(Long.valueOf(roleId));
        info.setId(infoId);
        return info;
    }

    public List<OrganInfo> findByUserID(String userId) {
        Properties props = new Properties();
        props.setProperty("userId", userId);
        return this.service.find("from UserInfo info where info.userId = ?", (Object)userId);
    }

    public List<MyWorkShopDto> findMyWorkShop(String userId) {
        Properties props = new Properties();
        props.setProperty("userId", userId);
        String sql = "select new cn.com.starit.inas.persistence.dto.security.MyWorkShopDto(a.id.menuId,b.name,b.pageurl,a.isHome) from CustomizeMyWorkshop a,MenuInfo b  where a.id.userId=? and a.id.menuId=b.menuId  ";
        if (this.service.find(sql, (Object)userId).size() <= 0) {
            this.service.insertSQL("insert into  customize_my_workshop values('2011','" + userId + "','0')");
            this.service.insertSQL("insert into  customize_my_workshop values('1101','" + userId + "','1')");
        }
        return this.service.find(sql, (Object)userId);
    }

    public List queryEwsTask() {
        String sql = "select dev_id,count(task_id) from Ews_task where task_status in (0,1) group by dev_id";
        return this.service.findBySQL(sql);
    }

    public List queryDevInfo(String devId) {
        String sql = "select dev_name,queue_length from dev_info where dev_id=?";
        return this.service.findBySQL(sql, new Object[]{devId});
    }

    public BigDecimal queryAllUserCount() {
        String sql = "select count(*) from user_info info where info.del_Flag!= 1";
        return (BigDecimal)this.service.findBySQL(sql).get(0);
    }

    public void AddBasicPara(String userCode) {
        String sql = "insert into user_show_ews_field select a.user_id,b.ews_para_id,b.ews_para_id-900000000 from user_info a ,ews_para_define b where b.para_type ='-1' and b.ews_para_id!='900000001' and a.user_id = '" + userCode + "'";
        this.service.insertSQL(sql);
    }
}

