/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.persistence.dao.security;

import cn.com.starit.inas.persistence.dao.BaseDao;
import cn.com.starit.inas.persistence.dto.security.UserInfoDto;
import cn.com.starit.inas.persistence.po.security.RoleInfo;
import cn.com.starit.inas.persistence.po.security.RoleMenuFuncInfo;
import cn.com.starit.inas.persistence.po.security.RoleMenuInfo;
import cn.com.starit.inas.persistence.service.GenericPersistenceService;
import cn.com.starit.inas.persistence.service.PagingOption;
import cn.com.starit.inas.persistence.service.Properties;
import java.util.List;

public class RoleInfoDao
extends BaseDao {
    public RoleInfoDao(GenericPersistenceService service) {
        super(service);
    }

    public List<RoleInfo> getAllRoleInfo() {
        return this.service.loadAll(RoleInfo.class);
    }

    public Long save(RoleInfo info) {
        return (Long)this.service.save((Object)info);
    }

    public void update(RoleInfo info) {
        this.service.update((Object)info);
    }

    public void bulkUpdateOrDelete(Long roleId, String roleName, String remark) {
        String strHql = "update RoleInfo set name=?, remark = ? where roleId=?";
        Object[] values = new Object[]{roleName, remark, roleId};
        this.service.bulkUpdateOrDelete(strHql, values);
    }

    public void delete(Long roleId) {
        this.service.bulkUpdateOrDelete("delete from RoleInfo where roleId = ?", (Object)roleId);
    }

    public void deleteAllMenuFuncInfoByRoleId(Long roleId) {
        this.service.bulkUpdateOrDelete("delete from RoleMenuFuncInfo where id.roleId = ?", (Object)roleId);
    }

    public void deleteAllMenuInfoByRoleId(Long roleId) {
        this.service.bulkUpdateOrDelete("delete from RoleMenuInfo where id.roleId = ?", (Object)roleId);
    }

    public void deleteAllPowerByRoleId(Long roleId) {
        this.service.bulkUpdateOrDelete("delete from RolePowerInfo where id.roleId = ?", (Object)roleId);
    }

    public void saveRoleMenuFuncInfo(RoleMenuFuncInfo rMenuFuncInfo) {
        this.service.saveOrUpdate((Object)rMenuFuncInfo);
    }

    public void saveRoleMenuInfo(RoleMenuInfo rMenuInfo) {
        this.service.saveOrUpdate((Object)rMenuInfo);
    }

    public List<RoleMenuInfo> findRoleMenuInfoByRoleId(Long roleId) {
        String hqlQueryStr = "from RoleMenuInfo rmFunction where rmFunction.id.roleId = ?";
        return this.service.find(hqlQueryStr, (Object)roleId);
    }

    public List<RoleMenuFuncInfo> findMenuFuncInfoByRoleId(Long roleId) {
        String hqlQueryStr = "from RoleMenuFuncInfo rmFunction where rmFunction.id.roleId = ?";
        return this.service.find(hqlQueryStr, (Object)roleId);
    }

    public void deleteRoleMenuFunction(RoleMenuFuncInfo roleFunction) {
        this.service.delete((Object)roleFunction);
    }

    public void deleteRoleMenuInfo(RoleMenuInfo roleMenuInfo) {
        this.service.delete((Object)roleMenuInfo);
    }

    public List<RoleInfo> findByRoleName(String roleName) {
        Properties props = new Properties();
        props.setProperty("name", (Object)roleName);
        return this.service.find("from RoleInfo info where info.name = ?", (Object)roleName);
    }

    public List<RoleInfo> findByOrganId(String organId) {
        String strHql = "from RoleInfo info where organId in(" + organId + ")";
        return this.service.find(strHql);
    }

    public List<UserInfoDto> findUserInfoByRoleId(Long roleId, String userID, String userName, String tmlId, PagingOption pagingOption) {
        String hqlStr = " SELECT new cn.com.starit.inas.persistence.dto.security.UserInfoDto(uInfo.userId, uInfo.name, uInfo.phone, uInfo.modile, uInfo.sex, oInfo.organId, oInfo.name, uInfo.email, uInfo.delFlag,uInfo.limitTime, uInfo.limitTimeType, uInfo.remark ) FROM UserInfo uInfo, OrganInfo oInfo, UserRoleInfo uRoleInfo  WHERE uInfo.userId = uRoleInfo.id.userId  AND uInfo.organId = oInfo.organId  AND uRoleInfo.id.roleId = " + roleId;
        hqlStr = hqlStr + " AND oInfo.delFlag = 0";
        hqlStr = hqlStr + (userID == null || "".equals(userID) ? " " : " AND uInfo.userId like '%" + userID + "%'");
        hqlStr = hqlStr + (userName == null || "".equals(userName) ? " " : " AND uInfo.name like '%" + userName + "%'");
        hqlStr = hqlStr + (tmlId == null || "".equals(tmlId) ? " " : " AND oInfo.tmlId ='" + tmlId + "'");
        return this.service.pagingFindByProperty(hqlStr, pagingOption);
    }
}

