/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.persistence.dao.notice;

import cn.com.starit.inas.persistence.dao.BaseDao;
import cn.com.starit.inas.persistence.dto.notice.NoticeInfoDto;
import cn.com.starit.inas.persistence.dto.notice.NoticeTitleDto;
import cn.com.starit.inas.persistence.po.security.NoticeInfo;
import cn.com.starit.inas.persistence.service.GenericPersistenceService;
import cn.com.starit.inas.persistence.service.PagingOption;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class NoticeInfoDao
extends BaseDao {
    public NoticeInfoDao(GenericPersistenceService service) {
        super(service);
    }

    public Serializable saveNoticeInfo(NoticeInfo noticeInfo) {
        return this.service.save((Object)noticeInfo);
    }

    public List<NoticeInfoDto> getNoticeTopTen() {
        PagingOption pagingOption = new PagingOption();
        pagingOption.setFirstResult(0);
        pagingOption.setRecordCount(-1);
        pagingOption.setPerPageRecordCount(10);
        String hqlStr = "SELECT new cn.com.starit.inas.persistence.dto.notice.NoticeInfoDto(nInfo.id, nInfo.title, nInfo.content, uInfo.name,nInfo.author, nInfo.issueTime, nType.name) FROM UserInfo uInfo, NoticeInfo nInfo, NoticeType nType  WHERE nInfo.typeId = nType.typeId AND uInfo.userId = nInfo.author ORDER BY nInfo.issueTime desc";
        return this.service.pagingFindByProperty(hqlStr, pagingOption);
    }

    public List<NoticeTitleDto> getNoticeTopTen2(Long tmlId) {
        PagingOption pagingOption = new PagingOption();
        pagingOption.setFirstResult(0);
        pagingOption.setRecordCount(-1);
        pagingOption.setPerPageRecordCount(10);
        String hql = "SELECT  new cn.com.starit.inas.persistence.dto.notice.NoticeTitleDto(nInfo.id,nInfo.title) FROM UserInfo uInfo,OrganInfo oInfo,Tml t,NoticeInfo nInfo, NoticeType nType  WHERE nInfo.typeId = nType.typeId  AND uInfo.organId=oInfo.organId AND oInfo.tmlId=t.tmlId AND uInfo.userId = nInfo.author";
        hql = tmlId != 0L ? hql + " AND (t.tmlId in(0," + tmlId + ") or t.upTmlId=" + tmlId + ")" + " ORDER BY nInfo.issueTime desc" : hql + " AND t.tmlId=0 ORDER BY nInfo.issueTime desc";
        return this.service.pagingFindByProperty(hql, pagingOption);
    }

    public List<NoticeTitleDto> getAllNoticeTitle(Long tmlId) {
        String hql = "SELECT  new cn.com.starit.inas.persistence.dto.notice.NoticeTitleDto(nInfo.id,nInfo.title) FROM UserInfo uInfo,OrganInfo oInfo,Tml t,NoticeInfo nInfo, NoticeType nType  WHERE nInfo.typeId = nType.typeId  AND uInfo.organId=oInfo.organId AND oInfo.tmlId=t.tmlId AND uInfo.userId = nInfo.author";
        hql = tmlId != 0L ? hql + " AND (t.tmlId in(0," + tmlId + ") or t.upTmlId=" + tmlId + ")" + " ORDER BY nInfo.issueTime desc" : hql + " AND t.tmlId=0 ORDER BY nInfo.issueTime desc";
        return this.service.find(hql);
    }

    public List<NoticeInfoDto> getAllNoticeInfo(Long tmlId, PagingOption pagingOption) {
        String hqlStr = "select new cn.com.starit.inas.persistence.dto.notice.NoticeInfoDto  (nInfo.id, nInfo.title, nInfo.content,uInfo.name, nInfo.author, nInfo.issueTime, nType.name)  FROM UserInfo uInfo,OrganInfo oInfo,Tml t,NoticeInfo nInfo, NoticeType nType  WHERE nInfo.typeId = nType.typeId  AND uInfo.organId=oInfo.organId AND oInfo.tmlId=t.tmlId AND uInfo.userId = nInfo.author";
        hqlStr = tmlId != 0L ? hqlStr + " AND (t.tmlId in(0," + tmlId + ") or t.upTmlId=" + tmlId + ")" + " ORDER BY nInfo.issueTime desc" : hqlStr + " AND t.tmlId=0 ORDER BY nInfo.issueTime desc";
        return this.service.pagingFindByProperty(hqlStr, pagingOption);
    }

    public List<NoticeInfoDto> getNoticeInfoByTypeId(Long typeId, Long tmlId, PagingOption pagingOption) {
        Object[] values = new Object[]{typeId};
        String hqlStr = "SELECT new cn.com.starit.inas.persistence.dto.notice.NoticeInfoDto( nInfo.id, nInfo.title, nInfo.content, uInfo.name, nInfo.author, nInfo.issueTime, nType.name)  FROM UserInfo uInfo,OrganInfo oInfo,Tml t, NoticeInfo nInfo, NoticeType nType  WHERE nInfo.typeId = nType.typeId AND uInfo.organId=oInfo.organId AND oInfo.tmlId=t.tmlId AND uInfo.userId = nInfo.author AND nInfo.typeId = ?";
        hqlStr = tmlId != 0L ? hqlStr + " AND (t.tmlId in(0," + tmlId + ") or t.upTmlId=" + tmlId + ")" + " order by nInfo.issueTime desc" : hqlStr + " AND t.tmlId=0  order by nInfo.issueTime desc";
        return this.service.pagingFindByProperty(hqlStr, values, pagingOption);
    }

    public List<NoticeInfoDto> findNoticeInfoById(Long id) throws Exception {
        String hql = "select new cn.com.starit.inas.persistence.dto.notice.NoticeInfoDto(n.id,n.title,n.content,u.name,n.author,n.issueTime,'') from NoticeInfo n,UserInfo u where n.author=u.userId and n.id=" + id;
        List list = this.service.find(hql);
        return list;
    }

    public void deleteNoticeInfo(Long typeId) {
        this.service.bulkUpdateOrDelete("delete from NoticeInfo nInfo where nInfo.typeId = ?", (Object)typeId);
    }

    public void deleteNoticeInfoById(Long id) {
        this.service.bulkUpdateOrDelete("delete from NoticeInfo nInfo where nInfo.id = ?", (Object)id);
    }

    public void updateNoticeInfo(Long id, String title, String content) {
        Object[] values = new Object[]{title, content, new Date(), id};
        this.service.bulkUpdateOrDelete("update NoticeInfo nInfo set nInfo.title = ? , nInfo.content= ? , nInfo.issueTime = ? where nInfo.id = ?", values);
    }
}

