/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.persistence.dao.log;

import cn.com.starit.common.util.StringUtil;
import cn.com.starit.inas.biz.log.LogServiceProvider;
import cn.com.starit.inas.biz.log.SysLogManager.impl.SysLogManageCentre;
import cn.com.starit.inas.persistence.dao.BaseDao;
import cn.com.starit.inas.persistence.dto.log.LogInfoDto;
import cn.com.starit.inas.persistence.po.security.Loginfo;
import cn.com.starit.inas.persistence.service.GenericPersistenceService;
import cn.com.starit.inas.persistence.service.PagingOption;
import cn.com.starit.inas.persistence.service.ProcdureProperties;
import cn.com.starit.tsaip.register.util.ConfigControl;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class SysLogInfoDao
extends BaseDao {
    private JdbcTemplate jdbcTemplate;
    private static Log log = LogFactory.getLog(SysLogManageCentre.class);
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public SysLogInfoDao(GenericPersistenceService service) {
        super(service);
    }

    public Serializable save(Loginfo logInfo) {
        return this.service.save((Object)logInfo);
    }

    private boolean isOracle() {
        Object obj = ConfigControl.getStConfigCache().getConfigValue((Object)"DB_TYPE");
        if (obj == null) {
            return true;
        }
        String dbType = (String)obj;
        return dbType.toUpperCase().equals("ORACLE");
    }

    private String getDateFromStconfig(String key) {
        return ConfigControl.getStConfigCache().getConfigValue((Object)key) == null ? "" : (String)ConfigControl.getStConfigCache().getConfigValue((Object)key);
    }

    public List<LogInfoDto> getLogInfoBySpeicalItems(List<String> userIds, Integer operationType, Date beginTime, Date endTime, Integer checkFlag, PagingOption pagingOption) {
        if (checkFlag != 1 && checkFlag != 0) {
            log.error((Object)"\u65e5\u5fd7\u5e93\u8868\u9009\u62e9\u51fa\u9519,\u67e5\u8be2\u4efb\u52a1\u5373\u5c06\u9000\u51fa...");
            return null;
        }
        String querySql = "";
        String prefix = " from %s loginfo0_, USER_INFO userinfo1_ where loginfo0_.USER_ID=userinfo1_.USER_ID and (loginfo0_.USER_ID in (%s))  and loginfo0_.LOG_DATE>=%s and loginfo0_.LOG_DATE<=%s ";
        String sql = "select %s loginfo0_.LOG_ID as col_0_0_, loginfo0_.USER_ID as col_1_0_, loginfo0_.OPEATION_STATUS as col_2_0_, loginfo0_.LOG_CONTENT as col_3_0_, loginfo0_.LOG_DATE as col_4_0_, loginfo0_.OPERATION_TYPE as col_5_0_, userinfo1_.NAME as col_6_0_ ";
        String countSql = "select count(loginfo0_.LOG_ID) ";
        if (operationType != -1) {
            prefix = prefix + " and loginfo0_.operation_type= %s ";
            prefix = String.format(prefix, checkFlag == 1 ? "loginfo" : "hisloginfo", this.getUserIds(userIds), "to_date('" + this.sdf.format(beginTime) + "','" + this.getDateFromStconfig("SYS_DATA_YMD_HMS") + "')", "to_date('" + this.sdf.format(endTime) + "','" + this.getDateFromStconfig("SYS_DATA_YMD_HMS") + "')", operationType.longValue());
        } else {
            prefix = String.format(prefix, checkFlag == 1 ? "loginfo" : "hisloginfo", this.getUserIds(userIds), "to_date('" + this.sdf.format(beginTime) + "','" + this.getDateFromStconfig("SYS_DATA_YMD_HMS") + "')", "to_date('" + this.sdf.format(endTime) + "','" + this.getDateFromStconfig("SYS_DATA_YMD_HMS") + "')");
        }
        String orderSql = " order by loginfo0_.LOG_ID desc ";
        if (this.isOracle()) {
            sql = String.format(sql, " /*+ FIRST_ROWS*/ ");
            querySql = "select *  from (select row_.*, rownum rownum_ from (" + sql + prefix + orderSql + ")  row_  where rownum <= " + (pagingOption.getPerPageRecordCount() + pagingOption.getFirstResult()) + ") where rownum_ > " + pagingOption.getFirstResult();
        } else {
            sql = String.format(sql, "skip " + pagingOption.getFirstResult() + " first " + pagingOption.getPerPageRecordCount());
            querySql = sql + prefix + orderSql;
        }
        List list = this.jdbcTemplate.queryForList(querySql);
        ArrayList<LogInfoDto> res = new ArrayList<LogInfoDto>();
        for (int i = 0; i < list.size(); ++i) {
            Map obj = (Map)list.get(i);
            LogInfoDto dto = new LogInfoDto();
            dto.setLogContent(StringUtil.getStringFrom(obj.get("col_3_0_")));
            try {
                dto.setLogDate(this.sdf.format(StringUtil.getDateFrom(obj.get("col_4_0_"))));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            dto.setLogId(StringUtil.getLongFrom(obj.get("col_0_0_")));
            dto.setOpeationStatus(StringUtil.getLongFrom(obj.get("col_2_0_")));
            dto.setOperationType(StringUtil.getLongFrom(obj.get("col_5_0_")));
            dto.setUserCode(StringUtil.getStringFrom(obj.get("col_1_0_")));
            dto.setUserName(StringUtil.getStringFrom(obj.get("col_6_0_")));
            res.add(dto);
        }
        Long total = this.jdbcTemplate.queryForLong(countSql + prefix);
        pagingOption.setRecordCount(total.intValue());
        return res;
    }

    private String getUserIds(List<String> userIds) {
        String tempStr = "";
        int i = 0;
        for (String userId : userIds) {
            tempStr = tempStr + "'" + userId + "'";
            if (++i >= userIds.size()) continue;
            tempStr = tempStr + ",";
        }
        return tempStr;
    }

    public void DeleteLogsByDate(Date beforeDate) {
        this.service.bulkUpdateOrDelete("delete from Loginfo where logDate < ?", (Object)beforeDate);
    }

    public void testRunProc() {
        ProcdureProperties[] s = new ProcdureProperties[4];
        ProcdureProperties pp1 = new ProcdureProperties((Object)4, 4);
        ProcdureProperties pp2 = new ProcdureProperties((Object)"89630,", 12);
        ProcdureProperties pp3 = new ProcdureProperties((Object)"2009/6/6 0:0:0", 12);
        ProcdureProperties pp4 = new ProcdureProperties((Object)"2009/6/6 23:59:59", 12);
        s[0] = pp1;
        s[1] = pp2;
        s[2] = pp3;
        s[3] = pp4;
        System.out.println("----------------start---");
        try {
            List list = this.service.runProcedure("traffic_db..wirelessPerfRept", s);
            System.out.println("count: " + list.size());
            for (int i = 0; i < list.size(); ++i) {
                DynaBean bdb = (DynaBean)list.get(i);
                System.out.print(bdb.get("meastime"));
                System.out.print("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("----------------end---");
    }

    public static void main(String[] args) {
        SysLogInfoDao dao = LogServiceProvider.getSysLogInfoDao();
        dao.testRunProc();
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

