/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.biz.tree.node.impl;

import cn.com.starit.inas.biz.tree.node.INodeStorage;
import cn.com.starit.inas.biz.tree.node.Node;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class NodeStorageImpl
implements INodeStorage {
    private Map<String, Node> storeMap = new Hashtable();

    public void addNode(Node node) {
        this.storeMap.put(node.getNodeId(), node);
    }

    public Node getNode(String nodeId) {
        return (Node)this.storeMap.get(nodeId);
    }

    public void removeNode(Node node) {
        this.removeRecordInParentNode(node);
        if (!node.isLeaf()) {
            this.removeRecordInChildNode(node);
        }
        this.storeMap.remove(node.getNodeId());
    }

    public void deleteNode(Node node) {
        if (node.isLeaf()) {
            this.storeMap.remove(node.getNodeId());
        } else {
            List list = node.getChildNodes();
            for (Node cNode : list) {
                this.deleteNode(cNode);
                this.storeMap.remove(cNode.getNodeId());
            }
            this.storeMap.remove(node.getNodeId());
        }
    }

    private void removeRecordInParentNode(Node node) {
        List pList = node.getParentNodes();
        for (Node tNode : pList) {
            tNode.removeChildNode(node);
        }
    }

    private void removeRecordInChildNode(Node node) {
        List cList = node.getChildNodes();
        for (Node tNode : cList) {
            tNode.removeParentNode(node);
        }
    }

    public void refreshNode(Node node) {
        this.storeMap.remove(node.getNodeId());
        this.addNode(node);
    }
}

