/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.biz.tree.node.impl;

import cn.com.starit.inas.biz.tree.node.INodeFactory;
import cn.com.starit.inas.biz.tree.node.INodeStorage;
import cn.com.starit.inas.biz.tree.node.Node;
import cn.com.starit.inas.biz.tree.node.impl.GeneralCompositeNode;
import cn.com.starit.inas.biz.tree.node.impl.GeneralLeafNode;
import cn.com.starit.inas.biz.tree.node.impl.MenuCompositeNode;
import cn.com.starit.inas.biz.tree.node.impl.MenuFunctionNode;
import cn.com.starit.inas.biz.tree.node.impl.OrganCompositeNode;
import cn.com.starit.inas.biz.tree.util.TreeNodeName;
import cn.com.starit.tsaip.register.biz.tree.node.impl.AtomServCompositeNode;
import cn.com.starit.tsaip.register.biz.tree.node.impl.ServCompositeNode;
import cn.com.starit.tsaip.register.biz.tree.node.impl.ServDirectoryLevelCompositeNode;

public class NodeFactoryImpl
implements INodeFactory {
    private INodeStorage store = null;

    public NodeFactoryImpl(INodeStorage store) {
        this.store = store;
    }

    public Node createMenuNode(Long menuId, String nodeName, String url, Long isHead) {
        Node node = this.checkNodeStorage(TreeNodeName.nameMenuId((long)menuId));
        if (node == null) {
            node = new MenuCompositeNode(menuId, nodeName, url, isHead);
            this.store.addNode(node);
        }
        return node;
    }

    public Node createMenuFunctionNode(Long menuFuncitonId, String nodeName) {
        String nodeId = TreeNodeName.nameMFuncId((long)menuFuncitonId);
        Node node = this.checkNodeStorage(nodeId);
        if (node == null) {
            node = new MenuFunctionNode(nodeId, nodeName, menuFuncitonId);
            this.store.addNode(node);
        }
        return node;
    }

    public Node createGeneralNode(String nodeId, String nodeName, boolean isLeaf) {
        Object node = this.checkNodeStorage(nodeId);
        if (node != null) {
            return node;
        }
        node = !isLeaf ? new GeneralCompositeNode(nodeId, nodeName) : new GeneralLeafNode(nodeId, nodeName);
        this.store.addNode(node);
        return node;
    }

    private Node checkNodeStorage(String nodeId) {
        return this.store.getNode(nodeId);
    }

    public Node createOrganNode(Long organId, String organName, Long level) {
        Node node = this.checkNodeStorage(TreeNodeName.nameOrganId((long)organId));
        if (node != null) {
            return node;
        }
        node = new OrganCompositeNode(organId, organName, level);
        this.store.addNode(node);
        return node;
    }

    public Node createServDirectoryLevelNode(long servDirectoryLevelId, String servDirectoryLevelName, String servDirectoryLevelType) {
        Node node = this.checkNodeStorage(TreeNodeName.nameServDirectoryLevelId((long)servDirectoryLevelId));
        if (node != null) {
            return node;
        }
        node = new ServDirectoryLevelCompositeNode(servDirectoryLevelId, servDirectoryLevelName, servDirectoryLevelType);
        this.store.addNode(node);
        return node;
    }

    public Node createServNode(String servId, String servName, String servManCode) {
        Node node = this.checkNodeStorage(TreeNodeName.nameServId((String)servId));
        if (node != null) {
            return node;
        }
        node = new ServCompositeNode(servId, servName, servManCode);
        this.store.addNode(node);
        return node;
    }

    public Node createAtomServNode(String servAtomId, String atomServName, String servManCode) {
        Node node = this.checkNodeStorage(TreeNodeName.nameAtomServId((String)servAtomId));
        if (node != null) {
            return node;
        }
        node = new AtomServCompositeNode(servAtomId, atomServName, servManCode);
        this.store.addNode(node);
        return node;
    }
}

