/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.biz.tree.builder;

import cn.com.starit.inas.biz.security.SecurityServiceProvider;
import cn.com.starit.inas.biz.tree.ITreeBuilder;
import cn.com.starit.inas.biz.tree.TreeServiceProvider;
import cn.com.starit.inas.biz.tree.node.Node;
import cn.com.starit.inas.biz.tree.util.TreeNodeName;
import cn.com.starit.inas.persistence.dto.security.OrganInfoDto;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class OrganTreeBuilder
implements ITreeBuilder {
    private static Logger log = Logger.getLogger(OrganTreeBuilder.class);
    private Node organRootNode = null;

    public Node buildTree() {
        log.info((Object)"\u673a\u6784\u7ec4\u7ec7\u6811--\u521d\u59cb\u5316--\u5f00\u59cb");
        this.organRootNode = this.createRootNode();
        List list = SecurityServiceProvider.getOrganInfoDao().getAllCompOrganInfo();
        try {
            this.processComOrgan(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"\u673a\u6784\u7ec4\u7ec7\u6811--\u521d\u59cb\u5316--\u51fa\u9519");
            log.error((Object)e.getMessage());
        }
        log.info((Object)"\u673a\u6784\u7ec4\u7ec7\u6811--\u521d\u59cb\u5316--\u7ed3\u675f");
        return this.organRootNode;
    }

    private void processComOrgan(List<OrganInfoDto> list) {
        List unUsedList = this.processCompOrgan(list.iterator());
        int size = unUsedList.size();
        if (size == 0 || list.size() == size) {
            return;
        }
        this.processComOrgan(unUsedList);
    }

    private List<OrganInfoDto> processCompOrgan(Iterator<OrganInfoDto> iter) {
        ArrayList<OrganInfoDto> unUsedList = new ArrayList<OrganInfoDto>();
        while (iter.hasNext()) {
            OrganInfoDto dto = iter.next();
            Node node = null;
            Node pNode = null;
            if (dto.getPOrganId() != null) {
                pNode = TreeServiceProvider.getNodeStorage().getNode(TreeNodeName.nameOrganId((long)dto.getPOrganId()));
            }
            node = this.createOrganNode(dto.getOrganId(), dto.getName(), dto.getLevelId());
            if (dto.getPOrganId() == null) {
                this.organRootNode.addChildNode(node);
                iter.remove();
                continue;
            }
            if (dto.getPOrganId() != null) {
                pNode.addChildNode(node);
                iter.remove();
                continue;
            }
            unUsedList.add(dto);
        }
        return unUsedList;
    }

    private Node createOrganNode(Long organId, String organName, Long level) {
        return TreeServiceProvider.getNodeFactory().createOrganNode(organId, organName, level);
    }

    private Node createRootNode() {
        return TreeServiceProvider.getNodeFactory().createGeneralNode("organ_root", "\u7ec4\u7ec7\u673a\u6784", false);
    }
}

