/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.biz.tree.builder;

import cn.com.starit.inas.biz.menu.IMenuManager;
import cn.com.starit.inas.biz.menu.exception.NotFoundNodeException;
import cn.com.starit.inas.biz.security.SecurityServiceProvider;
import cn.com.starit.inas.biz.tree.ITreeBuilder;
import cn.com.starit.inas.biz.tree.TreeServiceProvider;
import cn.com.starit.inas.biz.tree.node.Node;
import cn.com.starit.inas.persistence.dao.security.MenuInfoDao;
import cn.com.starit.inas.persistence.po.security.MenuFuncInfo;
import cn.com.starit.inas.persistence.po.security.MenuInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MenuBuilder
implements ITreeBuilder {
    private static Log log = LogFactory.getLog(MenuBuilder.class);
    private Node menuRootNode = null;
    private IMenuManager menuTreeManager = null;

    public Node buildTreebyUser(String userid) {
        this.menuRootNode = this.createRootNode();
        List list = SecurityServiceProvider.getMenuInfoDao().getAllCompMenuInfobyUserid(userid);
        this.processComMenuData(list);
        list = SecurityServiceProvider.getMenuInfoDao().getAllMenuInfobyUserid(userid);
        this.processLeafMenuData(list);
        return this.menuRootNode;
    }

    public void setMenuTreeManager(IMenuManager menuTreeManager) {
        this.menuTreeManager = menuTreeManager;
    }

    public Node buildTree() {
        log.info((Object)"\u83dc\u5355\u6811-\u521d\u59cb\u6784\u5efa\u5316-\u6784\u5efa\u5f00\u59cb");
        this.menuRootNode = this.createRootNode();
        MenuInfoDao dao = SecurityServiceProvider.getMenuInfoDao();
        this.processComMenuData(dao.getAllCompMenuInfo());
        this.processLeafMenuData(dao.getAllMenuInfo());
        this.processMenuFunctionData(dao.getMenuFuncInfo());
        log.info((Object)"\u83dc\u5355\u6811-\u521d\u59cb\u6784\u5efa\u5316-\u6784\u5efa\u7ed3\u675f");
        return this.menuRootNode;
    }

    private void processComMenuData(List<MenuInfo> list) {
        List unUsedList = this.processCompMenu(list.iterator());
        int size = unUsedList.size();
        if (size == 0 || list.size() == size) {
            return;
        }
        this.processComMenuData(unUsedList);
    }

    private List<MenuInfo> processCompMenu(Iterator<MenuInfo> iter) {
        ArrayList<MenuInfo> unUsedList = new ArrayList<MenuInfo>();
        while (iter.hasNext()) {
            MenuInfo dto = iter.next();
            try {
                this.menuTreeManager.addMenu(dto);
                iter.remove();
            }
            catch (NotFoundNodeException e) {
                unUsedList.add(dto);
            }
        }
        return unUsedList;
    }

    private void processLeafMenuData(List<MenuInfo> list) {
        for (MenuInfo dto : list) {
            try {
                this.menuTreeManager.addMenu(dto);
            }
            catch (NotFoundNodeException e) {
                log.error((Object)e.getMessage());
            }
        }
    }

    private void processMenuFunctionData(List<MenuFuncInfo> list) {
        for (MenuFuncInfo dto : list) {
            try {
                this.menuTreeManager.addMenuFunction(dto);
            }
            catch (NotFoundNodeException e) {
                log.error((Object)e.getMessage());
            }
        }
    }

    private Node createRootNode() {
        return TreeServiceProvider.getNodeFactory().createGeneralNode("menu_root", "\u83dc\u5355", false);
    }
}

