/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.biz.security.impl;

import cn.com.starit.inas.biz.security.IOnlineUserManager;
import cn.com.starit.inas.biz.security.SecurityServiceProvider;
import cn.com.starit.inas.biz.security.util.PowerWithUserInfo;
import cn.com.starit.inas.persistence.dao.security.UserInfoDao;
import cn.com.starit.inas.persistence.po.security.UserInfo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class OnLineUserManager
implements IOnlineUserManager,
HttpSessionListener {
    private Map<String, PowerWithUserInfo> onLineManager = new HashMap();

    public boolean isOnline(UserInfo user) {
        return this.onLineManager.containsKey(user.getUserId()) && ((PowerWithUserInfo)this.onLineManager.get(user.getUserId())).getHttpSession() != null;
    }

    public void register(UserInfo user, HttpSession session) {
        String userId = user.getUserId();
        if (this.onLineManager.containsKey(userId)) {
            PowerWithUserInfo temp = (PowerWithUserInfo)this.onLineManager.get(userId);
            if (temp.getHttpSession() == null) {
                temp.setHttpSession(session);
            }
        } else {
            PowerWithUserInfo powerInfo = this.createPowerWithUserInfo(userId, session);
            this.onLineManager.put(userId, powerInfo);
        }
        ServletContext application = session.getServletContext();
        application.setAttribute("onLineManager", (Object)this.onLineManager);
    }

    public void unRegister(UserInfo user) {
        if (this.onLineManager.containsKey(user.getUserId())) {
            this.onLineManager.remove(user.getUserId());
        }
    }

    public boolean updatePassword(String userId, String password) {
        UserInfo ui;
        HttpSession sess = ((PowerWithUserInfo)this.onLineManager.get(userId)).getHttpSession();
        if (sess != null && (ui = (UserInfo)sess.getAttribute("USER_INFO")) != null) {
            ui.setPassword(password);
            return true;
        }
        return false;
    }

    public int getOnLineCount() {
        return this.onLineManager.size();
    }

    public Set<String> getOnlineUsers() {
        return this.onLineManager.keySet();
    }

    public PowerWithUserInfo getPowerWithUserInfo(String userId) {
        return (PowerWithUserInfo)this.onLineManager.get(userId);
    }

    private PowerWithUserInfo createPowerWithUserInfo(String userId, HttpSession session) {
        UserInfoDao dao = SecurityServiceProvider.getUserInfoDao();
        PowerWithUserInfo powerInfo = new PowerWithUserInfo();
        powerInfo.setRFunctions(dao.findRoleMenuFuncInfo(userId));
        powerInfo.setRMenus(dao.findRoleMenuByUserId(userId));
        powerInfo.setHttpSession(session);
        return powerInfo;
    }

    public BigDecimal getAllUserCount() {
        return SecurityServiceProvider.getUserInfoDao().queryAllUserCount();
    }

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        ServletContext application = session.getServletContext();
        Map onLineManager = (Map)application.getAttribute("onLineManager");
        UserInfo uInfo = (UserInfo)session.getAttribute("USER_INFO");
        if (uInfo != null) {
            String userId = uInfo.getUserId();
            onLineManager.remove(userId);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            System.out.println("\u7528\u6237\u8d85\u65f6\u9000\u51fa\u65f6\u95f4:" + df.format(new Date()).toString() + "\u7528\u6237\uff1a" + userId + "--------------------------------------\u8d85\u65f6\u9000\u51fa\u3002");
        }
    }
}

