/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.biz.scheduler.ws;

import cn.com.starit.inas.biz.scheduler.ws.IResendService;
import cn.com.starit.inas.biz.scheduler.ws.ResendQeqDto;
import cn.com.starit.tsaip.audit.dto.AipMessageDto;
import cn.com.starit.tsaip.msgresend.biz.IMsgResendService;
import cn.com.starit.tsaip.register.biz.IServVersionService;
import cn.com.starit.tsaip.register.dto.ServResendDto;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResendService
implements IResendService {
    private Logger log = LoggerFactory.getLogger(ResendService.class);
    private IServVersionService servVersionService;
    private IMsgResendService msgResendService;

    public void setServVersionService(IServVersionService servVersionService) {
        this.servVersionService = servVersionService;
    }

    public void setMsgResendService(IMsgResendService msgResendService) {
        this.msgResendService = msgResendService;
    }

    public String resend(String xml) {
        ResendQeqDto resendQeqDto = this.getXpathElement(xml);
        if (resendQeqDto == null) {
            return "\u89e3\u6790\u4f20\u5165\u53c2\u6570\u5931\u8d25\uff0c\u5c06\u4e0d\u8fdb\u884c\u91cd\u6295\u64cd\u4f5c\uff01";
        }
        return this.resendHandler(resendQeqDto);
    }

    private String resendHandler(ResendQeqDto resendQeqDto) {
        String msgInfo = "\u91cd\u6295\u901a\u77e5\u5df2\u6210\u529f\u9001\u8fbe\u5e73\u53f0";
        AipMessageDto amDto = this.servVersionService.getServResend(resendQeqDto.getMsgId(), resendQeqDto.getReceive());
        if (amDto == null) {
            msgInfo = "error\uff1a\u63d0\u4f9b\u7684msgid/" + resendQeqDto.getMsgId() + ",staffName/" + resendQeqDto.getReceive() + " \u6ca1\u6709\u53d1\u73b0\u5bf9\u5e94\u7684\u6301\u4e45\u5316\u4fe1\u606f";
            this.log.error(msgInfo);
            return this.encapReturnInfo(resendQeqDto.getMsgId(), "", Long.valueOf(1L), msgInfo);
        }
        ServResendDto resendDto = this.servVersionService.getServResendById(Long.valueOf(amDto.getId()), true);
        if (resendDto == null) {
            msgInfo = "error\uff1a\u63d0\u4f9b\u7684msgid/" + resendQeqDto.getMsgId() + ",esbId/" + resendQeqDto.getEsbId() + " \u5df2\u6295\u9012\u6210\u529f\uff0c\u65e0\u9700\u518d\u91cd\u6295\uff01";
            this.log.error(msgInfo);
            return this.encapReturnInfo(amDto.getMsgId(), "", Long.valueOf(1L), msgInfo);
        }
        boolean isOk = this.msgResendService.resend4Webservice(resendDto);
        if (isOk) {
            return this.encapReturnInfo(amDto.getMsgId(), amDto.getCsbId(), Long.valueOf(0L), msgInfo);
        }
        msgInfo = "error\uff1a\u63d0\u4f9b\u7684msgid/" + resendQeqDto.getMsgId() + ",esbId/" + resendQeqDto.getEsbId() + " \u91cd\u6295\u5931\u8d25\uff01";
        this.log.error(msgInfo);
        return this.encapReturnInfo(amDto.getMsgId(), "", Long.valueOf(1L), msgInfo);
    }

    private String encapReturnInfo(String msgId, String esbId, Long flag, String detail) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH24:mm:ss");
        return new StringBuffer("<Return>").append("<MsgId>").append(msgId).append("</MsgId>").append("<EsbId>").append(esbId).append("</EsbId>").append("<Time>").append(sdf.format(new Date())).append("</Time>").append("<Flag>").append(flag).append("</Flag>").append("<Detail>").append(detail).append("</Detail>").append("</Return>").toString();
    }

    public ResendQeqDto getXpathElement(String responseStrXML) {
        ResendQeqDto dto = null;
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)responseStrXML);
            dto = new ResendQeqDto();
            Element feedbackEl = (Element)document.selectSingleNode("//ReqRoot/Time");
            dto.setTime(feedbackEl == null || "null".equals(feedbackEl) ? "" : feedbackEl.getText());
            feedbackEl = (Element)document.selectSingleNode("//ReqRoot/MsgId");
            dto.setMsgId(feedbackEl.getText());
            feedbackEl = (Element)document.selectSingleNode("//ReqRoot/StaffName");
            dto.setReceive(feedbackEl.getText());
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return dto;
    }
}

