/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.biz.scheduler.ws;

import cn.com.starit.tsaip.esb.plugin.pkg.facade.PkgStore;
import cn.com.starit.tsaip.register.biz.IServVersionService;
import cn.com.starit.tsaip.register.dto.ServResendDto;
import cn.com.starit.tsaip.register.util.ConfigControl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClietnHandler {
    private Logger log = LoggerFactory.getLogger(HttpClietnHandler.class);
    private IServVersionService servVersionService;

    public HttpClietnHandler(IServVersionService servVersionService) {
        this.servVersionService = servVersionService;
    }

    public boolean resendmsg(ServResendDto dto, String urlStr) {
        if (urlStr == null || "".equals(urlStr)) {
            this.log.error("\u7ec4\u88c5\u8def\u7531\u6d88\u606f\u73af\u8282:servDefine.getServPrivateURL()\u4e3a\u7a7a\uff0c\u65e0\u6548\u7684\u8def\u7531\u5c5e\u6027");
        }
        String soap = PkgStore.getPkg((String)dto.getCsbId(), (String)"Receive");
        soap = this.formatChange(soap);
        int statusCode = 0;
        if (soap != null) {
            try {
                statusCode = this.send(urlStr, soap);
            }
            catch (HttpException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (statusCode == 200) {
            this.servVersionService.upateMsgPersist(dto.getId(), 1);
            return true;
        }
        return false;
    }

    private int send(String url, String soap) throws HttpException, IOException {
        PostMethod postmethod = new PostMethod(url);
        byte[] b = soap.getBytes("UTF-8");
        ByteArrayInputStream is = new ByteArrayInputStream(b, 0, b.length);
        InputStreamRequestEntity re = new InputStreamRequestEntity((InputStream)is, (long)b.length, "application/xop+xml;");
        postmethod.setRequestHeader("SOAPAction", "http://starit.com.cn");
        postmethod.setRequestEntity((RequestEntity)re);
        HttpClient httpClient = new HttpClient();
        httpClient.setTimeout(ConfigControl.getStConfigCache().getConfigValue((Object)"RESEND_TIME_OUT") == null ? 300000 : Integer.parseInt((String)ConfigControl.getStConfigCache().getConfigValue((Object)"RESEND_TIME_OUT")) * 1000);
        try {
            int statusCode = httpClient.executeMethod((HttpMethod)postmethod);
            byte[] responseBody = postmethod.getResponseBody();
            postmethod.releaseConnection();
            String content = new String(responseBody);
            statusCode = content.equals(ConfigControl.getStConfigCache().getConfigValue((Object)"ASYNC_RET_MSG") == null ? "\u6d88\u606f\u5df2\u7ecf\u6210\u529f\u5230\u8fbe\u5e73\u53f0" : ConfigControl.getStConfigCache().getConfigValue((Object)"ASYNC_RET_MSG")) ? 200 : 0;
            return statusCode;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private String formatChange(String msg) {
        if (msg.contains("&lt;") && msg.contains("&gt;")) {
            msg = msg.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
        }
        return msg;
    }
}

