/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.biz.scheduler.task;

import cn.com.starit.common.util.StringUtil;
import cn.com.starit.oip.dcn.persistence.entity.HostNetMonConf;
import cn.com.starit.oip.dcn.persistence.entity.HostNetMonResult;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class WindowPingTask {
    private Runtime r = Runtime.getRuntime();
    private BufferedReader in = null;

    public List<HostNetMonResult> ping(List<HostNetMonConf> list) throws UnknownHostException {
        ArrayList<HostNetMonResult> res = new ArrayList<HostNetMonResult>();
        for (HostNetMonConf hostNetMonConf : list) {
            HostNetMonResult result = new HostNetMonResult();
            result.setHostNetMonConf(hostNetMonConf);
            result.setFromHost(InetAddress.getLocalHost().getHostAddress());
            result.setDestHost(hostNetMonConf.getHostAddress());
            result.setTestStartTime(new Date());
            String pingCommand = "ping " + hostNetMonConf.getHostAddress();
            try {
                Process p = this.r.exec(pingCommand);
                if (p == null) {
                    res.add(result);
                    continue;
                }
                this.in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = null;
                while ((line = this.in.readLine()) != null) {
                    String[] pcks;
                    System.out.println(line);
                    if (line.indexOf("TTL=") > -1) {
                        String ttlStr = line.substring(line.indexOf("TTL=") + 4);
                        result.setTtl(Integer.valueOf(64 - StringUtil.parse2Int((String)ttlStr)));
                    }
                    if (line.indexOf("Packets:") > -1 || line.indexOf("\u6570\u636e\u5305:") > -1) {
                        line = line.replaceFirst("    Packets:", "");
                        line = line.replaceFirst("    \u6570\u636e\u5305:", "");
                        line = line.substring(0, line.lastIndexOf("(") - 1);
                        pcks = line.split("\uff0c");
                        int sent = Integer.parseInt(pcks[0].split("=")[1].trim());
                        result.setPacketTotal(Integer.valueOf(sent));
                        int lost = Integer.parseInt(pcks[2].split("=")[1].trim());
                        result.setPacketLoss(Integer.valueOf(lost));
                        continue;
                    }
                    if (line.indexOf("Minimum:") <= -1 && line.indexOf("\u6700\u77ed") <= -1) continue;
                    pcks = line.split("\uff0c");
                    double min = Double.parseDouble(pcks[0].split("=")[1].replaceAll("ms", "").trim());
                    result.setMinRtt(Double.valueOf(min));
                    double max = Double.parseDouble(pcks[1].split("=")[1].replaceAll("ms", "").trim());
                    result.setMaxRtt(Double.valueOf(max));
                    double avg = Double.parseDouble(pcks[2].split("=")[1].replaceAll("ms", "").trim());
                    result.setAvgRtt(Double.valueOf(avg));
                }
                this.in.close();
                result.setTestEndTime(new Date());
                res.add(result);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                result.setHostNetMonConf(hostNetMonConf);
                res.add(result);
            }
        }
        return res;
    }
}

