/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.biz.scheduler.task;

import cn.com.starit.inas.biz.scheduler.task.LinuxPingTask;
import cn.com.starit.inas.biz.scheduler.task.WindowPingTask;
import cn.com.starit.oip.dcn.biz.IHostNetMonResultService;
import cn.com.starit.oip.dcn.biz.IHostNetmonConfService;
import cn.com.starit.oip.dcn.persistence.entity.HostNetMonConf;
import cn.com.starit.oip.dcn.persistence.entity.HostNetMonResult;
import java.net.UnknownHostException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingTask {
    private Logger log = LoggerFactory.getLogger(PingTask.class);
    private IHostNetMonResultService hostNetMonResultService;
    private IHostNetmonConfService hostNetmonConfService;

    public void ping() throws UnknownHostException {
        List list;
        String osName = System.getProperty("os.name").toLowerCase();
        this.log.info("\u7f51\u7edc\u72b6\u6001\u63a2\u6d4b\u5f00\u59cb \u64cd\u4f5c\u7cfb\u7edf\uff1a" + osName);
        if (osName.indexOf("window") > -1) {
            WindowPingTask wpt = new WindowPingTask();
            list = wpt.ping(this.getDestHost());
        } else {
            LinuxPingTask lpt = new LinuxPingTask();
            list = lpt.ping(this.getDestHost());
        }
        this.saveRes(list);
    }

    private void saveRes(List<HostNetMonResult> list) {
        for (HostNetMonResult dto : list) {
            this.save(dto);
        }
    }

    protected void save(HostNetMonResult hostNetMonResult) {
        this.hostNetMonResultService.save(hostNetMonResult);
    }

    protected List<HostNetMonConf> getDestHost() {
        return this.hostNetmonConfService.getHostNetMonConf();
    }

    public IHostNetMonResultService getHostNetMonResultService() {
        return this.hostNetMonResultService;
    }

    public void setHostNetMonResultService(IHostNetMonResultService hostNetMonResultService) {
        this.hostNetMonResultService = hostNetMonResultService;
    }

    public IHostNetmonConfService getHostNetmonConfService() {
        return this.hostNetmonConfService;
    }

    public void setHostNetmonConfService(IHostNetmonConfService hostNetmonConfService) {
        this.hostNetmonConfService = hostNetmonConfService;
    }
}

