/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.biz.scheduler.task;

import cn.com.starit.common.util.StringUtil;
import cn.com.starit.oip.dcn.persistence.entity.HostNetMonConf;
import cn.com.starit.oip.dcn.persistence.entity.HostNetMonResult;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LinuxPingTask {
    private Runtime r = Runtime.getRuntime();
    private BufferedReader in = null;

    public List ping(List<HostNetMonConf> list) throws UnknownHostException {
        ArrayList<HostNetMonResult> res = new ArrayList<HostNetMonResult>();
        for (HostNetMonConf hostNetMonConf : list) {
            HostNetMonResult result = new HostNetMonResult();
            result.setHostNetMonConf(hostNetMonConf);
            result.setFromHost(InetAddress.getLocalHost().getHostAddress());
            result.setDestHost(hostNetMonConf.getHostAddress());
            result.setTestStartTime(new Date());
            String pingCommand = "ping " + hostNetMonConf.getHostAddress() + " -c 4";
            try {
                Process p = this.r.exec(pingCommand);
                if (p == null) {
                    res.add(result);
                    continue;
                }
                this.in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = null;
                while ((line = this.in.readLine()) != null) {
                    if (line.indexOf("TTL=") > -1) {
                        int beginTTL = line.indexOf("TTL=");
                        String ttlStr = line.substring(beginTTL + 4, line.indexOf(" ", beginTTL));
                        result.setTtl(Integer.valueOf(64 - StringUtil.parse2Int((String)ttlStr)));
                    }
                    if (line.indexOf("transmitted") > -1) {
                        String[] pcks = line.split(",");
                        int sent = Integer.parseInt(StringUtil.getFirstNonEmptyChar((String)pcks[0]));
                        result.setPacketTotal(Integer.valueOf(sent));
                        int recive = Integer.parseInt(StringUtil.getFirstNonEmptyChar((String)pcks[1]));
                        int lost = sent - recive;
                        result.setPacketLoss(Integer.valueOf(lost));
                        continue;
                    }
                    if (line.indexOf("rtt") <= -1) continue;
                    String[] pcks = line.split("=")[1].split("/");
                    double min = Double.parseDouble(StringUtil.getFirstNonEmptyChar((String)pcks[0]));
                    result.setMinRtt(Double.valueOf(min));
                    double max = Double.parseDouble(StringUtil.getFirstNonEmptyChar((String)pcks[2]));
                    result.setMaxRtt(Double.valueOf(max));
                    double avg = Double.parseDouble(StringUtil.getFirstNonEmptyChar((String)pcks[1]));
                    result.setAvgRtt(Double.valueOf(avg));
                }
                this.in.close();
                result.setTestEndTime(new Date());
                res.add(result);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return res;
    }
}

