/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.biz.menu.impl;

import cn.com.starit.inas.biz.menu.IMenuManager;
import cn.com.starit.inas.biz.menu.exception.NotFoundNodeException;
import cn.com.starit.inas.biz.tree.TreeServiceProvider;
import cn.com.starit.inas.biz.tree.node.Node;
import cn.com.starit.inas.biz.tree.node.impl.MenuCompositeNode;
import cn.com.starit.inas.biz.tree.node.impl.MenuFunctionNode;
import cn.com.starit.inas.biz.tree.util.TreeNodeName;
import cn.com.starit.inas.persistence.po.security.MenuFuncInfo;
import cn.com.starit.inas.persistence.po.security.MenuInfo;

public class MenuTreeManager
implements IMenuManager {
    public void addMenu(MenuInfo menuInfo) throws NotFoundNodeException {
        Node pNode;
        String pId = null;
        if (menuInfo.getIsHead() == 1L) {
            pId = "menu_root";
        } else if (menuInfo.getPId() != null) {
            pId = TreeNodeName.nameMenuId((long)menuInfo.getPId());
        }
        if (pId != null) {
            pNode = TreeServiceProvider.getNodeStorage().getNode(pId);
            if (pNode == null) {
                throw new NotFoundNodeException("\u672a\u627e\u5230\u7236\u7ed3\u70b9\uff0c\u7236\u7ed3\u70b9ID\u4e3a" + pId);
            }
        } else {
            throw new NotFoundNodeException("\u672a\u627e\u5230\u7236\u7ed3\u70b9\uff0c\u7236\u7ed3\u70b9ID\u4e3a" + pId);
        }
        Node node = this.createMenuNode(menuInfo);
        pNode.addChildNode(node);
    }

    public void addMenuFunction(MenuFuncInfo funcInfo) throws NotFoundNodeException {
        Node pNode;
        String pId = TreeNodeName.nameMenuId((long)funcInfo.getMenuId());
        if (pId != null) {
            pNode = TreeServiceProvider.getNodeStorage().getNode(pId);
            if (pNode == null) {
                throw new NotFoundNodeException("\u672a\u627e\u5230\u7236\u7ed3\u70b9\uff0c\u7236\u7ed3\u70b9ID\u4e3a" + pId);
            }
        } else {
            throw new NotFoundNodeException("\u672a\u627e\u5230\u7236\u7ed3\u70b9\uff0c\u7236\u7ed3\u70b9ID\u4e3a" + pId);
        }
        Node node = this.createMenuFuncNode(funcInfo);
        pNode.addChildNode(node);
    }

    public void removeMenu(Long menuId) throws NotFoundNodeException {
        String nodeId = TreeNodeName.nameMenuId((long)menuId);
        this.removeNode(nodeId);
    }

    public void removeMenuFunction(Long funcId) throws NotFoundNodeException {
        String nodeId = TreeNodeName.nameMFuncId((long)funcId);
        this.removeNode(nodeId);
    }

    public void updateMenu(MenuInfo menuInfo) throws NotFoundNodeException {
        String nodeId = TreeNodeName.nameMenuId((long)menuInfo.getMenuId());
        Node node = TreeServiceProvider.getNodeStorage().getNode(nodeId);
        if (node == null) {
            throw new NotFoundNodeException("\u672a\u627e\u5230\u7ed3\u70b9\uff0c\u7ed3\u70b9ID\u4e3a" + nodeId);
        }
        MenuCompositeNode menuNode = (MenuCompositeNode)node;
        menuNode.setNodeName(menuInfo.getName());
        menuNode.setUrl(menuInfo.getPageurl());
        menuNode.setIsHead(Boolean.valueOf(menuInfo.getIsHead() == 1L));
    }

    public void updateMenuFunction(MenuFuncInfo funcInfo) throws NotFoundNodeException {
        String nodeId = TreeNodeName.nameMFuncId((long)funcInfo.getFuncId());
        Node node = TreeServiceProvider.getNodeStorage().getNode(nodeId);
        if (node == null) {
            throw new NotFoundNodeException("\u672a\u627e\u5230\u7ed3\u70b9\uff0c\u7ed3\u70b9ID\u4e3a" + nodeId);
        }
        MenuFunctionNode funcNode = (MenuFunctionNode)node;
        funcNode.setNodeName(funcInfo.getFuncName());
    }

    private Node createMenuNode(MenuInfo menuInfo) {
        return TreeServiceProvider.getNodeFactory().createMenuNode(menuInfo.getMenuId(), menuInfo.getName(), menuInfo.getPageurl(), menuInfo.getIsHead());
    }

    private Node createMenuFuncNode(MenuFuncInfo funcInfo) {
        return TreeServiceProvider.getNodeFactory().createMenuFunctionNode(funcInfo.getFuncId(), funcInfo.getFuncName());
    }

    private void removeNode(String nodeId) throws NotFoundNodeException {
        Node node = TreeServiceProvider.getNodeStorage().getNode(nodeId);
        if (node == null) {
            throw new NotFoundNodeException("\u672a\u627e\u5230\u7ed3\u70b9\uff0c\u7ed3\u70b9ID\u4e3a" + nodeId);
        }
        TreeServiceProvider.getNodeStorage().removeNode(node);
    }
}

