/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.inas.biz.log.SysLogManager.impl;

import cn.com.starit.inas.biz.log.LogServiceProvider;
import cn.com.starit.inas.biz.log.SysLogManager.ISysLogHandler;
import cn.com.starit.inas.biz.log.SysLogManager.util.OperationInfo;
import cn.com.starit.inas.biz.log.SysLogManager.util.OperationResult;
import cn.com.starit.inas.biz.log.SysLogManager.util.OperationType;
import cn.com.starit.inas.persistence.dao.log.SysLogInfoDao;
import cn.com.starit.inas.persistence.dto.log.LogInfoDto;
import cn.com.starit.inas.persistence.po.security.Loginfo;
import cn.com.starit.inas.persistence.po.security.UserInfo;
import cn.com.starit.inas.persistence.service.PagingOption;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SysLogManageCentre
implements ISysLogHandler {
    private static Log log = LogFactory.getLog(SysLogManageCentre.class);
    private SysLogInfoDao sysLogInfoDao;

    public void handle(UserInfo userInfo, OperationInfo operInfo, String content) {
        try {
            log.info((Object)"\u65e5\u5fd7\u7ba1\u7406\u4e2d\u5fc3\u6b63\u5728\u4fdd\u5b58\u7528\u6237\u64cd\u4f5c\u65e5\u5fd7\u4fe1\u606f...");
            this.saveLog(userInfo.getUserId(), operInfo, content);
        }
        catch (Exception ex) {
            log.debug((Object)"\u65e5\u5fd7\u7ba1\u7406\u4e2d\u5fc3\u4fdd\u5b58\u4fe1\u606f\u51fa\u9519!");
            ex.printStackTrace();
        }
    }

    public void handle(UserInfo userInfo, OperationType operType, OperationResult operResult, String content) {
        this.handle(userInfo, this.createOperationInfo(operType, operResult), content);
    }

    public void handle(OperationType operType, OperationResult operResult, String content) {
        this.handle(this.createOperationInfo(operType, operResult), content);
    }

    public void handle(OperationInfo operInfo, String content) {
        try {
            log.info((Object)"\u65e5\u5fd7\u7ba1\u7406\u4e2d\u5fc3\u6b63\u5728\u4fdd\u5b58\u7cfb\u7edf\u65e5\u5fd7\u4fe1\u606f...");
            this.saveLog("INAS-System", operInfo, content);
        }
        catch (Exception ex) {
            log.debug((Object)"\u65e5\u5fd7\u7ba1\u7406\u4e2d\u5fc3\u4fdd\u5b58\u4fe1\u606f\u51fa\u9519!");
            ex.printStackTrace();
        }
    }

    public List<LogInfoDto> queryLogs(List<String> userIds, Integer operationType, Date beginTime, Date endTime, Integer checkFlag, PagingOption pagingOption) {
        return LogServiceProvider.getSysLogInfoDao().getLogInfoBySpeicalItems(userIds, operationType, beginTime, endTime, checkFlag, pagingOption);
    }

    public void removeWithDay4Quartz() {
        this.removeWithDay(40);
    }

    public void removeWithDay(int day) {
        log.info((Object)"\u5b9a\u65f6\u65e5\u5fd7\u6e05\u9664\u4efb\u52a1\u5f00\u59cb\u6267\u884c...");
        Date nowDate = new Date();
        long OneDayMilSeconds = 86400000L;
        long milSeconds = (long)day * 86400000L;
        long nowMilSeconds = nowDate.getTime();
        long beforeMilSeconds = nowMilSeconds - milSeconds;
        Date beforeDate = new Date(beforeMilSeconds);
        try {
            this.sysLogInfoDao.DeleteLogsByDate(beforeDate);
            log.info((Object)"\u5b9a\u65f6\u65e5\u5fd7\u6e05\u9664\u6267\u884c\u6210\u529f!");
        }
        catch (Exception ex) {
            log.debug((Object)("\u6e05\u9664" + day + "\u5929\u4ee5\u524d\u7684\u65e5\u5fd7\u5931\u8d25!"));
            ex.printStackTrace();
        }
    }

    private Serializable saveLog(String useId, OperationInfo operInfo, String content) {
        Loginfo logInfo = this.setPara(useId, operInfo, content);
        return LogServiceProvider.getSysLogInfoDao().save(logInfo);
    }

    private OperationInfo createOperationInfo(OperationType operType, OperationResult operResult) {
        return new OperationInfo(operResult, operType);
    }

    private Loginfo setPara(String userCode, OperationInfo operInfo, String content) {
        Integer operationType = operInfo.getOperType().ordinal();
        Integer opeationStatus = operInfo.getResult().ordinal();
        Loginfo tempLogInfo = new Loginfo();
        tempLogInfo.setLogId(null);
        tempLogInfo.setLogContent(content);
        tempLogInfo.setLogDate(new Date());
        tempLogInfo.setOpeationStatus(Long.valueOf(Long.parseLong(opeationStatus.toString())));
        tempLogInfo.setOperationType(Long.valueOf(Long.parseLong(operationType.toString())));
        tempLogInfo.setUserId(userCode);
        return tempLogInfo;
    }

    public SysLogInfoDao getSysLogInfoDao() {
        return this.sysLogInfoDao;
    }

    public void setSysLogInfoDao(SysLogInfoDao sysLogInfoDao) {
        this.sysLogInfoDao = sysLogInfoDao;
    }
}

