/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.common.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class StringDateUtil {
    private static Logger log = Logger.getLogger(StringDateUtil.class);

    public static String delMsel(String time) {
        if (time == null || "".equals(time)) {
            return time;
        }
        int dotPosition = time.indexOf(46);
        if (dotPosition != -1) {
            return time.substring(0, dotPosition);
        }
        return time;
    }

    public static String date2String(Date time) {
        if (time == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(time);
    }

    public static java.sql.Date toDate(String timeString) {
        java.sql.Date date;
        if (timeString == null || "".equals(timeString.trim())) {
            return null;
        }
        int timeLength = timeString.trim().length();
        if (timeLength > 0 && timeLength <= 10) {
            timeString = timeString + " 00:00:00";
        } else if (timeLength <= 16 && timeLength > 10) {
            timeString = timeString + ":00";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = new java.sql.Date(df.parse(timeString).getTime());
        }
        catch (ParseException e) {
            log.error((Object)(e.getMessage() + ",\u8f6c\u6362\u65e5\u671f\u5f02\u5e38\uff1a" + timeString));
            return null;
        }
        return date;
    }

    public static Object toTimestamp(String timeString) {
        Timestamp ts;
        if (timeString == null || "".equals(timeString.trim())) {
            return "";
        }
        int timeLength = (timeString = timeString.trim()).trim().length();
        if (timeLength > 0 && timeLength <= 10) {
            timeString = timeString + " 00:00:00";
        } else if (timeLength <= 16 && timeLength > 10) {
            timeString = timeString + ":00";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            ts = new Timestamp(df.parse(timeString).getTime());
        }
        catch (ParseException e) {
            df = new SimpleDateFormat("yyyyMMddHHmmss");
            try {
                ts = new Timestamp(df.parse(timeString).getTime());
            }
            catch (ParseException e1) {
                log.error((Object)(e.getMessage() + ",\u8f6c\u6362\u65e5\u671f\u5f02\u5e38\uff1a" + timeString));
                return "";
            }
        }
        return ts;
    }

    public static long sub(String time1, String time2) {
        if (time2.length() < 17) {
            time2 = time2 + " 00:00:00";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long mins = 0L;
        try {
            Date gatherDate = sdf.parse(time1);
            Date lastGatherDate = sdf.parse(time2);
            long interval = gatherDate.getTime() - lastGatherDate.getTime();
            long perMin = 60000L;
            mins = interval % perMin == 0L ? interval / perMin : interval / perMin + 1L;
        }
        catch (ParseException e) {
            log.error((Object)(e.getMessage() + ",\u8f6c\u6362\u65e5\u671f\u5f02\u5e38\uff1a" + time1 + "," + time2));
            return 0L;
        }
        return mins;
    }

    public static Date modifyTime(Date time, int calFiled, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        cal.add(calFiled, amount);
        return cal.getTime();
    }

    public static String modifyTime(String time, int calFiled, int amount) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        Date date = null;
        try {
            date = sdf.parse(time);
        }
        catch (ParseException e) {
            log.error((Object)(e.getMessage() + ",\u8f6c\u6362\u65e5\u671f\u5f02\u5e38\uff1a" + time));
            return "";
        }
        cal.setTime(date);
        cal.add(calFiled, amount);
        String result = sdf.format(cal.getTime());
        return result;
    }
}

