/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.common.util;

import cn.com.starit.common.exception.ExceptionHandler;
import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class LoggingAspect {
    @Pointcut(value="execution(* cn.com.starit.tsaip.*.biz..*Service.*(..))")
    public void log() {
    }

    @Around(value="log()&&args(args)&&target(target)&&this(proxy)")
    public Object aroundLogging(ProceedingJoinPoint pjp, Object args, Object target, Object proxy) throws Throwable {
        Logger log = Logger.getLogger(target.getClass());
        String methodName = pjp.getSignature().toShortString();
        log.info((Object)(methodName + " \u65b9\u6cd5\u5f00\u59cb\u6267\u884c,\u53c2\u6570 \uff1a" + args));
        try {
            Object result = pjp.proceed();
            log.info((Object)(methodName + " \u65b9\u6cd5\u6267\u884c\u7ed3\u675f"));
            return result;
        }
        catch (Throwable e) {
            ExceptionHandler.handle((Object)this, (Throwable)e, (String)"\u5f02\u5e38");
            throw e;
        }
    }
}

