/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.common.persistence;

import cn.com.starit.common.persistence.PropertyFilter;
import cn.com.starit.common.util.ReflectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;

public class PropertyFilter {
    public static final String OR_SEPARATOR = "_OR_";
    private String[] propertyNames = null;
    private Class<?> propertyType = null;
    private Object propertyValue = null;
    private MatchType matchType = MatchType.EQ;

    public PropertyFilter() {
    }

    public PropertyFilter(String filterName, Object value) {
        String matchTypeStr = StringUtils.substringBefore((String)filterName, (String)"_");
        String matchTypeCode = StringUtils.substring((String)matchTypeStr, (int)0, (int)(matchTypeStr.length() - 1));
        String propertyTypeCode = StringUtils.substring((String)matchTypeStr, (int)(matchTypeStr.length() - 1), (int)matchTypeStr.length());
        try {
            this.matchType = Enum.valueOf(MatchType.class, matchTypeCode);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("filter\u540d\u79f0" + filterName + "\u6ca1\u6709\u6309\u89c4\u5219\u7f16\u5199,\u65e0\u6cd5\u5f97\u5230\u5c5e\u6027\u6bd4\u8f83\u7c7b\u578b.", e);
        }
        try {
            this.propertyType = Enum.valueOf(PropertyType.class, propertyTypeCode).getValue();
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("filter\u540d\u79f0" + filterName + "\u6ca1\u6709\u6309\u89c4\u5219\u7f16\u5199,\u65e0\u6cd5\u5f97\u5230\u5c5e\u6027\u503c\u7c7b\u578b.", e);
        }
        String propertyNameStr = StringUtils.substringAfter((String)filterName, (String)"_");
        this.propertyNames = StringUtils.split((String)propertyNameStr, (String)OR_SEPARATOR);
        Assert.isTrue((this.propertyNames.length > 0 ? 1 : 0) != 0, (String)("filter\u540d\u79f0" + filterName + "\u6ca1\u6709\u6309\u89c4\u5219\u7f16\u5199,\u65e0\u6cd5\u5f97\u5230\u5c5e\u6027\u540d\u79f0."));
        this.propertyValue = ReflectionUtils.convertValue((Object)value, (Class)this.propertyType);
    }

    public boolean isMultiProperty() {
        return this.propertyNames.length > 1;
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public String getPropertyName() {
        if (this.propertyNames.length > 1) {
            throw new IllegalArgumentException("There are not only one property");
        }
        return this.propertyNames[0];
    }

    public Object getPropertyValue() {
        return this.propertyValue;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }
}

