/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.common.persistence;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.json.annotations.JSON;

public class Page<T> {
    private int start;
    public static final String ASC = "asc";
    public static final String DESC = "desc";
    protected int pageNo = 1;
    protected int pageSize = 10;
    protected String orderBy = null;
    protected String order = null;
    protected boolean autoCount = true;
    protected List<T> result = Collections.emptyList();
    protected long totalCount = -1L;

    public Page() {
    }

    public Page(int pageSize) {
        this.setPageSize(pageSize);
    }

    public Page(int pageSize, boolean autoCount) {
        this.setPageSize(pageSize);
        this.setAutoCount(autoCount);
    }

    @JSON(serialize=false)
    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
        if (pageNo < 0) {
            this.pageNo = 0;
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        if (pageSize < 1) {
            this.pageSize = 1;
        }
    }

    @JSON(serialize=false)
    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    @JSON(serialize=false)
    public boolean isOrderBySetted() {
        return StringUtils.isNotBlank((String)this.orderBy) && StringUtils.isNotBlank((String)this.order);
    }

    @JSON(serialize=false)
    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        String[] orders;
        for (String orderStr : orders = StringUtils.split((String)StringUtils.lowerCase((String)order), (char)',')) {
            if (StringUtils.equals((String)DESC, (String)orderStr) || StringUtils.equals((String)ASC, (String)orderStr)) continue;
            throw new IllegalArgumentException("\u6392\u5e8f\u65b9\u5411" + orderStr + "\u4e0d\u662f\u5408\u6cd5\u503c");
        }
        this.order = StringUtils.lowerCase((String)order);
    }

    public boolean isAutoCount() {
        return this.autoCount;
    }

    public void setAutoCount(boolean autoCount) {
        this.autoCount = autoCount;
    }

    public List<T> getResult() {
        return this.result;
    }

    public void setResult(List<T> result) {
        this.result = result;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public long getTotalPages() {
        if (this.totalCount < 0L) {
            return -1L;
        }
        long count = this.totalCount / (long)this.pageSize;
        if (this.totalCount % (long)this.pageSize > 0L) {
            ++count;
        }
        return count;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }
}

