/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.common.persistence;

import cn.com.starit.common.exception.ExceptionHandler;
import cn.com.starit.common.persistence.Page;
import cn.com.starit.common.persistence.PropertyFilter;
import cn.com.starit.common.util.ReflectionUtils;
import cn.com.starit.common.util.StringUtil;
import cn.com.starit.inas.persistence.service.PagingOption;
import cn.com.starit.inas.persistence.service.ProcdureProperties;
import cn.com.starit.inas.persistence.service.Properties;
import cn.com.starit.tsaip.register.util.ConfigControl;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BasicDynaBean;
import org.apache.commons.beanutils.BasicDynaClass;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.ResultSetDynaClass;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.transform.ResultTransformer;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.util.Assert;

public class GenericHibernateDao<T, PK extends Serializable>
extends HibernateDaoSupport {
    protected Class<T> entityClass = ReflectionUtils.getSuperClassGenricType(this.getClass());
    private JdbcTemplate jdbcTemplate;

    public T get(PK id) {
        Assert.notNull(id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        return (T)this.getHibernateTemplate().get(this.entityClass, id);
    }

    public Serializable save(T entity) {
        return this.getHibernateTemplate().save(entity);
    }

    public void update(T entity) {
        this.getHibernateTemplate().update(entity);
    }

    public void update(String sql) {
        this.jdbcTemplate.update(sql);
    }

    public void delete(String sql) {
        this.jdbcTemplate.execute(sql);
    }

    public void saveOrUpdate(T entity) {
        this.getHibernateTemplate().saveOrUpdate(entity);
    }

    public List<T> loadAll() {
        return this.getHibernateTemplate().loadAll(this.entityClass);
    }

    public void delete(T entity) {
        this.getHibernateTemplate().delete(entity);
    }

    public void delete(List<PK> idList) {
        for (Serializable id : idList) {
            try {
                SessionFactory sf = this.getSession().getSessionFactory();
                ClassMetadata cm = sf.getClassMetadata(this.entityClass);
                String idName = cm.getIdentifierPropertyName();
                Object entity = this.entityClass.newInstance();
                ReflectionUtils.setFieldValue(entity, (String)idName, (Object)id);
                this.delete(entity);
            }
            catch (Exception e) {
                ExceptionHandler.throwWraperException((Object)this, (Exception)e, DataAccessException.class, (String)("\u5220\u9664\u5b9e\u4f53\u96c6\u5408\u51fa\u9519,\u5b9e\u4f53id\u96c6\u5408\uff1a" + idList));
            }
        }
    }

    public void deleteByProperty(Properties props) {
        this.getSession().createQuery("Delete " + this.getConditionStrByProperties(props)).executeUpdate();
    }

    public List find(String hqlQueryStr, Object ... values) {
        return this.getHibernateTemplate().find(hqlQueryStr, values);
    }

    public int bulkUpdateOrDelete(String queryString, Object ... values) {
        return this.getHibernateTemplate().bulkUpdate(queryString, values);
    }

    public List<T> findByCriteria(DetachedCriteria criteria) {
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    public List<T> findByProperty(Properties props) {
        DetachedCriteria criteria = this.getCriteriaByProperties(props);
        return this.findByCriteria(criteria);
    }

    private DetachedCriteria getCriteriaByProperties(Properties props) {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)this.entityClass);
        Iterator iter = props.getKeySet().iterator();
        while (iter.hasNext()) {
            String key = ((String)iter.next()).toString();
            criteria.add((Criterion)Restrictions.eq((String)key, (Object)props.getProperty(key)));
        }
        return criteria;
    }

    private String getConditionStrByProperties(Properties props) {
        StringBuilder conditionStrBuilder = new StringBuilder("from " + this.entityClass.getName() + " where ");
        Iterator iter = props.getKeySet().iterator();
        while (iter.hasNext()) {
            String key = ((String)iter.next()).toString();
            conditionStrBuilder.append(key);
            conditionStrBuilder.append(" = ");
            Object value = props.getProperty(key);
            conditionStrBuilder.append(value.toString());
            if (!iter.hasNext()) continue;
            conditionStrBuilder.append(" and ");
        }
        return conditionStrBuilder.toString();
    }

    public List pagingFindByProperty(String hqlQueryStr, PagingOption pagingOption) {
        Query query = this.getSession().createQuery(hqlQueryStr);
        List list = this.pagingQueryByQueryOpt(query, pagingOption);
        return list;
    }

    public <X> Page<X> findPage(Page<X> page, List<PropertyFilter> filters) {
        Criterion[] criterions = this.buildPropertyFilterCriterions(filters);
        return this.findPage(page, criterions);
    }

    public <X> Page findPage(Page<X> page, String hql, Object ... values) {
        Assert.notNull(page, (String)"page\u4e0d\u80fd\u4e3a\u7a7a");
        Query q = this.createQuery(hql, values);
        if (page.isAutoCount()) {
            long totalCount = this.countHqlResult(hql, values);
            page.setTotalCount(totalCount);
        }
        this.setPageParameter(q, page);
        List result = q.list();
        page.setResult(result);
        return page;
    }

    public <X> Page<X> findPage(Page<X> page, Criterion ... criterions) {
        Assert.notNull(page, (String)"page\u4e0d\u80fd\u4e3a\u7a7a");
        Criteria criteria = this.getSession().createCriteria(this.entityClass);
        for (Criterion c : criterions) {
            criteria.add(c);
        }
        if (page.isAutoCount()) {
            int totalCount = this.countCriteriaResult(criteria);
            page.setTotalCount((long)totalCount);
        }
        this.setPageParameter(criteria, page);
        List result = criteria.list();
        page.setResult(result);
        return page;
    }

    private int countCriteriaResult(Criteria c) {
        CriteriaImpl impl = (CriteriaImpl)c;
        Projection projection = impl.getProjection();
        ResultTransformer transformer = impl.getResultTransformer();
        List orderEntries = null;
        try {
            orderEntries = (List)ReflectionUtils.getFieldValue((Object)impl, (String)"orderEntries");
            ReflectionUtils.setFieldValue((Object)impl, (String)"orderEntries", new ArrayList());
        }
        catch (Exception e) {
            this.logger.error((Object)("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38:" + e.getMessage()));
        }
        int totalCount = (Integer)c.setProjection(Projections.rowCount()).uniqueResult();
        c.setProjection(projection);
        if (projection == null) {
            c.setResultTransformer(CriteriaSpecification.ROOT_ENTITY);
        }
        if (transformer != null) {
            c.setResultTransformer(transformer);
        }
        try {
            ReflectionUtils.setFieldValue((Object)impl, (String)"orderEntries", (Object)orderEntries);
        }
        catch (Exception e) {
            this.logger.error((Object)("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38:" + e.getMessage()));
        }
        return totalCount;
    }

    protected long countHqlResult(String hql, Map<String, Object> values) {
        String fromHql = hql;
        fromHql = "from " + StringUtils.substringAfter((String)fromHql, (String)"from");
        fromHql = StringUtils.substringBefore((String)fromHql, (String)"order by");
        String countHql = "select count(*) " + fromHql;
        try {
            Long count = (Long)this.findUnique(countHql, values);
            return count;
        }
        catch (Exception e) {
            throw new RuntimeException("hql can't be auto count, hql is:" + countHql, e);
        }
    }

    protected long countSQLResult(String sql, Map<String, Object> values) {
        String fromHql = sql;
        fromHql = "select count(*) from (" + fromHql + ")";
        try {
            Long count = StringUtil.getLongFrom((Object)this.findSQLUnique(fromHql, values));
            return count;
        }
        catch (Exception e) {
            throw new RuntimeException("sql can't be auto count, hql is:" + fromHql, e);
        }
    }

    protected long countHqlResultByGroup(String hql, Map<String, Object> values) {
        String fromHql = hql;
        fromHql = "from " + StringUtils.substringAfter((String)fromHql, (String)"from");
        fromHql = StringUtils.substringBefore((String)fromHql, (String)"order by");
        String countHql = "select count(*) " + fromHql;
        try {
            Long count = this.findUniqueByGroup(countHql, values);
            return count;
        }
        catch (Exception e) {
            throw new RuntimeException("hql can't be auto count, hql is:" + countHql, e);
        }
    }

    public <X> Page<X> findPage(Page<X> page, String hql, Map<String, Object> values) {
        Assert.notNull(page, (String)"page\u4e0d\u80fd\u4e3a\u7a7a");
        Query q = this.createQuery(hql, values);
        if (page.isAutoCount()) {
            long totalCount = this.countHqlResult(hql, values);
            page.setTotalCount(totalCount);
        }
        this.setPageParameter(q, page);
        List result = q.list();
        page.setResult(result);
        return page;
    }

    public <X> Page<X> findPageByGroup(Page<X> page, String hql, Map<String, Object> values) {
        Assert.notNull(page, (String)"page\u4e0d\u80fd\u4e3a\u7a7a");
        Query q = this.createQuery(hql, values);
        if (page.isAutoCount()) {
            long totalCount = this.countHqlResultByGroup(hql, values);
            page.setTotalCount(totalCount);
        }
        this.setPageParameter(q, page);
        List result = q.list();
        page.setResult(result);
        return page;
    }

    private <X> Query setPageParameter(Query q, Page<X> page) {
        q.setFirstResult(page.getStart());
        q.setMaxResults(page.getPageSize());
        return q;
    }

    private <X> Criteria setPageParameter(Criteria c, Page<X> page) {
        c.setFirstResult(page.getStart() - 1);
        c.setMaxResults(page.getPageSize());
        if (page.isOrderBySetted()) {
            String[] orderArray;
            String[] orderByArray = StringUtils.split((String)page.getOrderBy(), (char)',');
            Assert.isTrue((orderByArray.length == (orderArray = StringUtils.split((String)page.getOrder(), (char)',')).length ? 1 : 0) != 0, (String)"\u5206\u9875\u591a\u91cd\u6392\u5e8f\u53c2\u6570\u4e2d,\u6392\u5e8f\u5b57\u6bb5\u4e0e\u6392\u5e8f\u65b9\u5411\u7684\u4e2a\u6570\u4e0d\u76f8\u7b49");
            for (int i = 0; i < orderByArray.length; ++i) {
                if ("asc".equals(orderArray[i])) {
                    c.addOrder(Order.asc((String)orderByArray[i]));
                    continue;
                }
                c.addOrder(Order.desc((String)orderByArray[i]));
            }
        }
        return c;
    }

    protected long countHqlResult(String hql, Object ... values) {
        String fromHql = hql;
        fromHql = "from " + StringUtils.substringAfter((String)fromHql, (String)"from");
        fromHql = StringUtils.substringBefore((String)fromHql, (String)"order by");
        String countHql = "select count(*) " + fromHql;
        try {
            Long count = (Long)this.findUnique(countHql, values);
            return count;
        }
        catch (Exception e) {
            throw new RuntimeException("hql can't be auto count, hql is:" + countHql, e);
        }
    }

    public <X> X findUnique(String hql, Object ... values) {
        Object obj = this.createQuery(hql, values).uniqueResult();
        return (X)obj;
    }

    public <X> X findUnique(String hql, Map<String, Object> values) {
        Object obj = this.createQuery(hql, values).uniqueResult();
        return (X)obj;
    }

    public <X> X findSQLUnique(String sql, Map<String, Object> values) {
        Object obj = this.createSQLQuery(sql, values).uniqueResult();
        return (X)obj;
    }

    public long findUniqueByGroup(String hql, Map<String, Object> values) {
        long count = this.createQuery(hql, values).list().size();
        return count;
    }

    public Query createQuery(String queryString, Object ... values) {
        Assert.hasText((String)queryString, (String)"queryString\u4e0d\u80fd\u4e3a\u7a7a");
        Query query = this.getSession().createQuery(queryString);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                query.setParameter(i, values[i]);
            }
        }
        return query;
    }

    public Query createQuery(Session session, String queryString, Map<String, Object> values) {
        Assert.hasText((String)queryString, (String)"queryString\u4e0d\u80fd\u4e3a\u7a7a");
        Query query = session.createQuery(queryString);
        if (values != null) {
            query.setProperties(values);
        }
        return query;
    }

    public Query createQuery(String queryString, Map<String, Object> values) {
        Assert.hasText((String)queryString, (String)"queryString\u4e0d\u80fd\u4e3a\u7a7a");
        Query query = this.getSession().createQuery(queryString);
        if (values != null) {
            query.setProperties(values);
        }
        return query;
    }

    public Query createSQLQuery(String queryString, Map<String, Object> values) {
        Assert.hasText((String)queryString, (String)"queryString\u4e0d\u80fd\u4e3a\u7a7a");
        SQLQuery query = this.getSession().createSQLQuery(queryString);
        if (values != null) {
            query.setProperties(values);
        }
        return query;
    }

    public List pagingFindByProperty(String hqlQueryStr, Properties props, PagingOption pagingOption) {
        Query query = this.getSession().createQuery(hqlQueryStr);
        for (String key : props.getKeySet()) {
            query.setParameter(key, props.getProperty(key));
        }
        List list = this.pagingQueryByQueryOpt(query, pagingOption);
        return list;
    }

    public List pagingFindByProperty(String hqlQueryStr, Object[] values, PagingOption pagingOption) {
        Query query = this.getSession().createQuery(hqlQueryStr);
        for (int i = 0; i < values.length; ++i) {
            query.setParameter(i, values[i]);
        }
        List list = this.pagingQueryByQueryOpt(query, pagingOption);
        return list;
    }

    private List pagingQueryByQueryOpt(Query query, PagingOption pagingOption) {
        if (pagingOption.getRecordCount() == -1 || pagingOption.getRecordCount() == 0) {
            pagingOption.setRecordCount(query.list().size());
        }
        query.setFirstResult(pagingOption.getFirstResult());
        query.setMaxResults(pagingOption.getPerPageRecordCount());
        return query.list();
    }

    private List pagingQueryByQueryopt1(Query query, String sql, Page page, Map<String, Object> values) {
        if (page.getTotalCount() == -1L || page.getTotalCount() == 0L) {
            long count = this.countSQLResult(sql, values);
            page.setTotalCount(count);
        }
        query.setFirstResult(page.getStart());
        query.setMaxResults(page.getPageSize());
        return query.list();
    }

    private List pagingQueryByQueryopt2(Query query, Page page) {
        if (page.getTotalCount() == -1L || page.getTotalCount() == 0L) {
            page.setTotalCount((long)query.list().size());
        }
        query.setFirstResult(page.getStart());
        query.setMaxResults(page.getPageSize());
        return query.list();
    }

    public List pagingFindBySQL(String sqlQueryString, Object[] values, PagingOption pagingOption) {
        SQLQuery query = this.getSession().createSQLQuery(sqlQueryString);
        for (int i = 0; i < values.length; ++i) {
            query.setParameter(i, values[i]);
        }
        List list = this.pagingQueryByQueryOpt((Query)query, pagingOption);
        return list;
    }

    public List pagingFindBySQL1(String sqlQueryString, Map<String, Object> values, Page<?> page) {
        SQLQuery query = this.getSession().createSQLQuery(sqlQueryString);
        if (values != null) {
            query.setProperties(values);
        }
        List list = this.pagingQueryByQueryopt2((Query)query, page);
        return list;
    }

    public List pagingFindBySQL2(String sqlQueryString, Map<String, Object> values, Page<?> page) {
        SQLQuery query = this.getSession().createSQLQuery(sqlQueryString);
        if (values != null) {
            query.setProperties(values);
        }
        List list = this.pagingQueryByQueryopt1((Query)query, sqlQueryString, page, values);
        return list;
    }

    public List pagingFindBySQL(String hqlQueryStr, Properties props, PagingOption pagingOption) {
        Query query = this.getSession().createQuery(hqlQueryStr);
        for (String key : props.getKeySet()) {
            query.setParameter(key, props.getProperty(key));
        }
        List list = this.pagingQueryByQueryOpt(query, pagingOption);
        return list;
    }

    public List pagingFindBySQL(String sqlQueryString, PagingOption pagingOption) {
        SQLQuery query = this.getSession().createSQLQuery(sqlQueryString);
        List list = this.pagingQueryByQueryOpt((Query)query, pagingOption);
        return list;
    }

    public List<?> findBySQL(String sqlQueryString, Object ... values) {
        SQLQuery query = this.getSession().createSQLQuery(sqlQueryString);
        for (int i = 0; i < values.length; ++i) {
            query.setParameter(i, values[i]);
        }
        List list = query.list();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DynaBean> runProcedure(String procName, ProcdureProperties[] values) throws Exception {
        Statement cs = null;
        ResultSet rs = null;
        Connection conn = this.getSessionFactory().openSession().connection();
        try {
            conn.setAutoCommit(true);
            cs = conn.prepareCall(this.getProcFullName(procName, values.length));
            int index = 1;
            for (ProcdureProperties prop : values) {
                cs.setObject(index, prop.getValue(), prop.getTargetSqlType());
                ++index;
            }
            rs = cs.executeQuery();
            conn.setAutoCommit(false);
            List list = this.convertToList(rs);
            return list;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            List<DynaBean> list = null;
            return list;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (cs != null) {
                cs.close();
            }
        }
    }

    private String getProcFullName(String procName, int paraCount) {
        StringBuffer sb = new StringBuffer("{call ");
        sb.append(procName);
        sb.append("(");
        for (int i = 0; i < paraCount; ++i) {
            sb.append('?');
            if (i == paraCount - 1) continue;
            sb.append(',');
        }
        sb.append(")}");
        return sb.toString();
    }

    private List<DynaBean> convertToList(ResultSet rs) throws Exception {
        ArrayList<DynaBean> results = new ArrayList<DynaBean>();
        try {
            ResultSetDynaClass rsdc = new ResultSetDynaClass(rs);
            BasicDynaClass bdc = new BasicDynaClass("DynaBeanTemplate", BasicDynaBean.class, rsdc.getDynaProperties());
            for (DynaBean oldRow : rsdc) {
                DynaBean newRow = bdc.newInstance();
                PropertyUtils.copyProperties((Object)newRow, (Object)oldRow);
                results.add(newRow);
            }
            return results;
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<T> find(List<PropertyFilter> filters) {
        Criterion[] criterions = this.buildPropertyFilterCriterions(filters);
        return this.find(criterions);
    }

    public List<T> find(Criterion ... criterions) {
        DetachedCriteria dc = this.createDetachedCriteria(criterions);
        return this.getHibernateTemplate().findByCriteria(dc);
    }

    private DetachedCriteria createDetachedCriteria(Criterion ... criterions) {
        DetachedCriteria dc = DetachedCriteria.forClass((Class)this.entityClass);
        for (Criterion ctn : criterions) {
            dc.add(ctn);
        }
        return dc;
    }

    protected Criterion[] buildPropertyFilterCriterions(List<PropertyFilter> filters) {
        ArrayList<Object> criterionList = new ArrayList<Object>();
        for (PropertyFilter filter : filters) {
            if (!filter.isMultiProperty()) {
                Criterion criterion = this.buildPropertyFilterCriterion(filter.getPropertyName(), filter.getPropertyValue(), filter.getMatchType());
                criterionList.add(criterion);
                continue;
            }
            Disjunction disjunction = Restrictions.disjunction();
            for (String param : filter.getPropertyNames()) {
                Criterion criterion = this.buildPropertyFilterCriterion(param, filter.getPropertyValue(), filter.getMatchType());
                disjunction.add(criterion);
            }
            criterionList.add(disjunction);
        }
        return criterionList.toArray(new Criterion[criterionList.size()]);
    }

    protected Criterion buildPropertyFilterCriterion(String propertyName, Object propertyValue, PropertyFilter.MatchType matchType) {
        Assert.hasText((String)propertyName, (String)"propertyName\u4e0d\u80fd\u4e3a\u7a7a");
        SimpleExpression criterion = null;
        try {
            if (PropertyFilter.MatchType.EQ.equals((Object)matchType)) {
                criterion = Restrictions.eq((String)propertyName, (Object)propertyValue);
            } else if (PropertyFilter.MatchType.LIKE.equals((Object)matchType)) {
                criterion = Restrictions.like((String)propertyName, (String)((String)propertyValue), (MatchMode)MatchMode.ANYWHERE);
            } else if (PropertyFilter.MatchType.LE.equals((Object)matchType)) {
                criterion = Restrictions.le((String)propertyName, (Object)propertyValue);
            } else if (PropertyFilter.MatchType.LT.equals((Object)matchType)) {
                criterion = Restrictions.lt((String)propertyName, (Object)propertyValue);
            } else if (PropertyFilter.MatchType.GE.equals((Object)matchType)) {
                criterion = Restrictions.ge((String)propertyName, (Object)propertyValue);
            } else if (PropertyFilter.MatchType.GT.equals((Object)matchType)) {
                criterion = Restrictions.gt((String)propertyName, (Object)propertyValue);
            }
        }
        catch (Exception e) {
            throw ReflectionUtils.convertReflectionExceptionToUnchecked((Exception)e);
        }
        return criterion;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    protected List findPagesByJdbcTemplate(String sql, int pageSize, int fetchSize) {
        this.jdbcTemplate.setMaxRows(pageSize);
        this.jdbcTemplate.setFetchSize(fetchSize);
        List res = this.jdbcTemplate.queryForList(sql);
        return res;
    }

    public boolean isOracle() {
        Object obj = ConfigControl.getStConfigCache().getConfigValue((Object)"DB_TYPE");
        if (obj == null) {
            return true;
        }
        String dbType = (String)obj;
        return dbType.toUpperCase().equals("ORACLE");
    }
}

