/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.metadata;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.TypeUtils;
import com.alibaba.nacos.consistency.DataOperation;
import com.alibaba.nacos.consistency.SerializeFactory;
import com.alibaba.nacos.consistency.Serializer;
import com.alibaba.nacos.consistency.cp.RequestProcessor4CP;
import com.alibaba.nacos.consistency.entity.ReadRequest;
import com.alibaba.nacos.consistency.entity.Response;
import com.alibaba.nacos.consistency.entity.WriteRequest;
import com.alibaba.nacos.consistency.snapshot.SnapshotOperation;
import com.alibaba.nacos.core.distributed.ProtocolManager;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.event.service.ServiceEvent;
import com.alibaba.nacos.naming.core.v2.metadata.InstanceMetadata;
import com.alibaba.nacos.naming.core.v2.metadata.InstanceMetadataSnapshotOperation;
import com.alibaba.nacos.naming.core.v2.metadata.MetadataOperation;
import com.alibaba.nacos.naming.core.v2.metadata.NamingMetadataManager;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.stereotype.Component;

@Component
public class InstanceMetadataProcessor
extends RequestProcessor4CP {
    private final NamingMetadataManager namingMetadataManager;
    private final Serializer serializer;
    private final Type processType;
    private final ReentrantReadWriteLock lock;
    private final ReentrantReadWriteLock.ReadLock readLock;

    public InstanceMetadataProcessor(NamingMetadataManager namingMetadataManager, ProtocolManager protocolManager) {
        this.namingMetadataManager = namingMetadataManager;
        this.serializer = SerializeFactory.getDefault();
        this.processType = TypeUtils.parameterize(MetadataOperation.class, (Type[])new Type[]{InstanceMetadata.class});
        this.lock = new ReentrantReadWriteLock();
        this.readLock = this.lock.readLock();
        protocolManager.getCpProtocol().addRequestProcessors(Collections.singletonList(this));
    }

    public List<SnapshotOperation> loadSnapshotOperate() {
        return Collections.singletonList(new InstanceMetadataSnapshotOperation(this.namingMetadataManager, this.lock));
    }

    public Response onRequest(ReadRequest request) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response onApply(WriteRequest request) {
        MetadataOperation op = (MetadataOperation)this.serializer.deserialize(request.getData().toByteArray(), this.processType);
        this.readLock.lock();
        try {
            switch (DataOperation.valueOf((String)request.getOperation())) {
                case ADD: 
                case CHANGE: {
                    this.updateInstanceMetadata(op);
                    break;
                }
                case DELETE: {
                    this.deleteInstanceMetadata(op);
                    break;
                }
                default: {
                    Response response = Response.newBuilder().setSuccess(false).setErrMsg("Unsupported operation " + request.getOperation()).build();
                    return response;
                }
            }
            Response response = Response.newBuilder().setSuccess(true).build();
            return response;
        }
        catch (Exception e) {
            Response response = Response.newBuilder().setSuccess(false).setErrMsg(e.getMessage()).build();
            return response;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void updateInstanceMetadata(MetadataOperation<InstanceMetadata> op) {
        Service service = Service.newService(op.getNamespace(), op.getGroup(), op.getServiceName());
        service = ServiceManager.getInstance().getSingleton(service);
        this.namingMetadataManager.updateInstanceMetadata(service, op.getTag(), op.getMetadata());
        NotifyCenter.publishEvent((Event)new ServiceEvent.ServiceChangedEvent(service, true));
    }

    private void deleteInstanceMetadata(MetadataOperation<InstanceMetadata> op) {
        Service service = Service.newService(op.getNamespace(), op.getGroup(), op.getServiceName());
        service = ServiceManager.getInstance().getSingleton(service);
        this.namingMetadataManager.removeInstanceMetadata(service, op.getTag());
    }

    public String group() {
        return "naming_instance_metadata";
    }
}

