/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.consistency;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.consistency.Serializer;
import com.alibaba.nacos.consistency.serialize.HessianSerializer;
import java.util.HashMap;
import java.util.Map;

public class SerializeFactory {
    public static final String HESSIAN_INDEX = "Hessian".toLowerCase();
    private static final Map<String, Serializer> SERIALIZER_MAP = new HashMap<String, Serializer>(4);
    public static String defaultSerializer = HESSIAN_INDEX;

    public static Serializer getDefault() {
        return SERIALIZER_MAP.get(defaultSerializer);
    }

    public static Serializer getSerializer(String type) {
        return SERIALIZER_MAP.get(type.toLowerCase());
    }

    static {
        HessianSerializer serializer = new HessianSerializer();
        SERIALIZER_MAP.put(HESSIAN_INDEX, serializer);
        for (Serializer item : NacosServiceLoader.load(Serializer.class)) {
            SERIALIZER_MAP.put(item.name().toLowerCase(), item);
        }
    }
}

