/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.embedded;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.Pair;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.constant.Constants;
import com.alibaba.nacos.config.server.enums.FileTypeEnum;
import com.alibaba.nacos.config.server.exception.NacosConfigException;
import com.alibaba.nacos.config.server.model.ConfigAdvanceInfo;
import com.alibaba.nacos.config.server.model.ConfigAllInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoStateWrapper;
import com.alibaba.nacos.config.server.model.ConfigInfoWrapper;
import com.alibaba.nacos.config.server.model.ConfigOperateResult;
import com.alibaba.nacos.config.server.model.SameConfigPolicy;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigRowMapperInjector;
import com.alibaba.nacos.config.server.service.repository.HistoryConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.sql.EmbeddedStorageContextUtils;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.core.distributed.id.IdGeneratorManager;
import com.alibaba.nacos.persistence.configuration.condition.ConditionOnEmbeddedStorage;
import com.alibaba.nacos.persistence.datasource.DataSourceService;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.persistence.model.Page;
import com.alibaba.nacos.persistence.model.event.DerbyImportEvent;
import com.alibaba.nacos.persistence.repository.PaginationHelper;
import com.alibaba.nacos.persistence.repository.RowMapperManager;
import com.alibaba.nacos.persistence.repository.embedded.EmbeddedPaginationHelperImpl;
import com.alibaba.nacos.persistence.repository.embedded.EmbeddedStorageContextHolder;
import com.alibaba.nacos.persistence.repository.embedded.operate.DatabaseOperate;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoMapper;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigTagsRelationMapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import com.alibaba.nacos.plugin.encryption.handler.EncryptionHandler;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Conditional(value={ConditionOnEmbeddedStorage.class})
@Service(value="embeddedConfigInfoPersistServiceImpl")
public class EmbeddedConfigInfoPersistServiceImpl
implements ConfigInfoPersistService {
    private static final String RESOURCE_CONFIG_INFO_ID = "config-info-id";
    private static final String RESOURCE_CONFIG_HISTORY_ID = "config-history-id";
    private static final String RESOURCE_CONFIG_TAG_RELATION_ID = "config-tag-relation-id";
    private static final String RESOURCE_APP_CONFIGDATA_RELATION_SUBS = "app-configdata-relation-subs";
    private static final String RESOURCE_CONFIG_BETA_ID = "config-beta-id";
    private static final String RESOURCE_NAMESPACE_ID = "namespace-id";
    private static final String RESOURCE_USER_ID = "user-id";
    private static final String RESOURCE_ROLE_ID = "role-id";
    private static final String RESOURCE_PERMISSIONS_ID = "permissions_id";
    private static final String DATA_ID = "dataId";
    private static final String GROUP = "group";
    private static final String APP_NAME = "appName";
    private static final String CONTENT = "content";
    private static final String TENANT = "tenant_id";
    public static final String SPOT = ".";
    private DataSourceService dataSourceService;
    private final DatabaseOperate databaseOperate;
    private final IdGeneratorManager idGeneratorManager;
    MapperManager mapperManager;
    private HistoryConfigInfoPersistService historyConfigInfoPersistService;

    public EmbeddedConfigInfoPersistServiceImpl(DatabaseOperate databaseOperate, IdGeneratorManager idGeneratorManager, @Qualifier(value="embeddedHistoryConfigInfoPersistServiceImpl") HistoryConfigInfoPersistService historyConfigInfoPersistService) {
        this.databaseOperate = databaseOperate;
        this.idGeneratorManager = idGeneratorManager;
        idGeneratorManager.register(new String[]{RESOURCE_CONFIG_INFO_ID, RESOURCE_CONFIG_HISTORY_ID, RESOURCE_CONFIG_TAG_RELATION_ID, RESOURCE_APP_CONFIGDATA_RELATION_SUBS, RESOURCE_CONFIG_BETA_ID, RESOURCE_NAMESPACE_ID, RESOURCE_USER_ID, RESOURCE_ROLE_ID, RESOURCE_PERMISSIONS_ID});
        this.dataSourceService = DynamicDataSource.getInstance().getDataSource();
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
        this.historyConfigInfoPersistService = historyConfigInfoPersistService;
        NotifyCenter.registerToSharePublisher(DerbyImportEvent.class);
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new EmbeddedPaginationHelperImpl(this.databaseOperate);
    }

    @Override
    public String generateLikeArgument(String s) {
        String fuzzySearchSign = "\\*";
        String sqlLikePercentSign = "%";
        if (s.contains("*")) {
            return s.replaceAll(fuzzySearchSign, sqlLikePercentSign);
        }
        return s;
    }

    @Override
    public ConfigInfoStateWrapper findConfigInfoState(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.select(Arrays.asList("id", "data_id", "group_id", TENANT, "gmt_modified"), Arrays.asList("data_id", "group_id", TENANT));
        return (ConfigInfoStateWrapper)this.databaseOperate.queryOne(sql, new Object[]{dataId, group, tenantTmp}, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_STATE_WRAPPER_ROW_MAPPER);
    }

    private ConfigOperateResult getConfigInfoOperateResult(String dataId, String group, String tenant) {
        ConfigInfoStateWrapper configInfo4 = this.findConfigInfoState(dataId, group, tenant);
        if (configInfo4 == null) {
            return new ConfigOperateResult(false);
        }
        return new ConfigOperateResult(configInfo4.getId(), configInfo4.getLastModified());
    }

    @Override
    public ConfigOperateResult addConfigInfo(String srcIp, String srcUser, ConfigInfo configInfo, Map<String, Object> configAdvanceInfo) {
        return this.addConfigInfo(srcIp, srcUser, configInfo, configAdvanceInfo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigOperateResult addConfigInfo(String srcIp, String srcUser, ConfigInfo configInfo, Map<String, Object> configAdvanceInfo, BiConsumer<Boolean, Throwable> consumer) {
        try {
            String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
            configInfo.setTenant(tenantTmp);
            long configId = this.idGeneratorManager.nextId(RESOURCE_CONFIG_INFO_ID);
            long hisId = this.idGeneratorManager.nextId(RESOURCE_CONFIG_HISTORY_ID);
            this.addConfigInfoAtomic(configId, srcIp, srcUser, configInfo, configAdvanceInfo);
            String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
            this.addConfigTagsRelation(configId, configTags, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
            Timestamp now = new Timestamp(System.currentTimeMillis());
            this.historyConfigInfoPersistService.insertConfigHistoryAtomic(hisId, configInfo, srcIp, srcUser, now, "I");
            EmbeddedStorageContextUtils.onModifyConfigInfo(configInfo, srcIp, now);
            this.databaseOperate.blockUpdate(consumer);
            ConfigOperateResult configOperateResult = this.getConfigInfoOperateResult(configInfo.getDataId(), configInfo.getGroup(), tenantTmp);
            return configOperateResult;
        }
        finally {
            EmbeddedStorageContextHolder.cleanAllContext();
        }
    }

    @Override
    public ConfigOperateResult insertOrUpdate(String srcIp, String srcUser, ConfigInfo configInfo, Map<String, Object> configAdvanceInfo) {
        if (Objects.isNull(this.findConfigInfoState(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant()))) {
            return this.addConfigInfo(srcIp, srcUser, configInfo, configAdvanceInfo);
        }
        return this.updateConfigInfo(configInfo, srcIp, srcUser, configAdvanceInfo);
    }

    @Override
    public ConfigOperateResult insertOrUpdateCas(String srcIp, String srcUser, ConfigInfo configInfo, Map<String, Object> configAdvanceInfo) {
        if (Objects.isNull(this.findConfigInfoState(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant()))) {
            return this.addConfigInfo(srcIp, srcUser, configInfo, configAdvanceInfo);
        }
        return this.updateConfigInfoCas(configInfo, srcIp, srcUser, configAdvanceInfo);
    }

    @Override
    public long addConfigInfoAtomic(long id, String srcIp, String srcUser, ConfigInfo configInfo, Map<String, Object> configAdvanceInfo) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String desc = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("desc");
        String use = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("use");
        String effect = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("effect");
        String type = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("type");
        String schema = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("schema");
        String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)Constants.PERSIST_ENCODE);
        String encryptedDataKey = configInfo.getEncryptedDataKey() == null ? "" : configInfo.getEncryptedDataKey();
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        Timestamp time = new Timestamp(System.currentTimeMillis());
        String sql = configInfoMapper.insert(Arrays.asList("id", "data_id", "group_id", TENANT, "app_name", CONTENT, "md5", "src_ip", "src_user", "gmt_create", "gmt_modified", "c_desc", "c_use", "effect", "type", "c_schema", "encrypted_data_key"));
        Object[] args = new Object[]{id, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, appNameTmp, configInfo.getContent(), md5Tmp, srcIp, srcUser, time, time, desc, use, effect, type, schema, encryptedDataKey};
        EmbeddedStorageContextHolder.addSqlContext((String)sql, (Object[])args);
        return id;
    }

    @Override
    public void addConfigTagRelationAtomic(long configId, String tagName, String dataId, String group, String tenant) {
        ConfigTagsRelationMapper configTagsRelationMapper = (ConfigTagsRelationMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_tags_relation");
        String sql = configTagsRelationMapper.insert(Arrays.asList("id", "tag_name", "tag_type", "data_id", "group_id", TENANT));
        Object[] args = new Object[]{configId, tagName, "", dataId, group, tenant};
        EmbeddedStorageContextHolder.addSqlContext((String)sql, (Object[])args);
    }

    @Override
    public void addConfigTagsRelation(long configId, String configTags, String dataId, String group, String tenant) {
        if (StringUtils.isNotBlank((String)configTags)) {
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                this.addConfigTagRelationAtomic(configId, tagArr[i], dataId, group, tenant);
            }
        }
    }

    @Override
    public Map<String, Object> batchInsertOrUpdate(List<ConfigAllInfo> configInfoList, String srcUser, String srcIp, Map<String, Object> configAdvanceInfo, SameConfigPolicy policy) throws NacosException {
        int succCount = 0;
        int skipCount = 0;
        ArrayList failData = null;
        ArrayList skipData = null;
        BiConsumer<Boolean, Throwable> callFinally = (result, t) -> {
            if (t != null) {
                throw new NacosRuntimeException(0, t);
            }
        };
        for (int i = 0; i < configInfoList.size(); ++i) {
            ConfigAllInfo configInfo = configInfoList.get(i);
            try {
                ParamUtils.checkParam(configInfo.getDataId(), configInfo.getGroup(), "datumId", configInfo.getContent());
            }
            catch (Throwable e) {
                LogUtil.DEFAULT_LOG.error("data verification failed", e);
                throw e;
            }
            ConfigInfo configInfo2Save = new ConfigInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), configInfo.getAppName(), configInfo.getContent());
            configInfo2Save.setEncryptedDataKey(configInfo.getEncryptedDataKey() == null ? "" : configInfo.getEncryptedDataKey());
            String type = configInfo.getType();
            if (StringUtils.isBlank((CharSequence)type)) {
                if (configInfo.getDataId().contains(SPOT)) {
                    String extName = configInfo.getDataId().substring(configInfo.getDataId().lastIndexOf(SPOT) + 1);
                    FileTypeEnum fileTypeEnum = FileTypeEnum.getFileTypeEnumByFileExtensionOrFileType(extName);
                    type = fileTypeEnum.getFileType();
                } else {
                    type = FileTypeEnum.getFileTypeEnumByFileExtensionOrFileType(null).getFileType();
                }
            }
            if (configAdvanceInfo == null) {
                configAdvanceInfo = new HashMap<String, Object>(16);
            }
            configAdvanceInfo.put("type", type);
            configAdvanceInfo.put("desc", configInfo.getDesc());
            try {
                ConfigInfoStateWrapper foundCfg = this.findConfigInfoState(configInfo2Save.getDataId(), configInfo2Save.getGroup(), configInfo2Save.getTenant());
                if (foundCfg != null) {
                    throw new Throwable("DuplicateKeyException: config already exists, should be overridden");
                }
                this.addConfigInfo(srcIp, srcUser, configInfo2Save, configAdvanceInfo, callFinally);
                ++succCount;
                continue;
            }
            catch (Throwable e) {
                if (!StringUtils.contains((CharSequence)e.toString(), (CharSequence)"DuplicateKeyException")) {
                    throw new NacosException(500, e);
                }
                if (SameConfigPolicy.ABORT.equals((Object)policy)) {
                    failData = new ArrayList();
                    skipData = new ArrayList();
                    HashMap<String, String> faileditem = new HashMap<String, String>(2);
                    faileditem.put(DATA_ID, configInfo2Save.getDataId());
                    faileditem.put(GROUP, configInfo2Save.getGroup());
                    failData.add(faileditem);
                    for (int j = i + 1; j < configInfoList.size(); ++j) {
                        ConfigInfo skipConfigInfo = configInfoList.get(j);
                        HashMap<String, String> skipitem = new HashMap<String, String>(2);
                        skipitem.put(DATA_ID, skipConfigInfo.getDataId());
                        skipitem.put(GROUP, skipConfigInfo.getGroup());
                        skipData.add(skipitem);
                        ++skipCount;
                    }
                    break;
                }
                if (SameConfigPolicy.SKIP.equals((Object)policy)) {
                    ++skipCount;
                    if (skipData == null) {
                        skipData = new ArrayList();
                    }
                    HashMap<String, String> skipitem = new HashMap<String, String>(2);
                    skipitem.put(DATA_ID, configInfo2Save.getDataId());
                    skipitem.put(GROUP, configInfo2Save.getGroup());
                    skipData.add(skipitem);
                    continue;
                }
                if (!SameConfigPolicy.OVERWRITE.equals((Object)policy)) continue;
                ++succCount;
                this.updateConfigInfo(configInfo2Save, srcIp, srcUser, configAdvanceInfo);
            }
        }
        HashMap<String, Object> result2 = new HashMap<String, Object>(4);
        result2.put("succCount", succCount);
        result2.put("skipCount", skipCount);
        if (failData != null && !failData.isEmpty()) {
            result2.put("failData", failData);
        }
        if (skipData != null && !skipData.isEmpty()) {
            result2.put("skipData", skipData);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfigInfo(String dataId, String group, String tenant, String srcIp, String srcUser) {
        Timestamp time = new Timestamp(System.currentTimeMillis());
        ConfigInfoWrapper configInfo = this.findConfigInfo(dataId, group, tenant);
        if (Objects.nonNull(configInfo)) {
            try {
                String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
                this.removeConfigInfoAtomic(dataId, group, tenantTmp, srcIp, srcUser);
                this.removeTagByIdAtomic(configInfo.getId());
                this.historyConfigInfoPersistService.insertConfigHistoryAtomic(configInfo.getId(), configInfo, srcIp, srcUser, time, "D");
                EmbeddedStorageContextUtils.onDeleteConfigInfo(tenantTmp, group, dataId, srcIp, time);
                boolean result = this.databaseOperate.update(EmbeddedStorageContextHolder.getCurrentSqlContext());
                if (!result) {
                    throw new NacosConfigException("config deletion failed");
                }
            }
            finally {
                EmbeddedStorageContextHolder.cleanAllContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConfigInfo> removeConfigInfoByIds(List<Long> ids, String srcIp, String srcUser) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        ids.removeAll(Collections.singleton(null));
        Timestamp time = new Timestamp(System.currentTimeMillis());
        try {
            String idsStr = StringUtils.join(ids, (String)",");
            List<ConfigInfo> configInfoList = this.findConfigInfosByIds(idsStr);
            if (CollectionUtils.isNotEmpty(configInfoList)) {
                this.removeConfigInfoByIdsAtomic(idsStr);
                for (ConfigInfo configInfo : configInfoList) {
                    this.removeTagByIdAtomic(configInfo.getId());
                    this.historyConfigInfoPersistService.insertConfigHistoryAtomic(configInfo.getId(), configInfo, srcIp, srcUser, time, "D");
                }
            }
            EmbeddedStorageContextUtils.onBatchDeleteConfigInfo(configInfoList);
            boolean result = this.databaseOperate.update(EmbeddedStorageContextHolder.getCurrentSqlContext());
            if (!result) {
                throw new NacosConfigException("Failed to config batch deletion");
            }
            List<ConfigInfo> list = configInfoList;
            return list;
        }
        finally {
            EmbeddedStorageContextHolder.cleanAllContext();
        }
    }

    @Override
    public void removeTagByIdAtomic(long id) {
        ConfigTagsRelationMapper configTagsRelationMapper = (ConfigTagsRelationMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_tags_relation");
        String sql = configTagsRelationMapper.delete(Collections.singletonList("id"));
        Object[] args = new Object[]{id};
        EmbeddedStorageContextHolder.addSqlContext((String)sql, (Object[])args);
    }

    @Override
    public void removeConfigInfoAtomic(String dataId, String group, String tenant, String srcIp, String srcUser) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.delete(Arrays.asList("data_id", "group_id", TENANT));
        Object[] args = new Object[]{dataId, group, tenantTmp};
        EmbeddedStorageContextHolder.addSqlContext((String)sql, (Object[])args);
    }

    @Override
    public void removeConfigInfoByIdsAtomic(String ids) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return;
        }
        ArrayList<Long> paramList = new ArrayList<Long>();
        String[] idArr = ids.split(",");
        for (int i = 0; i < idArr.length; ++i) {
            paramList.add(Long.parseLong(idArr[i]));
        }
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        MapperContext context = new MapperContext();
        context.putWhereParameter("ids", paramList);
        MapperResult result = configInfoMapper.removeConfigInfoByIdsAtomic(context);
        EmbeddedStorageContextHolder.addSqlContext((String)result.getSql(), (Object[])result.getParamList().toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigOperateResult updateConfigInfo(ConfigInfo configInfo, String srcIp, String srcUser, Map<String, Object> configAdvanceInfo) {
        try {
            String configTags;
            ConfigInfoWrapper oldConfigInfo = this.findConfigInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
            String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
            oldConfigInfo.setTenant(tenantTmp);
            String appNameTmp = oldConfigInfo.getAppName();
            if (configInfo.getAppName() == null) {
                configInfo.setAppName(appNameTmp);
            }
            this.updateConfigInfoAtomic(configInfo, srcIp, srcUser, configAdvanceInfo);
            String string = configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
            if (configTags != null) {
                this.removeTagByIdAtomic(oldConfigInfo.getId());
                this.addConfigTagsRelation(oldConfigInfo.getId(), configTags, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
            }
            Timestamp time = new Timestamp(System.currentTimeMillis());
            this.historyConfigInfoPersistService.insertConfigHistoryAtomic(oldConfigInfo.getId(), oldConfigInfo, srcIp, srcUser, time, "U");
            EmbeddedStorageContextUtils.onModifyConfigInfo(configInfo, srcIp, time);
            this.databaseOperate.blockUpdate();
            ConfigOperateResult configOperateResult = this.getConfigInfoOperateResult(configInfo.getDataId(), configInfo.getGroup(), tenantTmp);
            return configOperateResult;
        }
        finally {
            EmbeddedStorageContextHolder.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigOperateResult updateConfigInfoCas(ConfigInfo configInfo, String srcIp, String srcUser, Map<String, Object> configAdvanceInfo) {
        try {
            String configTags;
            ConfigInfoWrapper oldConfigInfo = this.findConfigInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
            String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
            oldConfigInfo.setTenant(tenantTmp);
            String appNameTmp = oldConfigInfo.getAppName();
            if (configInfo.getAppName() == null) {
                configInfo.setAppName(appNameTmp);
            }
            this.updateConfigInfoAtomicCas(configInfo, srcIp, srcUser, configAdvanceInfo);
            String string = configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
            if (configTags != null) {
                this.removeTagByIdAtomic(oldConfigInfo.getId());
                this.addConfigTagsRelation(oldConfigInfo.getId(), configTags, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
            }
            Timestamp time = new Timestamp(System.currentTimeMillis());
            this.historyConfigInfoPersistService.insertConfigHistoryAtomic(oldConfigInfo.getId(), oldConfigInfo, srcIp, srcUser, time, "U");
            EmbeddedStorageContextUtils.onModifyConfigInfo(configInfo, srcIp, time);
            boolean success = this.databaseOperate.blockUpdate();
            if (success) {
                ConfigOperateResult configOperateResult = this.getConfigInfoOperateResult(configInfo.getDataId(), configInfo.getGroup(), tenantTmp);
                return configOperateResult;
            }
            ConfigOperateResult configOperateResult = new ConfigOperateResult(false);
            return configOperateResult;
        }
        finally {
            EmbeddedStorageContextHolder.cleanAllContext();
        }
    }

    private ConfigOperateResult updateConfigInfoAtomicCas(ConfigInfo configInfo, String srcIp, String srcUser, Map<String, Object> configAdvanceInfo) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String desc = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("desc");
        String use = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("use");
        String effect = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("effect");
        String type = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("type");
        String schema = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("schema");
        String encryptedDataKey = configInfo.getEncryptedDataKey() == null ? "" : configInfo.getEncryptedDataKey();
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        Timestamp time = new Timestamp(System.currentTimeMillis());
        MapperContext context = new MapperContext();
        context.putUpdateParameter(CONTENT, (Object)configInfo.getContent());
        context.putUpdateParameter("md5", (Object)md5Tmp);
        context.putUpdateParameter("srcIp", (Object)srcIp);
        context.putUpdateParameter("srcUser", (Object)srcUser);
        context.putUpdateParameter("gmtModified", (Object)time);
        context.putUpdateParameter("app_name", (Object)appNameTmp);
        context.putUpdateParameter("cDesc", (Object)desc);
        context.putUpdateParameter("cUse", (Object)use);
        context.putUpdateParameter("effect", (Object)effect);
        context.putUpdateParameter("type", (Object)type);
        context.putUpdateParameter("cSchema", (Object)schema);
        context.putUpdateParameter("encrypted_data_key", (Object)encryptedDataKey);
        context.putWhereParameter(DATA_ID, (Object)configInfo.getDataId());
        context.putWhereParameter("groupId", (Object)configInfo.getGroup());
        context.putWhereParameter("tenantId", (Object)tenantTmp);
        context.putWhereParameter("md5", (Object)configInfo.getMd5());
        MapperResult mapperResult = configInfoMapper.updateConfigInfoAtomicCas(context);
        EmbeddedStorageContextHolder.addSqlContext((String)mapperResult.getSql(), (Object[])mapperResult.getParamList().toArray());
        return this.getConfigInfoOperateResult(configInfo.getDataId(), configInfo.getGroup(), tenantTmp);
    }

    @Override
    public void updateConfigInfoAtomic(ConfigInfo configInfo, String srcIp, String srcUser, Map<String, Object> configAdvanceInfo) {
        String appNameTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getAppName());
        String tenantTmp = StringUtils.defaultEmptyIfBlank((String)configInfo.getTenant());
        String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String desc = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("desc");
        String use = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("use");
        String effect = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("effect");
        String type = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("type");
        String schema = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("schema");
        String encryptedDataKey = configInfo.getEncryptedDataKey() == null ? "" : configInfo.getEncryptedDataKey();
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.update(Arrays.asList(CONTENT, "md5", "src_ip", "src_user", "gmt_modified", "app_name", "c_desc", "c_use", "effect", "type", "c_schema", "encrypted_data_key"), Arrays.asList("data_id", "group_id", TENANT));
        Timestamp time = new Timestamp(System.currentTimeMillis());
        Object[] args = new Object[]{configInfo.getContent(), md5Tmp, srcIp, srcUser, time, appNameTmp, desc, use, effect, type, schema, encryptedDataKey, configInfo.getDataId(), configInfo.getGroup(), tenantTmp};
        EmbeddedStorageContextHolder.addSqlContext((String)sql, (Object[])args);
    }

    @Override
    public long findConfigMaxId() {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        MapperResult mapperResult = configInfoMapper.findConfigMaxId(null);
        return (Long)Optional.ofNullable(this.databaseOperate.queryOne(mapperResult.getSql(), Long.class)).orElse(0L);
    }

    @Override
    public ConfigInfo findConfigInfo(long id) {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.select(Arrays.asList("id", "data_id", "group_id", TENANT, "app_name", CONTENT), Collections.singletonList("id"));
        return (ConfigInfo)this.databaseOperate.queryOne(sql, new Object[]{id}, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public ConfigInfoWrapper findConfigInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.select(Arrays.asList("id", "data_id", "group_id", TENANT, "app_name", CONTENT, "md5", "type", "encrypted_data_key", "gmt_modified"), Arrays.asList("data_id", "group_id", TENANT));
        Object[] args = new Object[]{dataId, group, tenantTmp};
        return (ConfigInfoWrapper)this.databaseOperate.queryOne(sql, args, ConfigRowMapperInjector.CONFIG_INFO_WRAPPER_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfo> findConfigInfo4Page(int pageNo, int pageSize, String dataId, String group, String tenant, Map<String, Object> configAdvanceInfo) {
        MapperResult sql;
        MapperResult sqlCount;
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get(APP_NAME);
        String content = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get(CONTENT);
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        MapperContext context = new MapperContext();
        context.putWhereParameter("tenantId", (Object)tenantTmp);
        if (StringUtils.isNotBlank((String)dataId)) {
            context.putWhereParameter(DATA_ID, (Object)dataId);
        }
        if (StringUtils.isNotBlank((String)group)) {
            context.putWhereParameter("groupId", (Object)group);
        }
        if (StringUtils.isNotBlank((String)appName)) {
            context.putWhereParameter("app_name", (Object)appName);
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            context.putWhereParameter(CONTENT, (Object)content);
        }
        context.setStartRow((pageNo - 1) * pageSize);
        context.setPageSize(pageSize);
        if (StringUtils.isNotBlank((String)configTags)) {
            String[] tagArr = configTags.split(",");
            context.putWhereParameter("tagARR", (Object)tagArr);
            ConfigTagsRelationMapper configTagsRelationMapper = (ConfigTagsRelationMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_tags_relation");
            sqlCount = configTagsRelationMapper.findConfigInfo4PageCountRows(context);
            sql = configTagsRelationMapper.findConfigInfo4PageFetchRows(context);
        } else {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            sqlCount = configInfoMapper.findConfigInfo4PageCountRows(context);
            sql = configInfoMapper.findConfigInfo4PageFetchRows(context);
        }
        PaginationHelper helper = this.createPaginationHelper();
        Page page = helper.fetchPageLimit(sqlCount, sql, pageNo, pageSize, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_ROW_MAPPER);
        for (ConfigInfo configInfo : page.getPageItems()) {
            Pair pair = EncryptionHandler.decryptHandler((String)configInfo.getDataId(), (String)configInfo.getEncryptedDataKey(), (String)configInfo.getContent());
            configInfo.setContent((String)pair.getSecond());
        }
        return page;
    }

    @Override
    public int configInfoCount() {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.count(null);
        Integer result = (Integer)this.databaseOperate.queryOne(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoCount error");
        }
        return result;
    }

    @Override
    public int configInfoCount(String tenant) {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        MapperContext context = new MapperContext();
        context.putWhereParameter("tenantId", (Object)tenant);
        MapperResult mapperResult = configInfoMapper.configInfoLikeTenantCount(context);
        Integer result = (Integer)this.databaseOperate.queryOne(mapperResult.getSql(), mapperResult.getParamList().toArray(), Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoCount error");
        }
        return result;
    }

    @Override
    public List<String> getTenantIdList(int page, int pageSize) {
        PaginationHelper helper = this.createPaginationHelper();
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        int from = (page - 1) * pageSize;
        MapperResult mapperResult = configInfoMapper.getTenantIdList(new MapperContext(from, pageSize));
        Page pageList = helper.fetchPageLimit(mapperResult.getSql(), mapperResult.getParamList().toArray(), page, pageSize, (RowMapper)RowMapperManager.MAP_ROW_MAPPER);
        return pageList.getPageItems().stream().map(map -> String.valueOf(map.get("TENANT_ID"))).collect(Collectors.toList());
    }

    @Override
    public List<String> getGroupIdList(int page, int pageSize) {
        PaginationHelper helper = this.createPaginationHelper();
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        int from = (page - 1) * pageSize;
        MapperResult mapperResult = configInfoMapper.getGroupIdList(new MapperContext(from, pageSize));
        Page pageList = helper.fetchPageLimit(mapperResult.getSql(), mapperResult.getParamList().toArray(), page, pageSize, (RowMapper)RowMapperManager.MAP_ROW_MAPPER);
        return pageList.getPageItems().stream().map(map -> String.valueOf(map.get("GROUP_ID"))).collect(Collectors.toList());
    }

    @Override
    public Page<ConfigInfoWrapper> findAllConfigInfoFragment(long lastMaxId, int pageSize, boolean needContent) {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        MapperContext context = new MapperContext(0, pageSize);
        context.putContextParameter("needContent", String.valueOf(needContent));
        context.putWhereParameter("id", (Object)lastMaxId);
        MapperResult select = configInfoMapper.findAllConfigInfoFragment(context);
        PaginationHelper helper = this.createPaginationHelper();
        return helper.fetchPageLimit(select.getSql(), select.getParamList().toArray(), 1, pageSize, ConfigRowMapperInjector.CONFIG_INFO_WRAPPER_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfo> findConfigInfoLike4Page(int pageNo, int pageSize, String dataId, String group, String tenant, Map<String, Object> configAdvanceInfo) {
        MapperResult sqlFetchRows;
        MapperResult sqlCountRows;
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get(APP_NAME);
        String content = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get(CONTENT);
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        MapperContext context = new MapperContext((pageNo - 1) * pageSize, pageSize);
        context.putWhereParameter("tenantId", (Object)this.generateLikeArgument(tenantTmp));
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            context.putWhereParameter(DATA_ID, (Object)this.generateLikeArgument(dataId));
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            context.putWhereParameter("groupId", (Object)this.generateLikeArgument(group));
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            context.putWhereParameter("app_name", (Object)appName);
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            context.putWhereParameter(CONTENT, (Object)this.generateLikeArgument(content));
        }
        if (StringUtils.isNotBlank((String)configTags)) {
            String[] tagArr = configTags.split(",");
            context.putWhereParameter("tagARR", (Object)tagArr);
            ConfigTagsRelationMapper configTagsRelationMapper = (ConfigTagsRelationMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_tags_relation");
            sqlCountRows = configTagsRelationMapper.findConfigInfoLike4PageCountRows(context);
            sqlFetchRows = configTagsRelationMapper.findConfigInfoLike4PageFetchRows(context);
        } else {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            sqlCountRows = configInfoMapper.findConfigInfoLike4PageCountRows(context);
            sqlFetchRows = configInfoMapper.findConfigInfoLike4PageFetchRows(context);
        }
        PaginationHelper helper = this.createPaginationHelper();
        Page page = helper.fetchPageLimit(sqlCountRows, sqlFetchRows, pageNo, pageSize, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_ROW_MAPPER);
        for (ConfigInfo configInfo : page.getPageItems()) {
            Pair pair = EncryptionHandler.decryptHandler((String)configInfo.getDataId(), (String)configInfo.getEncryptedDataKey(), (String)configInfo.getContent());
            configInfo.setContent((String)pair.getSecond());
        }
        return page;
    }

    @Override
    public List<ConfigInfoStateWrapper> findChangeConfig(Timestamp startTime, long lastMaxId, int pageSize) {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        MapperContext context = new MapperContext();
        context.putWhereParameter("startTime", (Object)startTime);
        context.putWhereParameter("pageSize", (Object)pageSize);
        context.putWhereParameter("lastMaxId", (Object)lastMaxId);
        MapperResult mapperResult = configInfoMapper.findChangeConfig(context);
        return this.databaseOperate.queryMany(mapperResult.getSql(), mapperResult.getParamList().toArray(), (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_STATE_WRAPPER_ROW_MAPPER);
    }

    @Override
    public List<String> selectTagByConfig(String dataId, String group, String tenant) {
        ConfigTagsRelationMapper configTagsRelationMapper = (ConfigTagsRelationMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_tags_relation");
        String sql = configTagsRelationMapper.select(Collections.singletonList("tag_name"), Arrays.asList("data_id", "group_id", TENANT));
        return this.databaseOperate.queryMany(sql, new Object[]{dataId, group, tenant}, String.class);
    }

    @Override
    public List<ConfigInfo> findConfigInfosByIds(String ids) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return null;
        }
        ArrayList<Long> paramList = new ArrayList<Long>();
        String[] idArr = ids.split(",");
        for (int i = 0; i < idArr.length; ++i) {
            paramList.add(Long.parseLong(idArr[i]));
        }
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        MapperContext context = new MapperContext();
        context.putWhereParameter("ids", paramList);
        MapperResult mapperResult = configInfoMapper.findConfigInfosByIds(context);
        return this.databaseOperate.queryMany(mapperResult.getSql(), mapperResult.getParamList().toArray(), (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public ConfigAdvanceInfo findConfigAdvanceInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        List<String> configTagList = this.selectTagByConfig(dataId, group, tenant);
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        ConfigAdvanceInfo configAdvance = (ConfigAdvanceInfo)this.databaseOperate.queryOne(configInfoMapper.select(Arrays.asList("gmt_create", "gmt_modified", "src_user", "src_ip", "c_desc", "c_use", "effect", "type", "c_schema"), Arrays.asList("data_id", "group_id", TENANT)), new Object[]{dataId, group, tenantTmp}, (RowMapper)ConfigRowMapperInjector.CONFIG_ADVANCE_INFO_ROW_MAPPER);
        if (CollectionUtils.isNotEmpty(configTagList)) {
            StringBuilder configTagsTmp = new StringBuilder();
            for (String configTag : configTagList) {
                if (configTagsTmp.length() == 0) {
                    configTagsTmp.append(configTag);
                    continue;
                }
                configTagsTmp.append(',').append(configTag);
            }
            configAdvance.setConfigTags(configTagsTmp.toString());
        }
        return configAdvance;
    }

    @Override
    public ConfigAllInfo findConfigAllInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.select(Arrays.asList("id", "data_id", "group_id", TENANT, "app_name", CONTENT, "md5", "gmt_create", "gmt_modified", "src_user", "src_ip", "c_desc", "c_use", "effect", "type", "c_schema", "encrypted_data_key"), Arrays.asList("data_id", "group_id", TENANT));
        List<String> configTagList = this.selectTagByConfig(dataId, group, tenant);
        ConfigAllInfo configAdvance = (ConfigAllInfo)this.databaseOperate.queryOne(sql, new Object[]{dataId, group, tenantTmp}, (RowMapper)ConfigRowMapperInjector.CONFIG_ALL_INFO_ROW_MAPPER);
        if (configTagList != null && !configTagList.isEmpty()) {
            StringBuilder configTagsTmp = new StringBuilder();
            for (String configTag : configTagList) {
                if (configTagsTmp.length() == 0) {
                    configTagsTmp.append(configTag);
                    continue;
                }
                configTagsTmp.append(',').append(configTag);
            }
            configAdvance.setConfigTags(configTagsTmp.toString());
        }
        return configAdvance;
    }

    @Override
    public List<ConfigAllInfo> findAllConfigInfo4Export(String dataId, String group, String tenant, String appName, List<Long> ids) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        MapperContext context = new MapperContext();
        if (!CollectionUtils.isEmpty(ids)) {
            context.putWhereParameter("ids", ids);
        } else {
            context.putWhereParameter("tenantId", (Object)tenantTmp);
            if (!StringUtils.isBlank((CharSequence)dataId)) {
                context.putWhereParameter(DATA_ID, (Object)this.generateLikeArgument(dataId));
            }
            if (StringUtils.isNotBlank((String)group)) {
                context.putWhereParameter("groupId", (Object)group);
            }
            if (StringUtils.isNotBlank((String)appName)) {
                context.putWhereParameter("app_name", (Object)appName);
            }
        }
        MapperResult mapperResult = configInfoMapper.findAllConfigInfo4Export(context);
        return this.databaseOperate.queryMany(mapperResult.getSql(), mapperResult.getParamList().toArray(), (RowMapper)ConfigRowMapperInjector.CONFIG_ALL_INFO_ROW_MAPPER);
    }

    @Override
    public List<ConfigInfoWrapper> queryConfigInfoByNamespace(String tenantId) {
        if (Objects.isNull(tenantId)) {
            throw new IllegalArgumentException("tenantId can not be null");
        }
        String tenantTmp = StringUtils.isBlank((CharSequence)tenantId) ? "" : tenantId;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.select(Arrays.asList("data_id", "group_id", TENANT, "app_name", "type", "gmt_modified"), Collections.singletonList(TENANT));
        return this.databaseOperate.queryMany(sql, new Object[]{tenantTmp}, ConfigRowMapperInjector.CONFIG_INFO_WRAPPER_ROW_MAPPER);
    }
}

