/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.dump.disk;

import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.service.dump.disk.ConfigDiskService;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.TableFormatConfig;

public class ConfigRocksDbDiskService
implements ConfigDiskService {
    private static final String ROCKSDB_DATA = File.separator + "rocksdata" + File.separator;
    private static final String BASE_DIR = ROCKSDB_DATA + "config-data";
    private static final String BETA_DIR = ROCKSDB_DATA + "beta-data";
    private static final String TAG_DIR = ROCKSDB_DATA + "tag-data";
    private static final String BATCH_DIR = ROCKSDB_DATA + "batch-data";
    private static final long DEFAULT_WRITE_BUFFER_MB = 32L;
    Map<String, RocksDB> rocksDbMap = new HashMap<String, RocksDB>();

    private void createDirIfNotExist(String dir) {
        File baseDir;
        File roskDataDir = new File(EnvUtil.getNacosHome(), "rocksdata");
        if (!roskDataDir.exists()) {
            roskDataDir.mkdirs();
        }
        if (!(baseDir = new File(EnvUtil.getNacosHome(), dir)).exists()) {
            baseDir.mkdirs();
        }
    }

    private void deleteDirIfExist(String dir) {
        File rockskDataDir = new File(EnvUtil.getNacosHome(), "rocksdata");
        if (!rockskDataDir.exists()) {
            return;
        }
        File baseDir = new File(EnvUtil.getNacosHome(), dir);
        if (baseDir.exists()) {
            baseDir.delete();
        }
    }

    public ConfigRocksDbDiskService() {
        this.createDirIfNotExist(BASE_DIR);
        this.createDirIfNotExist(BETA_DIR);
        this.createDirIfNotExist(TAG_DIR);
        this.createDirIfNotExist(BATCH_DIR);
    }

    private byte[] getKeyByte(String dataId, String group, String tenant, String tag) throws IOException {
        String[] keys = new String[]{dataId, group, tenant, tag};
        StringBuilder stringBuilder = new StringBuilder();
        for (String key : keys) {
            if (StringUtils.isBlank((CharSequence)key)) {
                key = "";
            }
            ConfigRocksDbDiskService.urlEncode(key, stringBuilder);
            stringBuilder.append("+");
        }
        return stringBuilder.toString().getBytes("UTF-8");
    }

    private static void urlEncode(String str, StringBuilder sb) {
        for (int idx = 0; idx < str.length(); ++idx) {
            char c = str.charAt(idx);
            if ('+' == c) {
                sb.append("%2B");
                continue;
            }
            if ('%' == c) {
                sb.append("%25");
                continue;
            }
            sb.append(c);
        }
    }

    public void saveToDiskInner(String type, String dataId, String group, String tenant, String tag, String content) throws IOException {
        try {
            this.initAndGetDB(type).put(this.getKeyByte(dataId, group, tenant, tag), content.getBytes("UTF-8"));
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    public void saveToDiskInner(String type, String dataId, String group, String tenant, String content) throws IOException {
        this.saveToDiskInner(type, dataId, group, tenant, null, content);
    }

    @Override
    public void saveToDisk(String dataId, String group, String tenant, String content) throws IOException {
        this.saveToDiskInner(BASE_DIR, dataId, group, tenant, content);
    }

    @Override
    public void saveBetaToDisk(String dataId, String group, String tenant, String content) throws IOException {
        this.saveToDiskInner(BETA_DIR, dataId, group, tenant, content);
    }

    @Override
    public void saveBatchToDisk(String dataId, String group, String tenant, String content) throws IOException {
        this.saveToDiskInner(BATCH_DIR, dataId, group, tenant, content);
    }

    @Override
    public void saveTagToDisk(String dataId, String group, String tenant, String tag, String content) throws IOException {
        this.saveToDiskInner(TAG_DIR, dataId, group, tenant, tag, content);
    }

    @Override
    public void removeConfigInfo(String dataId, String group, String tenant) {
        this.removeContentInner(BASE_DIR, dataId, group, tenant, null);
    }

    @Override
    public void removeConfigInfo4Beta(String dataId, String group, String tenant) {
        this.removeContentInner(BETA_DIR, dataId, group, tenant, null);
    }

    @Override
    public void removeConfigInfo4Batch(String dataId, String group, String tenant) {
        this.removeContentInner(BATCH_DIR, dataId, group, tenant, null);
    }

    @Override
    public void removeConfigInfo4Tag(String dataId, String group, String tenant, String tag) {
        this.removeContentInner(TAG_DIR, dataId, group, tenant, tag);
    }

    private String byte2String(byte[] bytes) throws IOException {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RocksDB initAndGetDB(String dir) throws IOException, RocksDBException {
        if (this.rocksDbMap.containsKey(dir)) {
            return this.rocksDbMap.get(dir);
        }
        ConfigRocksDbDiskService configRocksDbDiskService = this;
        synchronized (configRocksDbDiskService) {
            if (this.rocksDbMap.containsKey(dir)) {
                return this.rocksDbMap.get(dir);
            }
            this.createDirIfEmpty(EnvUtil.getNacosHome() + dir);
            this.rocksDbMap.put(dir, RocksDB.open((Options)this.createOptions(dir), (String)(EnvUtil.getNacosHome() + dir)));
            return this.rocksDbMap.get(dir);
        }
    }

    private void createDirIfEmpty(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private String getContentInner(String type, String dataId, String group, String tenant) throws IOException {
        byte[] bytes = null;
        try {
            bytes = this.initAndGetDB(type).get(this.getKeyByte(dataId, group, tenant, null));
            String string = this.byte2String(bytes);
            return string;
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    private String getTagContentInner(String type, String dataId, String group, String tenant, String tag) throws IOException {
        byte[] bytes = null;
        try {
            bytes = this.initAndGetDB(type).get(this.getKeyByte(dataId, group, tenant, tag));
            return this.byte2String(bytes);
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    private void removeContentInner(String type, String dataId, String group, String tenant, String tag) {
        try {
            this.initAndGetDB(type).delete(this.getKeyByte(dataId, group, tenant, tag));
        }
        catch (Exception e) {
            LogUtil.DEFAULT_LOG.warn("Remove dir=[{}] config fail,dataId={},group={},tenant={},error={}", new Object[]{type, dataId, group, tenant, e.getCause()});
        }
    }

    @Override
    public String getBetaContent(String dataId, String group, String tenant) throws IOException {
        return this.getContentInner(BETA_DIR, dataId, group, tenant);
    }

    @Override
    public String getTagContent(String dataId, String group, String tenant, String tag) throws IOException {
        return this.getTagContentInner(TAG_DIR, dataId, group, tenant, tag);
    }

    @Override
    public String getContent(String dataId, String group, String tenant) throws IOException {
        return this.getContentInner(BASE_DIR, dataId, group, tenant);
    }

    @Override
    public String getLocalConfigMd5(String dataId, String group, String tenant, String encode) throws IOException {
        return MD5Utils.md5Hex((String)this.getContentInner(BASE_DIR, dataId, group, tenant), (String)encode);
    }

    Options createOptions(String dir) {
        DBOptions dbOptions = new DBOptions();
        dbOptions.setMaxBackgroundJobs(Runtime.getRuntime().availableProcessors());
        Options options = new Options(dbOptions, this.createColumnFamilyOptions(dir));
        options.setCreateIfMissing(true);
        return options;
    }

    ColumnFamilyOptions createColumnFamilyOptions(String dir) {
        ColumnFamilyOptions columnFamilyOptions = new ColumnFamilyOptions();
        BlockBasedTableConfig tableFormatConfig = new BlockBasedTableConfig();
        columnFamilyOptions.setTableFormatConfig((TableFormatConfig)tableFormatConfig);
        columnFamilyOptions.setWriteBufferSize(this.getSuitFormalCacheSizeMB(dir) * 1024L * 1024L);
        columnFamilyOptions.setLevel0FileNumCompactionTrigger(1);
        return columnFamilyOptions;
    }

    private long getSuitFormalCacheSizeMB(String dir) {
        boolean formal = BASE_DIR.equals(dir);
        long maxHeapSizeMB = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
        if (formal) {
            long formalWriteBufferSizeMB = 0L;
            formalWriteBufferSizeMB = maxHeapSizeMB < 8192L ? 32L : (maxHeapSizeMB < 16384L ? 64L : 256L);
            LogUtil.DEFAULT_LOG.info("init formal rocksdb write buffer size {}M for dir {}, maxHeapSize={}M", new Object[]{formalWriteBufferSizeMB, dir, maxHeapSizeMB});
            return formalWriteBufferSizeMB;
        }
        LogUtil.DEFAULT_LOG.info("init default rocksdb write buffer size {}M for dir {}, maxHeapSize={}M", new Object[]{32L, dir, maxHeapSizeMB});
        return 32L;
    }

    @Override
    public void clearAll() {
        try {
            if (this.rocksDbMap.containsKey(BASE_DIR)) {
                this.rocksDbMap.get(BASE_DIR).close();
                RocksDB.destroyDB((String)(EnvUtil.getNacosHome() + BASE_DIR), (Options)new Options());
            }
            this.deleteDirIfExist(BASE_DIR);
            LogUtil.DEFAULT_LOG.info("clear all config-info success.");
        }
        catch (RocksDBException e) {
            LogUtil.DEFAULT_LOG.warn("clear all config-info failed.", (Throwable)e);
        }
    }

    @Override
    public void clearAllBeta() {
        try {
            if (this.rocksDbMap.containsKey(BETA_DIR)) {
                this.rocksDbMap.get(BETA_DIR).close();
                RocksDB.destroyDB((String)(EnvUtil.getNacosHome() + BETA_DIR), (Options)new Options());
            }
            this.deleteDirIfExist(BETA_DIR);
            LogUtil.DEFAULT_LOG.info("clear all config-info-beta success.");
        }
        catch (RocksDBException e) {
            LogUtil.DEFAULT_LOG.warn("clear all config-info-beta failed.", (Throwable)e);
        }
    }

    @Override
    public void clearAllTag() {
        try {
            if (this.rocksDbMap.containsKey(TAG_DIR)) {
                this.rocksDbMap.get(TAG_DIR).close();
                RocksDB.destroyDB((String)(EnvUtil.getNacosHome() + TAG_DIR), (Options)new Options());
            }
            this.deleteDirIfExist(TAG_DIR);
            LogUtil.DEFAULT_LOG.info("clear all config-info-tag success.");
        }
        catch (RocksDBException e) {
            LogUtil.DEFAULT_LOG.warn("clear all config-info-tag failed.", (Throwable)e);
        }
    }

    @Override
    public void clearAllBatch() {
        try {
            if (this.rocksDbMap.containsKey(BATCH_DIR)) {
                this.rocksDbMap.get(BATCH_DIR).close();
                RocksDB.destroyDB((String)(EnvUtil.getNacosHome() + BATCH_DIR), (Options)new Options());
            }
            this.deleteDirIfExist(BATCH_DIR);
            LogUtil.DEFAULT_LOG.info("clear all config-info-batch success.");
        }
        catch (RocksDBException e) {
            LogUtil.DEFAULT_LOG.warn("clear all config-info-batch failed.", (Throwable)e);
        }
    }

    @Override
    public String getBatchContent(String dataId, String group, String tenant) throws IOException {
        return this.getContentInner(BATCH_DIR, dataId, group, tenant);
    }
}

