/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.event.DerbyImportEvent;
import com.alibaba.nacos.config.server.service.datasource.DynamicDataSource;
import com.alibaba.nacos.config.server.service.datasource.LocalDataSourceServiceImpl;
import com.alibaba.nacos.config.server.service.dump.DumpService;
import com.alibaba.nacos.config.server.service.repository.PersistService;
import com.alibaba.nacos.config.server.service.repository.embedded.DatabaseOperate;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.core.utils.WebUtils;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/cs/ops"})
public class ConfigOpsController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigOpsController.class);
    protected final PersistService persistService;
    private final DumpService dumpService;

    public ConfigOpsController(PersistService persistService, DumpService dumpService) {
        this.persistService = persistService;
        this.dumpService = dumpService;
    }

    @PostMapping(value={"/localCache"})
    public String updateLocalCacheFromStore() {
        LOGGER.info("start to dump all data from store.");
        this.dumpService.dumpAll();
        LOGGER.info("finish to dump all data from store.");
        return "200";
    }

    @PutMapping(value={"/log"})
    public String setLogLevel(@RequestParam String logName, @RequestParam String logLevel) {
        LogUtil.setLogLevel(logName, logLevel);
        return "200";
    }

    @GetMapping(value={"/derby"})
    @Secured(action=ActionTypes.READ, resource="nacos/admin")
    public RestResult<Object> derbyOps(@RequestParam(value="sql") String sql) {
        String selectSign = "SELECT";
        String limitSign = "ROWS FETCH NEXT";
        String limit = " OFFSET 0 ROWS FETCH NEXT 1000 ROWS ONLY";
        try {
            if (!PropertyUtil.isEmbeddedStorage()) {
                return RestResultUtils.failed((String)"The current storage mode is not Derby");
            }
            LocalDataSourceServiceImpl dataSourceService = (LocalDataSourceServiceImpl)DynamicDataSource.getInstance().getDataSource();
            if (StringUtils.startsWithIgnoreCase((CharSequence)sql, (CharSequence)selectSign)) {
                if (!StringUtils.containsIgnoreCase((CharSequence)sql, (CharSequence)limitSign)) {
                    sql = sql + limit;
                }
                JdbcTemplate template = dataSourceService.getJdbcTemplate();
                List result = template.queryForList(sql);
                return RestResultUtils.success((Object)result);
            }
            return RestResultUtils.failed((String)"Only query statements are allowed to be executed");
        }
        catch (Exception e) {
            return RestResultUtils.failed((String)e.getMessage());
        }
    }

    @PostMapping(value={"/data/removal"})
    @Secured(action=ActionTypes.WRITE, resource="nacos/admin")
    public DeferredResult<RestResult<String>> importDerby(@RequestParam(value="file") MultipartFile multipartFile) {
        DeferredResult response = new DeferredResult();
        if (!PropertyUtil.isEmbeddedStorage()) {
            response.setResult((Object)RestResultUtils.failed((String)"Limited to embedded storage mode"));
            return response;
        }
        DatabaseOperate databaseOperate = (DatabaseOperate)ApplicationUtils.getBean(DatabaseOperate.class);
        WebUtils.onFileUpload((MultipartFile)multipartFile, file -> {
            NotifyCenter.publishEvent((Event)new DerbyImportEvent(false));
            databaseOperate.dataImport((File)file).whenComplete((result, ex) -> {
                NotifyCenter.publishEvent((Event)new DerbyImportEvent(true));
                if (Objects.nonNull(ex)) {
                    response.setResult((Object)RestResultUtils.failed((String)ex.getMessage()));
                    return;
                }
                response.setResult(result);
            });
        }, (DeferredResult)response);
        return response;
    }
}

