/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.downloader.selenium;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;

class WebDriverPool {
    private Logger logger = Logger.getLogger(this.getClass());
    private static final int DEFAULT_CAPACITY = 5;
    private final int capacity;
    private static final int STAT_RUNNING = 1;
    private static final int STAT_CLODED = 2;
    private AtomicInteger stat = new AtomicInteger(1);
    private List<WebDriver> webDriverList = Collections.synchronizedList(new ArrayList());
    private BlockingDeque<WebDriver> innerQueue = new LinkedBlockingDeque<WebDriver>();

    public WebDriverPool(int capacity) {
        this.capacity = capacity;
    }

    public WebDriverPool() {
        this(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDriver get() throws InterruptedException {
        this.checkRunning();
        WebDriver poll = this.innerQueue.poll();
        if (poll != null) {
            return poll;
        }
        if (this.webDriverList.size() < this.capacity) {
            List<WebDriver> list = this.webDriverList;
            synchronized (list) {
                if (this.webDriverList.size() < this.capacity) {
                    ChromeDriver e = new ChromeDriver();
                    this.innerQueue.add((WebDriver)e);
                    this.webDriverList.add((WebDriver)e);
                }
            }
        }
        return this.innerQueue.take();
    }

    public void returnToPool(WebDriver webDriver) {
        this.checkRunning();
        this.innerQueue.add(webDriver);
    }

    protected void checkRunning() {
        if (!this.stat.compareAndSet(1, 1)) {
            throw new IllegalStateException("Already closed!");
        }
    }

    public void closeAll() {
        boolean b = this.stat.compareAndSet(1, 2);
        if (!b) {
            throw new IllegalStateException("Already closed!");
        }
        for (WebDriver webDriver : this.webDriverList) {
            this.logger.info((Object)("Quit webDriver" + webDriver));
            webDriver.quit();
        }
    }
}

