/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.validator.mateconstraint.impl;

import cn.hutool.core.map.MapUtil;
import jakarta.validation.constraints.Email;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import top.tangyh.basic.validator.mateconstraint.IConstraintConverter;
import top.tangyh.basic.validator.model.ConstraintInfo;

public abstract class BaseConstraintConverter
implements IConstraintConverter {
    private final List<String> methods = Collections.emptyList();

    @Override
    public boolean support(Class<? extends Annotation> clazz) {
        if (this.getSupport().isEmpty()) {
            return true;
        }
        return clazz != null && this.getSupport().contains(clazz);
    }

    @Override
    public ConstraintInfo converter(Annotation ano) throws Exception {
        Class<?> clazz = ano.getClass();
        HashMap attr = MapUtil.newHashMap();
        for (String method : this.getMethods()) {
            Object value = clazz.getMethod(method, new Class[0]).invoke((Object)ano, new Object[0]);
            if (ano instanceof Email && "regexp".equals(method) && Email.class.getMethod("regexp", new Class[0]).getDefaultValue().equals(value)) {
                value = "(?:[a-z0-9\\u4e00-\\u9fa5!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9\\u4e00-\\u9fa5!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9\\u4e00-\\u9fa5](?:[a-z0-9\\u4e00-\\u9fa5-]*[a-z0-9\\u4e00-\\u9fa5])?\\.)+[a-z0-9\\u4e00-\\u9fa5](?:[a-z0-9\\u4e00-\\u9fa5-]*[a-z0-9\\u4e00-\\u9fa5])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9\\u4e00-\\u9fa5-]*[a-z0-9\\u4e00-\\u9fa5]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)])";
            }
            attr.put(method, value);
        }
        return new ConstraintInfo().setType(this.getType(ano.annotationType())).setAttrs(attr);
    }

    protected abstract List<Class<? extends Annotation>> getSupport();

    protected List<String> getMethods() {
        return this.methods;
    }

    protected abstract String getType(Class<? extends Annotation> var1);
}

