/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.base.controller;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import top.tangyh.basic.base.R;
import top.tangyh.basic.base.controller.SuperController;
import top.tangyh.basic.base.entity.SuperEntity;
import top.tangyh.basic.base.request.PageParams;
import top.tangyh.basic.base.service.SuperCacheService;
import top.tangyh.basic.utils.BeanPlusUtil;
import top.tangyh.basic.validator.utils.ValidatorUtils;

public abstract class SuperExcelController<S extends SuperCacheService<Id, Entity>, Id extends Serializable, Entity extends SuperEntity<Id>, SaveVO, UpdateVO, PageQuery, ResultVO>
extends SuperController<S, Id, Entity, SaveVO, UpdateVO, PageQuery, ResultVO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SuperExcelController.class);
    private static final String FILE_NAME = "filename";
    protected Class<SaveVO> saveVOClass = this.currentSaveVOClass();

    @Override
    public SuperCacheService<Id, Entity> getSuperService() {
        return (SuperCacheService)this.superService;
    }

    protected Class<SaveVO> currentSaveVOClass() {
        return ReflectionKit.getSuperClassGenericType(this.getClass(), SuperExcelController.class, (int)3);
    }

    public Class<SaveVO> getSaveVOClass() {
        return this.saveVOClass;
    }

    public abstract Class<?> getExcelClass();

    @Operation(summary="\u5bfc\u51faExcel", description="\u5bfc\u51faExcel")
    @PostMapping(value={"/export"}, produces={"application/octet-stream"})
    public void exportExcel(@RequestBody @Validated PageParams<PageQuery> params, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String filename = (String)params.getExtra().getOrDefault(FILE_NAME, "\u5bfc\u51fa");
            String fileName = URLEncoder.encode(filename, StandardCharsets.UTF_8).replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            List<?> list = this.findExportList(params);
            EasyExcel.write((OutputStream)response.getOutputStream(), this.getExcelClass()).sheet("\u6a21\u677f").doWrite(list);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            R error = R.fail((String)"\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25");
            response.getWriter().println(JSONUtil.toJsonStr((Object)error));
        }
    }

    public List<?> findExportList(PageParams<PageQuery> params) {
        params.setSize(params.getSize() == -1L ? Convert.toLong((Object)Integer.MAX_VALUE).longValue() : params.getSize());
        IPage page = this.query(params);
        return BeanPlusUtil.toBeanList((Collection)page.getRecords(), this.getExcelClass());
    }

    @Operation(summary="\u5bfc\u5165Excel", description="\u5bfc\u5165Excel")
    @PostMapping(value={"/import"})
    public R<Boolean> importExcel(@RequestParam(value="file") MultipartFile simpleFile, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            List dataList = ((ExcelReaderBuilder)EasyExcel.read((InputStream)simpleFile.getInputStream()).head(this.getSaveVOClass())).sheet().doReadSync();
            String failMsg = ValidatorUtils.validateAll((List)dataList, (int)1);
            if (StrUtil.isNotEmpty((CharSequence)failMsg)) {
                return R.fail((String)failMsg);
            }
            List<Entity> list = this.validData(dataList);
            ((SuperCacheService)this.superService).saveBatch(list);
            return R.success();
        }
        catch (ExcelDataConvertException e) {
            Schema apiModelProperty;
            log.error("\u5bfc\u5165\u6570\u636e\u683c\u5f0f\u9519\u8bef", (Throwable)e);
            ExcelContentProperty excelContentProperty = e.getExcelContentProperty();
            Field field = excelContentProperty.getField();
            ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
            String name = "";
            name = excelProperty != null ? StrUtil.join((CharSequence)".", (Object[])excelProperty.value()) : ((apiModelProperty = field.getAnnotation(Schema.class)) != null ? apiModelProperty.description() : field.getName());
            Integer rowIndex = e.getRowIndex();
            Integer columnIndex = e.getColumnIndex() + 1;
            String value = e.getCellData().getStringValue();
            String msg = "\u7b2c{}\u884c\uff0c\u7b2c{}\u5217\uff0c\u5b57\u6bb5\u3010{}\u3011\u7684\u53c2\u6570\u503c\uff1a\u3010{}\u3011 \u586b\u5199\u6709\u8bef\uff0c\u8bf7\u8ba4\u771f\u68c0\u67e5\u3002";
            return R.fail((String)StrUtil.format((CharSequence)msg, (Object[])new Object[]{rowIndex, columnIndex, name, value}));
        }
    }

    protected List<Entity> validData(List<SaveVO> dataList) {
        return BeanUtil.copyToList(dataList, this.getEntityClass());
    }
}

