/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.cache.redis2;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import top.tangyh.basic.cache.redis.BaseRedis;
import top.tangyh.basic.cache.redis2.CacheResult;
import top.tangyh.basic.model.cache.CacheHashKey;
import top.tangyh.basic.model.cache.CacheKey;
import top.tangyh.basic.utils.ArgumentAssert;
import top.tangyh.basic.utils.CollHelper;

public class RedisOps
extends BaseRedis {
    public RedisOps(RedisTemplate<String, Object> redisTemplate, StringRedisTemplate stringRedisTemplate, boolean defaultCacheNullVal) {
        super(redisTemplate, stringRedisTemplate, defaultCacheNullVal);
    }

    public <T> CacheResult<T> get(@NonNull String key, boolean ... cacheNullValues) {
        boolean cacheNullVal = this.getCacheNullVal(cacheNullValues);
        Object value = this.valueOps.get((Object)key);
        if (value == null && cacheNullVal) {
            this.set(key, (Object)this.newNullVal(), true);
        }
        return new CacheResult<Object>(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> CacheResult<T> get(@NonNull String key, Function<String, T> loader, boolean ... cacheNullValues) {
        boolean cacheNullVal = this.getCacheNullVal(cacheNullValues);
        Object value = this.valueOps.get((Object)key);
        CacheResult<Object> cacheResult = new CacheResult<Object>(key);
        if (value != null) {
            cacheResult.setRawValue(value);
            return cacheResult;
        }
        if (value instanceof Collection && CollUtil.isNotEmpty((Collection)((Collection)value))) {
            cacheResult.setRawValue(value);
            return cacheResult;
        }
        Object object = KEY_LOCKS.computeIfAbsent(key, v -> new Object());
        synchronized (object) {
            value = this.valueOps.get((Object)key);
            if (value != null) {
                cacheResult.setRawValue(value);
                return cacheResult;
            }
            if (value instanceof Collection && CollUtil.isNotEmpty((Collection)((Collection)value))) {
                cacheResult.setRawValue(value);
                return cacheResult;
            }
            try {
                value = loader.apply(key);
                this.set(key, value, cacheNullVal);
            }
            finally {
                KEY_LOCKS.remove(key);
            }
        }
        cacheResult.setRawValue(value);
        return cacheResult;
    }

    public <T> CacheResult<T> getSet(@NonNull String key, Object value) {
        ArgumentAssert.notNull((Object)key, (String)"cacheKey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Object val = this.valueOps.getAndSet((Object)key, value == null ? this.newNullVal() : value);
        return new CacheResult<Object>(key, val);
    }

    @Nullable
    public <T> CacheResult<T> get(@NonNull CacheKey key, boolean ... cacheNullValues) {
        boolean cacheNullVal = this.getCacheNullVal(cacheNullValues);
        ArgumentAssert.notNull((Object)key, (String)"cacheKey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArgumentAssert.notNull((Object)key.getKey(), (String)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Object value = this.valueOps.get((Object)key.getKey());
        if (value == null && cacheNullVal) {
            this.set(key, (Object)this.newNullVal(), true);
        }
        return new CacheResult<Object>(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> CacheResult<T> get(@NonNull CacheKey key, Function<CacheKey, ? extends T> loader, boolean ... cacheNullValues) {
        ArgumentAssert.notNull((Object)key, (String)"cacheKey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArgumentAssert.notNull((Object)key.getKey(), (String)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        boolean cacheNullVal = this.getCacheNullVal(cacheNullValues);
        Object value = this.valueOps.get((Object)key.getKey());
        CacheResult<Object> cacheResult = new CacheResult<Object>(key);
        if (value != null) {
            cacheResult.setRawValue(value);
            return cacheResult;
        }
        if (value instanceof Collection && CollUtil.isNotEmpty((Collection)((Collection)value))) {
            cacheResult.setRawValue(value);
            return cacheResult;
        }
        Object object = KEY_LOCKS.computeIfAbsent(key.getKey(), v -> new Object());
        synchronized (object) {
            value = this.valueOps.get((Object)key.getKey());
            if (value != null) {
                cacheResult.setRawValue(value);
                return cacheResult;
            }
            if (value instanceof Collection && CollUtil.isNotEmpty((Collection)((Collection)value))) {
                cacheResult.setRawValue(value);
                return cacheResult;
            }
            try {
                value = loader.apply(key);
                this.set(key, value, cacheNullVal);
            }
            finally {
                KEY_LOCKS.remove(key.getKey());
            }
        }
        cacheResult.setRawValue(value);
        return cacheResult;
    }

    public <T> List<CacheResult<T>> mGet(String ... keys) {
        return this.mGet(Arrays.asList(keys));
    }

    public <T> List<CacheResult<T>> mGet(CacheKey ... keys) {
        return this.mGetByCacheKey(Arrays.asList(keys));
    }

    public <T> List<CacheResult<T>> mGet(@NonNull List<String> keys) {
        List list = this.valueOps.multiGet(keys);
        if (CollUtil.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        ArrayList<CacheResult<T>> resultList = new ArrayList<CacheResult<T>>();
        for (int i = 0; i < list.size(); ++i) {
            resultList.add(new CacheResult(keys.get(i), list.get(i)));
        }
        return resultList;
    }

    public <T> List<CacheResult<T>> mGetByCacheKey(@NonNull Collection<CacheKey> cacheKeys) {
        List<String> keys = cacheKeys.stream().map(CacheKey::getKey).toList();
        return this.mGet(keys);
    }

    @Nullable
    public <T> CacheResult<T> hGet(@NonNull String key, @NonNull Object field, boolean ... cacheNullValues) {
        boolean cacheNullVal = this.getCacheNullVal(cacheNullValues);
        Object value = this.hashOps.get((Object)key, field);
        if (value == null && cacheNullVal) {
            this.hSet(key, field, this.newNullVal(), true);
        }
        CacheResult<Object> cacheResult = new CacheResult<Object>(key, value);
        cacheResult.setField(field);
        return cacheResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> CacheResult<T> hGet(@NonNull String key, @NonNull Object field, BiFunction<String, Object, T> loader, boolean ... cacheNullValues) {
        boolean cacheNullVal = this.getCacheNullVal(cacheNullValues);
        Object value = this.hashOps.get((Object)key, field);
        CacheResult<Object> cacheResult = new CacheResult<Object>(key, value);
        cacheResult.setField(field);
        if (value != null) {
            cacheResult.setRawValue(value);
            return cacheResult;
        }
        if (value instanceof Collection && CollUtil.isNotEmpty((Collection)((Collection)value))) {
            cacheResult.setRawValue(value);
            return cacheResult;
        }
        String lockKey = key + "@" + field;
        Object object = KEY_LOCKS.computeIfAbsent(lockKey, v -> new Object());
        synchronized (object) {
            value = this.hashOps.get((Object)key, field);
            if (value != null) {
                cacheResult.setRawValue(value);
                return cacheResult;
            }
            if (value instanceof Collection && CollUtil.isNotEmpty((Collection)((Collection)value))) {
                cacheResult.setRawValue(value);
                return cacheResult;
            }
            try {
                value = loader.apply(key, field);
                this.hSet(key, field, value, cacheNullVal);
            }
            finally {
                KEY_LOCKS.remove(lockKey);
            }
        }
        cacheResult.setRawValue(value);
        return cacheResult;
    }

    @Nullable
    public <T> CacheResult<T> hGet(@NonNull CacheHashKey key, boolean ... cacheNullValues) {
        boolean cacheNullVal = this.getCacheNullVal(cacheNullValues);
        ArgumentAssert.notNull((Object)key, (String)"CacheHashKey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArgumentAssert.notEmpty((CharSequence)key.getKey(), (String)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArgumentAssert.notNull((Object)key.getField(), (String)"field\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Object value = this.hashOps.get((Object)key.getKey(), key.getField());
        if (value == null && cacheNullVal) {
            this.hSet(key, (Object)this.newNullVal(), true);
        }
        return new CacheResult<Object>(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> CacheResult<T> hGet(@NonNull CacheHashKey key, Function<CacheHashKey, T> loader, boolean ... cacheNullValues) {
        boolean cacheNullVal = this.getCacheNullVal(cacheNullValues);
        Object value = this.hashOps.get((Object)key.getKey(), key.getField());
        CacheResult<Object> cacheResult = new CacheResult<Object>(key, value);
        if (value != null) {
            cacheResult.setRawValue(value);
            return cacheResult;
        }
        if (value instanceof Collection && CollUtil.isNotEmpty((Collection)((Collection)value))) {
            cacheResult.setRawValue(value);
            return cacheResult;
        }
        String lockKey = key.getKey() + "@" + key.getField();
        Object object = KEY_LOCKS.computeIfAbsent(lockKey, v -> new Object());
        synchronized (object) {
            value = this.hashOps.get((Object)key.getKey(), key.getField());
            if (value != null) {
                cacheResult.setRawValue(value);
                return cacheResult;
            }
            if (value instanceof Collection && CollUtil.isNotEmpty((Collection)((Collection)value))) {
                cacheResult.setRawValue(value);
                return cacheResult;
            }
            try {
                value = loader.apply(key);
                this.hSet(key, value, cacheNullVal);
            }
            finally {
                KEY_LOCKS.remove(key.getKey());
            }
        }
        cacheResult.setRawValue(value);
        return cacheResult;
    }

    public List<CacheResult<Object>> hmGet(@NonNull String key, Object ... fields) {
        return this.hmGet(key, Arrays.asList(fields));
    }

    public List<CacheResult<Object>> hmGet(@NonNull String key, @NonNull List<Object> fields) {
        List list = this.hashOps.multiGet((Object)key, fields);
        ArrayList<CacheResult<Object>> result = new ArrayList<CacheResult<Object>>();
        for (int i = 0; i < list.size(); ++i) {
            CacheResult cacheResult = new CacheResult(key, list.get(i));
            cacheResult.setField(fields.get(i));
            result.add(cacheResult);
        }
        return result;
    }

    public <HV> List<CacheResult<HV>> hVals(@NonNull String key) {
        List list = this.hashOps.values((Object)key);
        return list.stream().map(o -> new CacheResult<Object>(key, o)).toList();
    }

    public <K, V> Map<K, CacheResult<V>> hGetAll(@NonNull String key) {
        Map map = this.hashOps.entries((Object)key);
        return this.returnMapVal(key, map);
    }

    public <K, V> Map<K, CacheResult<V>> hGetAll(@NonNull CacheHashKey key) {
        return this.hGetAll(key.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <K, V> Map<K, CacheResult<V>> hGetAll(@NonNull CacheHashKey key, Function<CacheHashKey, Map<K, V>> loader, boolean ... cacheNullValues) {
        boolean cacheNullVal = this.getCacheNullVal(cacheNullValues);
        Map<K, V> map = this.hashOps.entries((Object)key.getKey());
        if (MapUtil.isNotEmpty((Map)map)) {
            return this.returnMapVal(key.getKey(), map);
        }
        String lockKey = key.getKey();
        Object object = KEY_LOCKS.computeIfAbsent(lockKey, v -> new Object());
        synchronized (object) {
            map = this.hashOps.entries((Object)key.getKey());
            if (MapUtil.isNotEmpty((Map)map)) {
                return this.returnMapVal(key.getKey(), map);
            }
            try {
                map = loader.apply(key);
                this.hmSet(key.getKey(), map, cacheNullVal);
            }
            finally {
                KEY_LOCKS.remove(key.getKey());
            }
        }
        return this.returnMapVal(key.getKey(), map);
    }

    private <K, V> Map<K, CacheResult<V>> returnMapVal(String key, Map<K, V> map) {
        HashMap newMap = new HashMap(CollHelper.initialCapacity((int)map.size()));
        if (MapUtil.isNotEmpty(map)) {
            map.forEach((field, v) -> {
                CacheResult<Object> cacheResult = new CacheResult<Object>(key, v);
                newMap.put(field, cacheResult);
            });
        }
        return newMap;
    }

    private boolean getCacheNullVal(boolean ... cacheNullValues) {
        return cacheNullValues.length > 0 ? cacheNullValues[0] : this.defaultCacheNullVal;
    }
}

