/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class CacheMap<K, V> {
    private final Map<K, CacheItem<V>> cache = new ConcurrentHashMap<K, CacheItem<V>>();
    private final long cleanupIntervalNanos = TimeUnit.MINUTES.toNanos(10L);
    private final AtomicLong cleanupTimeNanos = new AtomicLong(System.nanoTime() + this.cleanupIntervalNanos);

    public V get(K key) {
        CacheItem cacheItem = this.cache.computeIfPresent(key, (kk, vv) -> vv.isExpired() ? null : vv);
        return cacheItem == null ? null : (V)cacheItem.item;
    }

    public V get(K key, V defaultItemValue, long itemExpirationNano) {
        CacheItem cacheItem = this.cache.compute(key, (kk, vv) -> vv == null || vv.isExpired() ? new CacheItem<Object>(defaultItemValue, System.nanoTime() + itemExpirationNano) : vv);
        return cacheItem.item;
    }

    public void put(K key, V item, long itemExpirationNano) {
        this.cache.put(key, new CacheItem<V>(item, System.nanoTime() + itemExpirationNano));
        this.cleanUp();
    }

    public void putIfAbsent(K key, V item, long itemExpirationNano) {
        this.cache.putIfAbsent(key, new CacheItem<V>(item, System.nanoTime() + itemExpirationNano));
        this.cleanUp();
    }

    public void remove(K key) {
        this.cache.remove(key);
        this.cleanUp();
    }

    public void clear() {
        this.cache.clear();
    }

    public int size() {
        return this.cache.size();
    }

    private void cleanUp() {
        if (this.cleanupTimeNanos.get() < System.nanoTime()) {
            this.cleanupTimeNanos.set(System.nanoTime() + this.cleanupIntervalNanos);
            this.cache.forEach((key, value) -> {
                if (value == null || value.isExpired()) {
                    this.cache.remove(key);
                }
            });
        }
    }

    private static class CacheItem<V> {
        final V item;
        final long expirationTime;

        public CacheItem(V item, long expirationTime) {
            this.item = item;
            this.expirationTime = expirationTime;
        }

        boolean isExpired() {
            return System.nanoTime() > this.expirationTime;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheItem other = (CacheItem)obj;
            if (this.item == null) {
                return other.item == null;
            }
            return this.item.equals(other.item);
        }

        public String toString() {
            return "CacheItem [item=" + this.item + ", expirationTime=" + this.expirationTime + "]";
        }
    }
}

